/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class MakeshiftEquipment {
    public static float SUPPLY_USE_REDUCTION_MAX_PERCENT = 50.0f;
    public static float SUPPLY_USE_REDUCTION_MAX_UNITS = 100.0f;
    public static float SURVEY_COST_MULT = 0.5f;
    public static float MINING_VALUE_MULT = 1.5f;
    public static float UPKEEP_MULT = 0.8f;
    public static String SUPPLIES_EFFECT_ID = "surveying_supply_use_mod";

    public static class Level1
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            String desc = "\u4e34\u65f6\u8bbe\u5907";
            stats.getDynamic().getStat("survey_cost_mult").modifyMult(id, SURVEY_COST_MULT, desc);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("survey_cost_mult").unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return "-" + Math.round((1.0f - SURVEY_COST_MULT) * 100.0f) + "% \u52d8\u63a2\u884c\u661f\u65f6\u6240\u9700\u7684\u8d44\u6e90";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            String desc = "\u4e34\u65f6\u8bbe\u5907";
            stats.getDynamic().getStat("planet_mining_value_mult").modifyMult(id, SURVEY_COST_MULT, desc);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("planet_mining_value_mult").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round((1.0f - SURVEY_COST_MULT) * 100.0f) + "% \u4ece\u672a\u88ab\u6b96\u6c11\u7684\u661f\u7403\u5730\u8868\u77ff\u85cf\u4e2d\u63d0\u53d6\u5230\u7684\u8d44\u6e90";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            id = SUPPLIES_EFFECT_ID;
            float useMult = this.getSupplyUseMult(id, Level3.getFleetData(stats));
            stats.getSuppliesPerMonth().modifyMult(id, useMult);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            id = SUPPLIES_EFFECT_ID;
            stats.getSuppliesPerMonth().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        protected float getSupplyUseBase(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            float supplyUse = 0.0f;
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                MutableStat stat = curr.getStats().getSuppliesPerMonth();
                MutableStat.StatMod mod = stat.getMultStatMod(id);
                if (mod != null) {
                    stat.unmodifyMult(mod.source);
                }
                supplyUse += stat.getModifiedValue();
                if (mod == null) continue;
                stat.modifyMult(mod.source, mod.value, mod.desc);
            }
            return supplyUse;
        }

        protected float getSupplyUseMult(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            String key = "makeshift1";
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float supplyUse = this.getSupplyUseBase(id, data);
            float useMult = 0.0f;
            if (supplyUse > 0.0f) {
                float maxReduced = Math.min(supplyUse * (SUPPLY_USE_REDUCTION_MAX_PERCENT * 0.01f), SUPPLY_USE_REDUCTION_MAX_UNITS);
                useMult = 1.0f - maxReduced / supplyUse;
            }
            data.getCacheClearedOnSync().put(key, Float.valueOf(useMult));
            return useMult;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("\u6bcf\u6708\u8230\u8239\u7ef4\u62a4\u6240\u9700\u8865\u7ed9 -%s \u6216 %s \u5355\u4f4d\uff0c\u6309\u4e24\u8005\u4e2d\u8f83\u4f4e\u8005\u8ba1\u7b97", 0.0f, this.hc, this.hc, (int)SUPPLY_USE_REDUCTION_MAX_PERCENT + "%", "" + (int)SUPPLY_USE_REDUCTION_MAX_UNITS);
            if (Level3.isInCampaign()) {
                FleetDataAPI data = Global.getSector().getPlayerFleet().getFleetData();
                String id = SUPPLIES_EFFECT_ID;
                float supplyUse = this.getSupplyUseBase(id, data);
                float useMult = this.getSupplyUseMult(id, data);
                float reduction = supplyUse * (1.0f - useMult);
                boolean has = stats.getSkillLevel(skill.getId()) > 0.0f;
                String string = ", ";
                if (!has) {
                    string = ", ";
                }
                info.addPara(String.valueOf(this.indent) + "\u4f60\u7684\u8230\u961f\u5f53\u524d\u6bcf\u6708\u7ef4\u62a4\u6240\u9700\u8865\u7ed9\u4e3a %s" + string + "\u73b0\u5728\u964d\u4f4e %s \u6216 %s \u5355\u4f4d", 0.0f, this.tc, this.hc, Misc.getRoundedValueMaxOneAfterDecimal(supplyUse), Math.round((1.0f - useMult) * 100.0f) + "%", Misc.getRoundedValueMaxOneAfterDecimal(reduction));
            }
            info.addSpacer(5.0f);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

