/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class MissileSpecialization {
    public static final float MISSILE_AMMO_BONUS = 100.0f;
    public static final float MISSILE_SPEC_PERK_HEALTH_BONUS = 25.0f;
    public static final float MISSILE_SPEC_ROF_BONUS = 25.0f;
    public static final float MISSILE_SPEC_AMMO_REGEN_BONUS = 25.0f;
    public static final float MISSILE_SPEC_DAMAGE_BONUS = 10.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileAmmoBonus().modifyPercent(id, 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileAmmoBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+100% \u5bfc\u5f39\u6b66\u5668\u5907\u5f39\u91cf";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileHealthBonus().modifyPercent(id, 25.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileHealthBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+50% \u5bfc\u5f39\u751f\u547d\u503c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileRoFMult().modifyPercent(id, 25.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileRoFMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+50% \u5bfc\u5f39\u6b66\u5668\u5c04\u901f";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileAmmoRegenMult().modifyPercent(id, 25.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileAmmoRegenMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+25% \u5bfc\u5f39\u6b66\u5668\u5907\u5f39\u91cf\u56de\u590d\u901f\u7387 (\u4ec5\u5bf9\u80fd\u81ea\u884c\u56de\u590d\u5907\u5f39\u91cf\u7684\u6b66\u5668\u751f\u6548)";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileWeaponDamageMult().modifyPercent(id, 10.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileWeaponDamageMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+10% \u5bfc\u5f39\u6b66\u5668\u9020\u6210\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

