/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class Navigation {
    public static float TERRAIN_PENALTY_REDUCTION = 30.0f;
    public static float FUEL_USE_REDUCTION = 25.0f;
    public static float FLEET_BURN_BONUS = 1.0f;
    public static float SB_BURN_BONUS = 1.0f;
    public static float FUEL_USE_REDUCTION_MAX_PERCENT = 50.0f;
    public static float FUEL_USE_REDUCTION_MAX_FUEL = 25.0f;
    public static String FUEL_EFFECT_ID = "nav_fuel_use_mod";

    public static class Level1
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("nav_penalty_mult").modifyFlat(id, -0.01f * TERRAIN_PENALTY_REDUCTION);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getStat("nav_penalty_mult").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)TERRAIN_PENALTY_REDUCTION + "% \u7279\u6b8a\u5730\u5f62\u7684\u79fb\u52a8\u901f\u5ea6\u60e9\u7f5a";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level1B
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("can_see_nascent_points").modifyFlat(id, 1.0f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("can_see_nascent_points").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u53ef\u4ee5\u5728\u661f\u7cfb\u5468\u56f4\u7684\u8d85\u7a7a\u95f4\u4e2d\u68c0\u6d4b\u51fa\u4e9a\u4e34\u754c\u91cd\u529b\u4e95";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getFuelUseMod().modifyMult(id, 1.0f - FUEL_USE_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFuelUseMod().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)FUEL_USE_REDUCTION + "% \u71c3\u6599\u6d88\u8017";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level3A
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getFleetwideMaxBurnMod().modifyFlat(id, FLEET_BURN_BONUS, "\u7cbe\u51c6\u5bfc\u822a");
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getFleetwideMaxBurnMod().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)FLEET_BURN_BONUS + " \u6700\u5927\u5b87\u5b99\u822a\u884c\u901f\u5ea6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3B
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("sustained_burn_bonus").modifyFlat(id, SB_BURN_BONUS);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("sustained_burn_bonus").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "\"\u6301\u7eed\u52a0\u901f\" \u5e26\u6765\u7684\u901f\u5ea6\u589e\u76ca +" + (int)SB_BURN_BONUS;
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            id = FUEL_EFFECT_ID;
            float useMult = this.getFuelUseMult(id, Level4.getFleetData(stats));
            stats.getFuelUseMod().modifyMult(id, useMult);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            id = FUEL_EFFECT_ID;
            stats.getFuelUseMod().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        protected float getFuelUseBase(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            float fuelUse = 0.0f;
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                StatBonus stat = curr.getStats().getFuelUseMod();
                MutableStat.StatMod mod = stat.getMultBonus(id);
                if (mod != null) {
                    stat.unmodifyMult(mod.source);
                }
                fuelUse += curr.getFuelUse();
                if (mod == null) continue;
                stat.modifyMult(mod.source, mod.value, mod.desc);
            }
            return fuelUse;
        }

        protected float getFuelUseMult(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            String key = "nav1";
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float fuelUse = this.getFuelUseBase(id, data);
            float useMult = 0.0f;
            if (fuelUse > 0.0f) {
                float maxReduced = Math.min(fuelUse * (FUEL_USE_REDUCTION_MAX_PERCENT * 0.01f), FUEL_USE_REDUCTION_MAX_FUEL);
                useMult = 1.0f - maxReduced / fuelUse;
                useMult = (float)Math.round(useMult * 100.0f) / 100.0f;
            }
            data.getCacheClearedOnSync().put(key, Float.valueOf(useMult));
            return useMult;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("\u964d\u4f4e %s \u6216 %s \u5355\u4f4d\u7684\u71c3\u6599\u6d88\u8017\uff0c\u6309\u4e24\u8005\u4e2d\u8f83\u4f4e\u8005\u8ba1\u7b97", 0.0f, this.hc, this.hc, (int)FUEL_USE_REDUCTION_MAX_PERCENT + "%", "" + (int)FUEL_USE_REDUCTION_MAX_FUEL);
            if (Level4.isInCampaign()) {
                FleetDataAPI data = Global.getSector().getPlayerFleet().getFleetData();
                String id = FUEL_EFFECT_ID;
                float fuelUse = this.getFuelUseBase(id, data);
                float useMult = this.getFuelUseMult(id, data);
                float reduction = fuelUse * (1.0f - useMult);
                boolean has = stats.getSkillLevel(skill.getId()) > 0.0f;
                String string = ", ";
                if (!has) {
                    string = ", ";
                }
                info.addPara(String.valueOf(this.indent) + "\u4f60\u7684\u8230\u961f\u57fa\u7840\u71c3\u6599\u6d88\u8017\u4e3a %s" + string + "\u73b0\u5728\u964d\u4f4e %s \u6216 %s \u5355\u4f4d", 0.0f, this.tc, this.hc, Misc.getRoundedValueMaxOneAfterDecimal(fuelUse), Math.round((1.0f - useMult) * 100.0f) + "%", Misc.getRoundedValueMaxOneAfterDecimal(reduction));
                info.addSpacer(5.0f);
            }
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

