/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.WeaponGroupSpec;
import com.fs.starfarer.api.mission.FleetSide;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.input.Mouse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeuralLinkScript
extends BaseEveryFrameCombatPlugin {
    public static String TRANSFER_CONTROL = "SHIP_TOGGLE_XPAN_MODE";
    public static float INSTANT_TRANSFER_DP = 50.0f;
    public static float TRANSFER_SECONDS_PER_DP = 0.125f;
    public static float TRANSFER_MAX_SECONDS = 5.0f;
    public static float TRANSFER_MIN_SECONDS_IF_NOT_INSTANT = 1.0f;
    public static boolean ALLOW_ENGINE_CONTROL_DURING_TRANSFER = false;
    public static final Object KEY_STATUS = new Object();
    public static final Object KEY_STATUS2 = new Object();
    public static final String TRANSFER_COMPLETE_KEY = "neural_transfer_complete_key";
    protected CombatEngineAPI engine;
    protected ShipAPI prevPlayerShip = null;
    protected int skipFrames = 0;
    protected List<ShipAPI> linked = new ArrayList<ShipAPI>();
    protected float untilTransfer;
    protected int lastShownTime = 0;
    protected SavedShipControlState prevState;
    protected SavedShipControlState savedState;
    protected PersonAPI playerPerson;

    @Override
    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    public void saveControlState(ShipAPI ship) {
        this.prevState = this.savedState;
        this.savedState = new SavedShipControlState();
        this.savedState.ship = ship;
        for (WeaponGroupAPI group : ship.getWeaponGroupsCopy()) {
            this.savedState.autofiring.put(group, group.isAutofiring());
        }
        this.savedState.selected = ship.getSelectedGroupAPI();
    }

    public void restoreControlState(ShipAPI ship) {
        if (ship == null) {
            return;
        }
        if (this.prevState == null || this.prevState.ship != ship) {
            List<WeaponGroupAPI> groups = ship.getWeaponGroupsCopy();
            int index = 0;
            for (WeaponGroupSpec groupSpec : ship.getVariant().getWeaponGroups()) {
                if (index >= groups.size()) break;
                boolean auto = groupSpec.isAutofireOnByDefault();
                WeaponGroupAPI group = groups.get(index);
                if (group != null) {
                    if (auto) {
                        group.toggleOn();
                    } else {
                        group.toggleOff();
                    }
                }
                ++index;
            }
            if (groups.size() >= 1) {
                ship.giveCommand(ShipCommand.SELECT_GROUP, null, 0);
            }
            return;
        }
        for (WeaponGroupAPI group : ship.getWeaponGroupsCopy()) {
            Boolean auto = this.prevState.autofiring.get(group);
            if (auto == null) {
                auto = false;
            }
            if (auto.booleanValue()) {
                group.toggleOn();
                continue;
            }
            group.toggleOff();
        }
        int index = ship.getWeaponGroupsCopy().indexOf(this.prevState.selected);
        if (index > 0) {
            ship.giveCommand(ShipCommand.SELECT_GROUP, null, index);
        }
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        ShipAPI playerShip = this.engine.getPlayerShip();
        if (playerShip == null) {
            return;
        }
        if (!playerShip.isAlive()) {
            this.untilTransfer = 0.0f;
            this.lastShownTime = 0;
        }
        if (this.untilTransfer > 0.0f) {
            float timeMult = playerShip.getMutableStats().getTimeMult().getModifiedValue();
            this.untilTransfer -= amount * timeMult;
            Global.getSoundPlayer().applyLowPassFilter(0.75f, 0.0f);
            this.engine.getCombatUI().hideShipInfo();
            if (this.untilTransfer <= 0.0f) {
                this.untilTransfer = 0.0f;
                Global.getSoundPlayer().playUISound("ui_neural_transfer_complete", 1.0f, 1.0f);
                playerShip.setCustomData(TRANSFER_COMPLETE_KEY, true);
                this.showTranferFloatyIfNeeded();
                this.engine.getCombatUI().reFanOutShipInfo();
                boolean autopilot = this.engine.getCombatUI().isAutopilotOn();
                if (autopilot) {
                    if (playerShip.getAI() == null) {
                        CombatFleetManagerAPI manager = this.engine.getFleetManager(FleetSide.PLAYER);
                        DeployedFleetMemberAPI member = manager.getDeployedFleetMember(playerShip);
                        playerShip.setShipAI(Global.getSettings().pickShipAIPlugin(member == null ? null : member.getMember(), playerShip));
                    }
                } else {
                    playerShip.setShipAI(null);
                    this.restoreControlState(playerShip);
                }
            } else {
                this.suppressControlsDuringTransfer(playerShip);
                this.showTranferFloatyIfNeeded();
            }
        }
        if (playerShip != this.prevPlayerShip) {
            this.prevPlayerShip = playerShip;
            this.skipFrames = 30;
        }
        if (this.skipFrames > 0) {
            --this.skipFrames;
            return;
        }
        this.updateLinkState();
    }

    public void suppressControlsDuringTransfer(ShipAPI playerShip) {
        if (ALLOW_ENGINE_CONTROL_DURING_TRANSFER) {
            playerShip.blockCommandForOneFrame(ShipCommand.FIRE);
            playerShip.blockCommandForOneFrame(ShipCommand.TOGGLE_AUTOFIRE);
            playerShip.blockCommandForOneFrame(ShipCommand.PULL_BACK_FIGHTERS);
            playerShip.blockCommandForOneFrame(ShipCommand.VENT_FLUX);
            playerShip.blockCommandForOneFrame(ShipCommand.USE_SELECTED_GROUP);
            playerShip.blockCommandForOneFrame(ShipCommand.USE_SYSTEM);
            playerShip.blockCommandForOneFrame(ShipCommand.HOLD_FIRE);
        } else {
            this.engine.getCombatUI().setDisablePlayerShipControlOneFrame(true);
        }
    }

    public void showTranferFloatyIfNeeded() {
        ShipAPI playerShip = this.engine.getPlayerShip();
        if (playerShip == null) {
            return;
        }
        float timeMult = playerShip.getMutableStats().getTimeMult().getModifiedValue();
        Color color = new Color(0, 121, 216, 255);
        int show = (int)Math.ceil(this.untilTransfer);
        if (show != this.lastShownTime) {
            if (show > 0) {
                this.engine.addFloatingTextAlways(playerShip.getLocation(), "\u795e\u7ecf\u4f20\u9012\u4e2d\uff1a" + show, NeuralLinkScript.getFloatySize(playerShip), color, playerShip, 4.0f * timeMult, 0.8f / timeMult, 1.0f / timeMult, 0.0f, 0.0f, 1.0f);
            }
            this.lastShownTime = show;
        }
    }

    public boolean canLink(ShipAPI ship) {
        ShipAPI playerShip = this.engine.getPlayerShip();
        if (ship == playerShip && ship.getOriginalCaptain() != null && !ship.getOriginalCaptain().isDefault() && !ship.getOriginalCaptain().isPlayer()) {
            return false;
        }
        if ((this.engine.isInCampaign() || this.engine.isInCampaignSim()) && Global.getSector().getPlayerStats().getDynamic().getMod("has_neural_link").computeEffective(0.0f) <= 0.0f) {
            return false;
        }
        boolean aliveOrDisabledButNonPhysical = ship.isAlive();
        ShipAPI physicalLocation = this.engine.getShipPlayerLastTransferredCommandTo();
        if (ship == playerShip && ship != physicalLocation) {
            aliveOrDisabledButNonPhysical = true;
        }
        return aliveOrDisabledButNonPhysical && !ship.isShuttlePod() && ship.getMutableStats().getDynamic().getMod("has_neural_link").computeEffective(0.0f) > 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void updateLinkState() {
        PersonAPI player;
        ShipAPI playerShip = this.engine.getPlayerShip();
        if (playerShip == null) {
            return;
        }
        ShipAPI physicalLocation = this.engine.getShipPlayerLastTransferredCommandTo();
        for (ShipAPI ship : new ArrayList<ShipAPI>(this.linked)) {
            if (ship.isAlive() || ship == playerShip && ship != physicalLocation) continue;
            if (ship != playerShip) {
                Object orig = ship.getOriginalCaptain();
                if (orig.isPlayer()) {
                    orig = Global.getFactory().createPerson();
                    if (this.engine.isInCampaign() || this.engine.isInCampaignSim()) {
                        orig.setPersonality(Global.getSector().getPlayerFaction().pickPersonality());
                    }
                }
                ship.setCaptain((PersonAPI)orig);
            }
            this.linked.remove(ship);
        }
        boolean physicallyPresent = this.linked.contains(physicalLocation);
        if (!(this.linked.contains(playerShip) && physicallyPresent && this.canLink(playerShip))) {
            for (ShipAPI ship : this.linked) {
                PersonAPI orig = ship.getOriginalCaptain();
                if (orig.isPlayer()) {
                    orig = Global.getFactory().createPerson();
                    if (this.engine.isInCampaign() || this.engine.isInCampaignSim()) {
                        orig.setPersonality(Global.getSector().getPlayerFaction().pickPersonality());
                    }
                }
                if (ship.getCaptain() == orig) continue;
                ship.setCaptain(orig);
                if (ship.getFleetMember() == null) continue;
                ship.getFleetMember().setCaptain(ship.getOriginalCaptain());
            }
            this.linked.clear();
            if (this.canLink(playerShip)) {
                this.linked.add(playerShip);
            }
        }
        if (this.linked.isEmpty()) {
            return;
        }
        CombatFleetManagerAPI manager = this.engine.getFleetManager(FleetSide.PLAYER);
        List<DeployedFleetMemberAPI> members = manager.getDeployedCopyDFM();
        if (physicallyPresent) {
            for (DeployedFleetMemberAPI dfm : members) {
                ShipAPI shipAPI;
                if (this.linked.size() >= 2) break;
                if (dfm.isFighterWing() || dfm.isAlly() || this.linked.contains(shipAPI = dfm.getShip()) || !shipAPI.getCaptain().isDefault() && shipAPI != playerShip && !shipAPI.getCaptain().isPlayer() || shipAPI == playerShip && shipAPI.getOriginalCaptain() != null && !shipAPI.getOriginalCaptain().isDefault() && !shipAPI.getOriginalCaptain().isPlayer() || shipAPI.controlsLocked() || !this.canLink(shipAPI)) continue;
                this.linked.add(shipAPI);
            }
        }
        if ((player = this.playerPerson) == null && !(player = playerShip.getCaptain()).isDefault() && this.playerPerson == null) {
            this.playerPerson = player;
        }
        for (ShipAPI ship : this.linked) {
            if (ship.getCaptain() == player) continue;
            ship.setCaptain(player);
            if (ship.getFleetMember() == null) continue;
            ship.getFleetMember().setCaptain(player);
        }
        if (this.linked.contains(playerShip)) {
            ShipAPI other = null;
            for (ShipAPI shipAPI : this.linked) {
                if (shipAPI == playerShip) continue;
                other = shipAPI;
                break;
            }
            String string = "\u6218\u672f\u7cfb\u7edf\u91cd\u7f6e";
            String icon = Global.getSettings().getSpriteName("ui", "icon_neural_link");
            String key = "neural_interface_reset_timeout";
            Float timeout = null;
            if (other != null) {
                timeout = (Float)other.getCustomData().get(key);
            }
            if (timeout == null) {
                timeout = Float.valueOf(0.0f);
            }
            if (other == null) {
                this.engine.maintainStatusForPlayerShip(KEY_STATUS2, icon, string, "\u65e0\u8fde\u63a5\u76ee\u6807", true);
            } else if (timeout.floatValue() <= 0.0f) {
                this.engine.maintainStatusForPlayerShip(KEY_STATUS2, icon, string, "\u7cfb\u7edf\u51b7\u5374\u5b8c\u6bd5", false);
            } else {
                int show = (int)Math.ceil(timeout.floatValue());
                this.engine.maintainStatusForPlayerShip(KEY_STATUS2, icon, string, "\u91cd\u7f6e " + show + " \u79d2", true);
            }
        }
        for (ShipAPI ship : this.linked) {
            if (ship == playerShip) continue;
            if (this.untilTransfer <= 0.0f) {
                String title = "\u795e\u7ecf\u94fe\u63a5 [\u5df2\u6fc0\u6d3b] ";
                String data = "\u8fde\u63a5\u76ee\u6807\uff1a" + ship.getHullSpec().getHullNameWithDashClass();
                String icon = Global.getSettings().getSpriteName("ui", "icon_neural_link");
                this.engine.maintainStatusForPlayerShip(KEY_STATUS, icon, title, data, false);
                break;
            }
            int show = (int)Math.ceil(this.untilTransfer);
            if (show <= 0) break;
            String title = "\u795e\u7ecf\u4f20\u9012";
            String data = "\u79bb\u795e\u7ecf\u4f20\u9012\u5b8c\u6bd5\u8fd8\u9700\uff1a" + show + " \u79d2";
            String icon = Global.getSettings().getSpriteName("ui", "icon_neural_link");
            this.engine.maintainStatusForPlayerShip(KEY_STATUS, icon, title, data, true);
            break;
        }
        if (this.linked.size() <= 1 && this.linked.contains(playerShip)) {
            void var8_18;
            String title = "\u795e\u7ecf\u94fe\u63a5 [\u672a\u6fc0\u6d3b] ";
            String string = "\u65e0\u8fde\u63a5\u76ee\u6807";
            if (!physicallyPresent) {
                String string2 = "\u9700\u8981\u7269\u7406\u4f20\u8f93";
            }
            String icon = Global.getSettings().getSpriteName("ui", "icon_neural_link");
            this.engine.maintainStatusForPlayerShip(KEY_STATUS, icon, title, (String)var8_18, true);
        }
    }

    @Override
    public void processInputPreCoreControls(float amount, List<InputEventAPI> events) {
        if (this.engine == null || this.engine.getCombatUI() == null || this.engine.getCombatUI().isShowingCommandUI()) {
            return;
        }
        ShipAPI playerShip = this.engine.getPlayerShip();
        if (playerShip == null) {
            return;
        }
        if (!this.linked.contains(playerShip) || this.linked.size() < 2) {
            return;
        }
        for (InputEventAPI event : events) {
            if (event.isConsumed() || !event.isControlDownEvent(TRANSFER_CONTROL)) continue;
            if (this.untilTransfer <= 0.0f) {
                for (ShipAPI ship : this.linked) {
                    if (ship == playerShip) continue;
                    this.untilTransfer = this.getTransferTime();
                    this.lastShownTime = 0;
                    this.doTransfer(ship);
                }
            }
            event.consume();
            return;
        }
    }

    public void doTransfer(ShipAPI ship) {
        if (ship == null) {
            return;
        }
        ShipAPI playerShip = this.engine.getPlayerShip();
        if (playerShip == null) {
            return;
        }
        if (!this.linked.contains(playerShip)) {
            return;
        }
        if (!this.linked.contains(ship)) {
            return;
        }
        if (this.untilTransfer <= 0.0f) {
            Global.getSoundPlayer().playUISound("ui_neural_transfer_complete", 1.0f, 1.0f);
            ship.setCustomData(TRANSFER_COMPLETE_KEY, true);
            this.showTranferFloatyIfNeeded();
            this.engine.getCombatUI().reFanOutShipInfo();
        } else {
            Global.getSoundPlayer().playUISound("ui_neural_transfer_begin", 1.0f, 1.0f);
        }
        Mouse.setCursorPosition((int)((int)Global.getSettings().getScreenWidthPixels() / 2), (int)((int)Global.getSettings().getScreenHeightPixels() / 2));
        this.saveControlState(playerShip);
        ShipAIPlugin playerShipAI = playerShip.getShipAI();
        ShipAIPlugin prevTargetAI = ship.getShipAI();
        this.engine.setPlayerShipExternal(ship);
        if (ship.getFleetMember() != null) {
            ship.getFleetMember().setCaptain(playerShip.getCaptain());
        }
        if (playerShipAI != null) {
            playerShip.setShipAI(playerShipAI);
        }
        boolean autopilot = this.engine.getCombatUI().isAutopilotOn();
        if (this.untilTransfer > 0.0f) {
            if (!ALLOW_ENGINE_CONTROL_DURING_TRANSFER) {
                ship.setShipAI(prevTargetAI);
            }
            this.suppressControlsDuringTransfer(ship);
            this.showTranferFloatyIfNeeded();
        } else if (autopilot) {
            CombatFleetManagerAPI manager = this.engine.getFleetManager(FleetSide.PLAYER);
            DeployedFleetMemberAPI member = manager.getDeployedFleetMember(ship);
            ship.setShipAI(Global.getSettings().pickShipAIPlugin(member == null ? null : member.getMember(), ship));
        }
        if (this.untilTransfer <= 0.0f) {
            this.showTranferFloatyIfNeeded();
            if (!autopilot) {
                this.restoreControlState(ship);
            }
        }
    }

    public float getTransferTime() {
        float total = 0.0f;
        for (ShipAPI ship : this.linked) {
            if (ship.getFleetMember() == null) continue;
            total += ship.getFleetMember().getDeploymentPointsCost();
        }
        if ((total = (float)Math.round(total)) <= INSTANT_TRANSFER_DP) {
            return 0.0f;
        }
        float time = (total - INSTANT_TRANSFER_DP) * TRANSFER_SECONDS_PER_DP;
        if (time < TRANSFER_MIN_SECONDS_IF_NOT_INSTANT) {
            time = TRANSFER_MIN_SECONDS_IF_NOT_INSTANT;
        } else if (time > TRANSFER_MAX_SECONDS) {
            time = TRANSFER_MAX_SECONDS;
        }
        time = (float)Math.ceil(time);
        return time;
    }

    @Override
    public void renderInUICoords(ViewportAPI viewport) {
    }

    @Override
    public void renderInWorldCoords(ViewportAPI viewport) {
    }

    public static float getFloatySize(ShipAPI ship) {
        switch (ship.getHullSize()) {
            case FIGHTER: {
                return 15.0f;
            }
            case FRIGATE: {
                return 17.0f;
            }
            case DESTROYER: {
                return 21.0f;
            }
            case CRUISER: {
                return 24.0f;
            }
            case CAPITAL_SHIP: {
                return 27.0f;
            }
        }
        return 10.0f;
    }

    public static class SavedShipControlState {
        public ShipAPI ship;
        public Map<WeaponGroupAPI, Boolean> autofiring = new LinkedHashMap<WeaponGroupAPI, Boolean>();
        public WeaponGroupAPI selected;
    }
}

