/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class OfficerTraining {
    public static final float MAX_LEVEL_BONUS = 1.0f;
    public static final float MAX_ELITE_SKILLS_BONUS = 1.0f;
    public static final float CP_BONUS = 2.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            int base = Global.getSettings().getInt("officerMaxLevel");
            return "* \u519b\u5b98\u57fa\u7840\u7b49\u7ea7\u4e0a\u9650\u4e3a " + base + ".";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        public String[] getHighlights() {
            int base = Global.getSettings().getInt("officerMaxLevel");
            return new String[]{"" + base};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("officer_max_level_mod").modifyFlat(id, 1.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("officer_max_level_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+1 \u519b\u5b98\u7b49\u7ea7\u4e0a\u9650*";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.NONE;
        }
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("officer_max_elite_skills_mod").modifyFlat(id, 1.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("officer_max_elite_skills_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+1 \u519b\u5b98\u6700\u5927\u7cbe\u82f1\u6280\u80fd\u6570\u91cf";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.NONE;
        }
    }

    public static class Level3
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getCommandPoints().modifyFlat(id, 2.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getCommandPoints().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+2 \u6307\u6325\u70b9";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

