/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.util.Misc;

public class OrdnanceExpertise {
    public static float MAX_CR_BONUS = 15.0f;
    public static float FLUX_PER_OP = 1.5f;
    public static float CAP_PER_OP = 20.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (stats.getVariant() != null) {
                MutableCharacterStatsAPI cStats = BaseSkillEffectDescription.getCommanderStats(stats);
                float flux = FLUX_PER_OP * (float)stats.getVariant().computeWeaponOPCost(cStats);
                stats.getFluxDissipation().modifyFlat(id, flux);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFluxDissipation().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            if ((float)((int)FLUX_PER_OP) != FLUX_PER_OP) {
                return "\u6bcf\u5728\u6b66\u5668\u4e0a\u82b1\u8d39\u4e00\u4e2a\u88c5\u914d\u70b9\u5c31 + " + Misc.getRoundedValueMaxOneAfterDecimal(FLUX_PER_OP) + " \u70b9 \u5e45\u80fd\u8017\u6563";
            }
            return "\u6bcf\u5728\u6b66\u5668\u4e0a\u82b1\u8d39\u4e00\u4e2a\u88c5\u914d\u70b9\u5c31 + " + (int)FLUX_PER_OP + " \u70b9 \u5e45\u80fd\u8017\u6563";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxCombatReadiness().modifyFlat(id, MAX_CR_BONUS * 0.01f, "\u519b\u68b0\u4e13\u957f");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)MAX_CR_BONUS + "% \u6218\u5907\u503c (CR) \u4e0a\u9650";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (stats.getVariant() != null) {
                MutableCharacterStatsAPI cStats = BaseSkillEffectDescription.getCommanderStats(stats);
                float flux = CAP_PER_OP * (float)stats.getVariant().computeWeaponOPCost(cStats);
                stats.getFluxCapacity().modifyFlat(id, flux);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFluxCapacity().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "\u6bcf\u5728\u6b66\u5668\u4e0a\u82b1\u8d39\u4e00\u4e2a\u88c5\u914d\u70b9\u5c31 + " + (int)CAP_PER_OP + " \u70b9 \u5e45\u80fd\u5bb9\u91cf";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

