/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class PolarizedArmor {
    public static float EFFECTIVE_ARMOR_BONUS = 50.0f;
    public static float EMP_BONUS_PERCENT = 50.0f;
    public static float VENT_RATE_BONUS = 25.0f;
    public static float NON_SHIELD_FLUX_LEVEL = 50.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            return "\n\n* \u6ca1\u6709\u62a4\u76fe\u4e14\u6ca1\u6709\u76f8\u4f4d\u7cfb\u7edf\u7684\u8230\u8239\u88ab\u672c\u6280\u80fd\u89c6\u4f5c\u6c38\u8fdc\u5904\u4e8e " + (int)NON_SHIELD_FLUX_LEVEL + "% \u7684\u786c\u5e45\u80fd\u72b6\u6001\u4e0b\u3002";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        public String[] getHighlights() {
            return new String[]{(int)NON_SHIELD_FLUX_LEVEL + "%"};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxArmorDamageReduction().modifyFlat(id, 0.05f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxArmorDamageReduction().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u88c5\u7532\u7684\u6700\u5927\u4f24\u5bb3\u51cf\u514d\u4ece 85% \u63d0\u9ad8\u81f3 90%";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements AfterShipCreationSkillEffect {
        public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.addListener(new PolarizedArmorEffectMod(ship, id));
        }

        public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
            MutableShipStatsAPI stats = ship.getMutableStats();
            ship.removeListenerOfClass(PolarizedArmorEffectMod.class);
            stats.getEffectiveArmorBonus().unmodify(id);
            stats.getEmpDamageTakenMult().unmodify(id);
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }

        public String getEffectDescription(float level) {
            return "\u6839\u636e\u5f53\u524d\u786c\u5e45\u80fd\u6c34\u5e73\uff0c\u6700\u591a +" + (int)EFFECTIVE_ARMOR_BONUS + "% \u88c5\u7532\u503c (\u4ec5\u7528\u4e8e\u8ba1\u7b97\u4f24\u5bb3\u51cf\u514d*) ";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }

        public String getEffectDescription(float level) {
            return "\u6839\u636e\u5f53\u524d\u786c\u5e45\u80fd\u6c34\u5e73\uff0c\u6700\u591a -" + Math.round(EMP_BONUS_PERCENT) + "% \u6240\u53d7\u5230\u7684 EMP \u6548\u679c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getVentRateMult().modifyPercent(id, VENT_RATE_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getVentRateMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)VENT_RATE_BONUS + "% \u5f3a\u5236\u6392\u5e45\u65f6\uff0c\u5e45\u80fd\u7684\u8017\u6563\u901f\u7387";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class PolarizedArmorEffectMod
    implements DamageTakenModifier,
    AdvanceableListener {
        protected ShipAPI ship;
        protected String id;

        public PolarizedArmorEffectMod(ShipAPI ship, String id) {
            this.ship = ship;
            this.id = id;
        }

        public void advance(float amount) {
            MutableShipStatsAPI stats = this.ship.getMutableStats();
            float fluxLevel = this.ship.getHardFluxLevel();
            if (!(this.ship.getShield() != null || this.ship.getHullSpec().isPhase() || this.ship.getPhaseCloak() != null && this.ship.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.PHASE))) {
                fluxLevel = NON_SHIELD_FLUX_LEVEL * 0.01f;
            }
            float armorBonus = EFFECTIVE_ARMOR_BONUS * fluxLevel;
            float empBonus = EMP_BONUS_PERCENT * fluxLevel;
            stats.getEffectiveArmorBonus().modifyPercent(this.id, armorBonus);
            stats.getEmpDamageTakenMult().modifyMult(this.id, 1.0f - empBonus * 0.01f);
            Color c = this.ship.getSpriteAPI().getAverageColor();
            c = Misc.setAlpha(c, 127);
            float b = 0.0f;
            if (fluxLevel > 0.75f) {
                b = 1.0f * (fluxLevel - 0.75f) / 0.25f;
            }
            if (b > 0.0f) {
                this.ship.setJitter(this, c, 1.0f * fluxLevel * b, 1, 0.0f);
            }
        }

        public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            return null;
        }
    }
}

