/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RangedSpecialization {
    public static boolean CRITS = false;
    public static float PROJ_SPEED_BONUS = 30.0f;
    public static float MIN_RANGE = 800.0f;
    public static float MAX_RANGE = 1600.0f;
    public static float MAX_CHANCE_PERCENT = 30.0f;
    public static float CRIT_DAMAGE_BONUS_PERCENT = 100.0f;

    public static class Level1
    extends BaseSkillEffectDescription
    implements AfterShipCreationSkillEffect {
        public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.addListener(new RangedSpecDamageDealtMod());
        }

        public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.removeListenerOfClass(RangedSpecDamageDealtMod.class);
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            if (CRITS) {
                info.addPara("\u5b9e\u5f39\u4e0e\u80fd\u91cf\u6b66\u5668\u6240\u53d1\u5c04\u7684\u70ae\u5f39\u6709\u4e00\u5b9a\u6982\u7387\u5bf9\u8fdc\u8ddd\u79bb\u7684\u76ee\u6807\u9020\u6210\u989d\u5916 %s \u7684\u4f24\u5bb3", 0.0f, this.hc, this.hc, "+" + (int)CRIT_DAMAGE_BONUS_PERCENT + "%");
                info.addPara(String.valueOf(this.indent) + "%s \u6982\u7387\u4e3a %s \u8ddd\u79bb\u4ee5\u4e0b\uff0c" + "\u800c\u60f3\u8981\u8fbe\u5230\u6700\u9ad8 %s \u7684\u6982\u7387\u9700\u8981\u98de\u884c\u8ddd\u79bb\u81f3\u5c11 %s \u4ee5\u4e0a", 0.0f, this.tc, this.hc, "0%", "" + (int)MIN_RANGE, (int)MAX_CHANCE_PERCENT + "%", "" + (int)MAX_RANGE);
            } else {
                info.addPara("\u5b9e\u5f39\u4e0e\u80fd\u91cf\u6b66\u5668\u6240\u53d1\u5c04\u7684\u70ae\u5f39\u98de\u5f97\u8d8a\u8fdc\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u4e5f\u5c31\u8d8a\u9ad8\uff0c\u6700\u591a\u53ef %s \u7684\u4f24\u5bb3", 0.0f, this.hc, this.hc, "+" + (int)MAX_CHANCE_PERCENT + "%");
                info.addPara(String.valueOf(this.indent) + "%s \u52a0\u6210\u4e3a %s \u8ddd\u79bb\u4ee5\u4e0b\uff0c" + "\u800c\u60f3\u8981\u8fbe\u5230\u6700\u9ad8 %s \u7684\u52a0\u6210\u9700\u8981\u98de\u884c\u8ddd\u79bb\u81f3\u5c11 %s \u4ee5\u4e0a", 0.0f, this.tc, this.hc, "0%", "" + (int)MIN_RANGE, (int)MAX_CHANCE_PERCENT + "%", "" + (int)MAX_RANGE);
            }
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getProjectileSpeedMult().modifyPercent(id, PROJ_SPEED_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getProjectileSpeedMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)PROJ_SPEED_BONUS + "% \u5b9e\u5f39\u4e0e\u80fd\u91cf\u6b66\u5668\u7684\u5f39\u4f53\u98de\u884c\u901f\u7387";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class RangedSpecDamageDealtMod
    implements DamageDealtModifier {
        public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            if (param instanceof MissileAPI) {
                return null;
            }
            Vector2f from = null;
            if (param instanceof DamagingProjectileAPI) {
                from = ((DamagingProjectileAPI)param).getSpawnLocation();
            } else if (param instanceof BeamAPI) {
                from = ((BeamAPI)param).getFrom();
            } else {
                return null;
            }
            float chancePercent = 0.0f;
            float dist = Misc.getDistance(from, point);
            float f = (dist - MIN_RANGE) / (MAX_RANGE - MIN_RANGE);
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            String id = null;
            chancePercent = Math.round(MAX_CHANCE_PERCENT * f);
            if (chancePercent <= 0.0f) {
                return null;
            }
            Vector2f vel = new Vector2f();
            if (target instanceof ShipAPI) {
                vel.set((ReadableVector2f)target.getVelocity());
            }
            if (param instanceof DamagingProjectileAPI) {
                if (CRITS) {
                    if ((float)Math.random() < chancePercent * 0.01f) {
                        id = "ranged_spec_dam_mod";
                        damage.getModifier().modifyPercent(id, CRIT_DAMAGE_BONUS_PERCENT);
                    }
                } else {
                    id = "ranged_spec_dam_mod";
                    damage.getModifier().modifyPercent(id, chancePercent);
                }
            } else if (param instanceof BeamAPI) {
                if (CRITS) {
                    if ((float)Math.random() < chancePercent * 0.01f) {
                        id = "ranged_spec_dam_mod";
                        damage.getModifier().modifyPercent(id, CRIT_DAMAGE_BONUS_PERCENT);
                    }
                } else {
                    id = "ranged_spec_dam_mod";
                    damage.getModifier().modifyPercent(id, chancePercent);
                }
            }
            return id;
        }
    }
}

