/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class RecoveryOperations {
    public static final float OWN_WEAPON_WING_RECOVERY_BONUS = 30.0f;
    public static final float ENEMY_WEAPON_WING_RECOVERY_BONUS = 25.0f;
    public static final float SHIP_RECOVERY_BONUS = 25.0f;
    public static final float DMOD_REDUCTION = 2.0f;
    public static final float CREW_LOSS_REDUCTION = 30.0f;
    public static final float REPAIR_RATE_BONUS = 100.0f;
    public static final float FUEL_SALVAGE_BONUS = 50.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            float baseW = Math.round(Global.getSettings().getFloat("salvageWeaponProb") * 100.0f);
            float baseS = Math.round(Global.getSettings().getFloat("baseShipRecoveryChance") * 100.0f);
            float baseWO = Math.round(Global.getSettings().getFloat("salvageOwnWeaponProb") * 100.0f);
            float baseSO = Math.round(Global.getSettings().getFloat("baseOwnShipRecoveryChance") * 100.0f);
            return String.format("\u57fa\u7840\u6218\u540e\u53ef\u4fee\u590d\u6982\u7387\u4e3a \u654c\u65b9\u8230\u8239 %d%% \uff0c\u53cb\u65b9\u8230\u8239 %d%% \u3002\u56de\u6536\u88ab\u51fb\u6bc1\u7684\u654c\u8230\u7684\u6b66\u5668\u6982\u7387\u4e3a %d%% \uff0c\u53cb\u65b9\u8230\u8239\u7684\u6b66\u5668\u5219\u4e3a %d%% \u3002\u6218\u6597\u4e2d\u5b8c\u5168\u788e\u88c2\u7684\u8230\u8239\u5c06\u964d\u4f4e\u4e00\u534a\u7684\u53ef\u4fee\u590d\u6982\u7387\uff0c\u5e76\u4e14\u4e00\u5b9a\u53d7\u5230\u6c38\u4e45\u7684\u7ed3\u6784\u635f\u5bb3\u3002", (int)baseS, (int)baseSO, (int)baseW, (int)baseWO);
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            return new Color[]{h, h, h, h};
        }

        public String[] getHighlights() {
            String baseW = Math.round(Global.getSettings().getFloat("salvageWeaponProb") * 100.0f) + "%";
            String baseS = Math.round(Global.getSettings().getFloat("baseShipRecoveryChance") * 100.0f) + "%";
            String baseWO = Math.round(Global.getSettings().getFloat("salvageOwnWeaponProb") * 100.0f) + "%";
            String baseSO = Math.round(Global.getSettings().getFloat("baseOwnShipRecoveryChance") * 100.0f) + "%";
            return new String[]{baseS, baseSO, baseW, baseWO};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("own_weapon_recovery_mod").modifyFlat(id, 0.29999998f);
            stats.getDynamic().getMod("own_wing_recovery_mod").modifyFlat(id, 0.29999998f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("own_weapon_recovery_mod").unmodify(id);
            stats.getDynamic().getMod("own_wing_recovery_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+30% \u6982\u7387\u5728\u6218\u540e\u4fee\u590d \u6211\u65b9\u88ab\u51fb\u6c89\u8230\u8239\u4e0a\u7684\u6b66\u5668\u548c\u6218\u673a\u82af\u7247";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level1B
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("enemy_weapon_recovery_mod").modifyFlat(id, 0.25f);
            stats.getDynamic().getMod("enemy_wing_recovery_mod").modifyFlat(id, 0.25f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("enemy_weapon_recovery_mod").unmodify(id);
            stats.getDynamic().getMod("enemy_wing_recovery_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+25% \u5728\u6218\u540e\u4fee\u590d\u654c\u65b9\u88ab\u51fb\u6c89\u8230\u8239\u4e0a\u7684\u6b66\u5668\u548c\u6218\u673a\u82af\u7247\u7684\u6982\u7387";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_recovery_mod").modifyFlat(id, 0.25f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_recovery_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+25% \u5728\u6218\u540e\u4fee\u590d\u505c\u673a\u8230\u8239\u7684\u6982\u7387";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getCrewLossMult().modifyMult(id, 0.7f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCrewLossMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-30% \u7531\u4e8e\u7ed3\u6784\u53d7\u635f\u9020\u6210\u7684\u4eba\u5458\u4f24\u4ea1";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2B
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("overall_crew_loss_mult").modifyMult(id, 0.7f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("overall_crew_loss_mult").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-30% \u5728\u975e\u6218\u6597\u884c\u52a8\u4e2d\u7684\u4eba\u5458\u4f24\u4ea1";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_dmod_reduction_mod").modifyFlat(id, 2.0f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_dmod_reduction_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u964d\u4f4e\u4fee\u590d\u505c\u673a\u8230\u8239\u65f6\u51fa\u73b0  D-\u63d2\u4ef6 \u7684\u6982\u7387";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3B
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").modifyFlat(id, 0.5f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").unmodify(id);
        }

        public String getEffectDescription(float level) {
            float max = 0.0f;
            return "+" + (int)(max += 50.0f) + "% \u71c3\u6599\u6253\u635e";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

