/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class ReliabilityEngineering {
    public static float PEAK_TIME_BONUS = 60.0f;
    public static float DEGRADE_REDUCTION_PERCENT = 25.0f;
    public static float MAX_CR_BONUS = 15.0f;
    public static float OVERLOAD_REDUCTION = 30.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("individual_ship_recovery_mod").modifyFlat(id, 1000.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("individual_ship_recovery_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u5982\u679c\u8be5\u8230\u5728\u6218\u6597\u4e2d\u88ab\u51fb\u6c89\uff0c\u5c06\u51e0\u4e4e\u603b\u662f\u53ef\u5728\u6218\u540e\u88ab\u6253\u635e\u5e76\u4fee\u590d\u3002";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPeakCRDuration().modifyFlat(id, PEAK_TIME_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPeakCRDuration().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)PEAK_TIME_BONUS + " \u79d2\u5cf0\u503c\u65f6\u95f4";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getCRLossPerSecondPercent().modifyMult(id, 1.0f - DEGRADE_REDUCTION_PERCENT / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCRLossPerSecondPercent().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)DEGRADE_REDUCTION_PERCENT + "% \u5cf0\u503c\u65f6\u95f4\u8017\u5c3d\u540e\u6574\u5907\u503c\u8870\u51cf\u7684\u901f\u5ea6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxCombatReadiness().modifyFlat(id, MAX_CR_BONUS * 0.01f, "\u53ef\u9760\u5de5\u7a0b");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)MAX_CR_BONUS + "% \u6218\u5907\u503c (CR) \u4e0a\u9650";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level5
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getOverloadTimeMod().modifyMult(id, 1.0f - OVERLOAD_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getOverloadTimeMod().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)OVERLOAD_REDUCTION + "% \u8fc7\u8f7d\u65f6\u95f4";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

