/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class SpecialModifications {
    public static int VENTS_BONUS = 10;
    public static int CAPACITORS_BONUS = 10;
    public static int EXTRA_MODS = 1;
    public static float BUILD_IN_XP_BONUS = 0.2f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            int max = Misc.MAX_PERMA_MODS;
            return "* \u8230\u8239\u57fa\u7840\u53ef\u5185\u7f6e\u7684\u63d2\u4ef6\u7684\u4e0a\u9650\u4e3a " + max + ".";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h, h, h};
        }

        public String[] getHighlights() {
            int max = Misc.MAX_PERMA_MODS;
            return new String[]{"" + max};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxCapacitorsBonus().modifyFlat(id, CAPACITORS_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxCapacitorsBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + CAPACITORS_BONUS + " \u5e45\u80fd\u5bc4\u5b58\u5668\u4e0a\u9650";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxVentsBonus().modifyFlat(id, VENTS_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxVentsBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + VENTS_BONUS + " \u8017\u6563\u901a\u9053\u4e0a\u9650";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level3
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("build_in_bonus_xp_mod").modifyFlat(id, BUILD_IN_XP_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("build_in_bonus_xp_mod").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round(BUILD_IN_XP_BONUS * 100.0f) + "% \u5185\u7f6e* \u8230\u8239\u63d2\u4ef6\u540e\u6240\u83b7\u5f97\u7684\u989d\u5916\u7ecf\u9a8c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("max_permanent_hullmods_mod").modifyFlat(id, EXTRA_MODS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("max_permanent_hullmods_mod").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "\u63d0\u9ad8 " + EXTRA_MODS + " \u4e2a\u6700\u5927\u53ef \u5185\u7f6e* \u8230\u8239\u63d2\u4ef6\u6570";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

