/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class StrikeCommander {
    public static final float TARGET_LEADING_BONUS = 100.0f;
    public static final float MISSILE_HITPOINTS_BONUS = 50.0f;
    public static final float STRIKE_DAMAGE_BONUS = 20.0f;

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMissileHealthBonus().modifyPercent(id, 50.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMissileHealthBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+50% \u5bfc\u5f39\u3001\u706b\u7bad\u3001\u70b8\u5f39\u548c\u9c7c\u96f7\u7684\u751f\u547d\u503c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToDestroyers().modifyPercent(id, 20.0f);
            stats.getDamageToCruisers().modifyPercent(id, 20.0f);
            stats.getDamageToCapital().modifyPercent(id, 20.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToDestroyers().unmodify(id);
            stats.getDamageToCruisers().unmodify(id);
            stats.getDamageToCapital().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+20% \u5bf9\u9a71\u9010\u8230\u4ee5\u53ca\u66f4\u5927\u578b\u8230\u8239\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getAutofireAimAccuracy().modifyFlat(id, 1.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getAutofireAimAccuracy().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+100% \u6295\u5f39\u7cbe\u5ea6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }
}

