/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.campaign.skills.CombatEndurance;
import com.fs.starfarer.api.impl.campaign.skills.DamageControl;
import com.fs.starfarer.api.impl.campaign.skills.Helmsmanship;
import com.fs.starfarer.api.impl.campaign.skills.OrdnanceExpertise;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class SupportDoctrine {
    public static float COMMAND_POINT_REGEN_PERCENT = 100.0f;
    public static String SUPPORT_DOCTRINE_DP_REDUCTION_ID = "support_doctrine_dp_reduction";
    public static float DP_REDUCTION = 0.2f;
    public static float DP_REDUCTION_MAX = 10.0f;

    public static boolean isNoOfficer(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            return ship.getCaptain().isDefault();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return true;
        }
        return member.getCaptain().isDefault();
    }

    public static boolean isOriginalNoOfficer(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            return ship.getOriginalCaptain() != null && ship.getOriginalCaptain().isDefault();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return true;
        }
        return member.getCaptain().isDefault();
    }

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (SupportDoctrine.isNoOfficer(stats)) {
                new Helmsmanship.Level1().apply(stats, hullSize, id, level);
                new Helmsmanship.Level2().apply(stats, hullSize, id, level);
                new DamageControl.Level2().apply(stats, hullSize, id, level);
                new DamageControl.Level3().apply(stats, hullSize, id, level);
                new DamageControl.Level4().apply(stats, hullSize, id, level);
                new CombatEndurance.Level1().apply(stats, hullSize, id, level);
                new CombatEndurance.Level2().apply(stats, hullSize, id, level);
                new CombatEndurance.Level3().apply(stats, hullSize, id, level);
                new OrdnanceExpertise.Level1().apply(stats, hullSize, id, level);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            new Helmsmanship.Level1().unapply(stats, hullSize, id);
            new Helmsmanship.Level2().unapply(stats, hullSize, id);
            new DamageControl.Level2().unapply(stats, hullSize, id);
            new DamageControl.Level3().unapply(stats, hullSize, id);
            new DamageControl.Level4().unapply(stats, hullSize, id);
            new CombatEndurance.Level1().unapply(stats, hullSize, id);
            new CombatEndurance.Level2().unapply(stats, hullSize, id);
            new CombatEndurance.Level3().unapply(stats, hullSize, id);
            new OrdnanceExpertise.Level1().unapply(stats, hullSize, id);
        }

        public String getEffectDescription(float level) {
            return "\u83b7\u5f97\u975e\u7cbe\u82f1\u7ea7\u7684 \u64cd\u8235\u6280\u672f\u3001\u635f\u4f24\u7ba1\u5236\u3001\u6218\u6597\u8010\u529b \u4ee5\u53ca \u519b\u68b0\u4e13\u957f";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (SupportDoctrine.isNoOfficer(stats)) {
                float baseCost = stats.getSuppliesToRecover().getBaseValue();
                float reduction = Math.min(DP_REDUCTION_MAX, baseCost * DP_REDUCTION);
                if (stats.getFleetMember() == null || stats.getFleetMember().getVariant() == null || !stats.getFleetMember().getVariant().hasHullMod("neural_interface") && !stats.getFleetMember().getVariant().hasHullMod("neural_integrator")) {
                    stats.getDynamic().getMod("deployment_points_mod").modifyFlat(SUPPORT_DOCTRINE_DP_REDUCTION_ID, -reduction);
                }
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("deployment_points_mod").unmodifyFlat(SUPPORT_DOCTRINE_DP_REDUCTION_ID);
        }

        public String getEffectDescription(float level) {
            String max = "" + (int)DP_REDUCTION_MAX;
            String percent = Math.round(DP_REDUCTION * 100.0f) + "%";
            return "\u90e8\u7f72\u70b9 -" + percent + " \u6216 " + max + " \u70b9\uff0c\u6309\u4e24\u8005\u4e2d\u8f83\u4f4e\u8005\u8ba1\u7b97";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("\u5f71\u54cd\uff1a %s", opad + 5.0f, Misc.getGrayColor(), c, "\u8230\u961f");
            info.addSpacer(opad);
            info.addPara("+%s \u6307\u6325\u70b9\u6062\u590d\u901f\u5ea6 (\u5f53\u6307\u6325\u6743\u88ab\u8f6c\u79fb\u5230\u4e00\u8258\u6ca1\u6709\u519b\u5b98\u7684\u8230\u8239\u65f6\u5c06\u5931\u53bb\u589e\u76ca) ", 0.0f, this.hc, this.hc, (int)COMMAND_POINT_REGEN_PERCENT + "%");
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!SupportDoctrine.isOriginalNoOfficer(stats)) {
                stats.getDynamic().getMod("command_point_rate_flat").modifyFlat(id, COMMAND_POINT_REGEN_PERCENT * 0.01f);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("command_point_rate_flat").unmodify(id);
        }
    }
}

