/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class SystemsExpertise {
    public static float BONUS_CHARGES = 1.0f;
    public static float REGEN_PERCENT = 50.0f;
    public static float SYSTEM_COOLDOWN_REDUCTION_PERCENT = 33.0f;
    public static float RANGE_PERCENT = 50.0f;
    public static float PEAK_TIME_BONUS = 30.0f;
    public static float OVERLOAD_REDUCTION = 25.0f;
    public static float MALFUNCTION_CHANCE_MULT = 0.5f;
    public static float ELITE_DAMAGE_REDUCTION = 10.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getSystemUsesBonus().modifyFlat(id, BONUS_CHARGES);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getSystemUsesBonus().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "\u82e5\u8230\u8239\u7cfb\u7edf\u6709\u5145\u80fd\uff1a\u5219 +1 \u5145\u80fd\u6570\u91cf";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getSystemRegenBonus().modifyPercent(id, REGEN_PERCENT);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getSystemRegenBonus().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "\u82e5\u8230\u8239\u7cfb\u7edf\u80fd\u56de\u590d\u5145\u80fd\uff1a\u5219 +" + (int)REGEN_PERCENT + "% \u56de\u5145\u901f\u7387";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getSystemRangeBonus().modifyPercent(id, RANGE_PERCENT);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getSystemRangeBonus().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "\u82e5\u8230\u8239\u7cfb\u7edf\u6709\u91ca\u653e\u8ddd\u79bb\uff1a\u5219 +" + (int)RANGE_PERCENT + "% \u91ca\u653e\u8ddd\u79bb";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getSystemCooldownBonus().modifyMult(id, 1.0f - SYSTEM_COOLDOWN_REDUCTION_PERCENT / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getSystemCooldownBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u82e5\u8230\u8239\u7cfb\u7edf\u6709\u51b7\u5374\u65f6\u95f4\uff1a\u5219 -" + (int)SYSTEM_COOLDOWN_REDUCTION_PERCENT + "% \u51b7\u5374\u65f6\u95f4";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level5
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPeakCRDuration().modifyFlat(id, PEAK_TIME_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPeakCRDuration().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)PEAK_TIME_BONUS + " \u79d2\u5cf0\u503c\u65f6\u95f4";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level6
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getOverloadTimeMod().modifyMult(id, 1.0f - OVERLOAD_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getOverloadTimeMod().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)OVERLOAD_REDUCTION + "% \u8fc7\u8f7d\u65f6\u95f4";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level7
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getWeaponMalfunctionChance().modifyMult(id, MALFUNCTION_CHANCE_MULT);
            stats.getEngineMalfunctionChance().modifyMult(id, MALFUNCTION_CHANCE_MULT);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getWeaponMalfunctionChance().unmodifyMult(id);
            stats.getEngineMalfunctionChance().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            String percent = Math.round((1.0f - MALFUNCTION_CHANCE_MULT) * 100.0f) + "% \u5728\u4f4e\u6218\u5907\u72b6\u6001\u4e0b\u53d1\u751f\u6545\u969c\u7684\u51e0\u7387";
            return "-" + percent;
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level8
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getArmorDamageTakenMult().modifyMult(id, 1.0f - ELITE_DAMAGE_REDUCTION / 100.0f);
            stats.getHullDamageTakenMult().modifyMult(id, 1.0f - ELITE_DAMAGE_REDUCTION / 100.0f);
            stats.getShieldDamageTakenMult().modifyMult(id, 1.0f - ELITE_DAMAGE_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getArmorDamageTakenMult().unmodifyMult(id);
            stats.getHullDamageTakenMult().unmodifyMult(id);
            stats.getShieldDamageTakenMult().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            String percent = "-" + (int)ELITE_DAMAGE_REDUCTION + "%";
            return String.valueOf(percent) + " \u6240\u53d7\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

