/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class TacticalDrills {
    public static float DAMAGE_PERCENT = 5.0f;
    public static int ATTACK_BONUS = 50;
    public static float CASUALTIES_MULT = 0.75f;

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getCombatOPTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!Level1.isCivilian(stats)) {
                float damBonus = this.computeAndCacheThresholdBonus(stats, "td_dam", DAMAGE_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
                stats.getBallisticWeaponDamageMult().modifyPercent(id, damBonus);
                stats.getEnergyWeaponDamageMult().modifyPercent(id, damBonus);
                stats.getMissileWeaponDamageMult().modifyPercent(id, damBonus);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getBallisticWeaponDamageMult().unmodifyPercent(id);
            stats.getEnergyWeaponDamageMult().unmodifyPercent(id);
            stats.getMissileWeaponDamageMult().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float damBonus = this.computeAndCacheThresholdBonus(data, stats, "td_dam", DAMAGE_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
            info.addPara("+%s \u6218\u6597\u8230\u8239\u7684\u6b66\u5668\u4f24\u5bb3 (\u6700\u9ad8\uff1a%s) ", 0.0f, this.hc, this.hc, (int)damBonus + "%", (int)DAMAGE_PERCENT + "%");
            this.addOPThresholdInfo(info, data, stats, OP_THRESHOLD);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ground_attack_mod").modifyPercent(id, ATTACK_BONUS, "\u6218\u672f\u6f14\u7ec3");
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ground_attack_mod").unmodifyPercent(id);
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("\u5f71\u54cd\uff1a %s", opad + 5.0f, Misc.getGrayColor(), c, "\u5730\u9762\u884c\u52a8");
            info.addSpacer(opad);
            info.addPara("+%s \u7a81\u88ad\u7b49\u5730\u9762\u884c\u52a8\u7684\u6548\u679c", 0.0f, this.hc, this.hc, ATTACK_BONUS + "%");
        }

        public String getEffectDescription(float level) {
            return "+" + ATTACK_BONUS + "% \u7a81\u88ad\u7b49\u5730\u9762\u884c\u52a8\u7684\u6548\u679c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("ground_attack_casualties_mult").modifyMult(id, CASUALTIES_MULT, "\u6218\u672f\u6f14\u7ec3");
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("ground_attack_casualties_mult").unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return "-" + Math.round((1.0f - CASUALTIES_MULT) * 100.0f) + "% \u7a81\u88ad\u7b49\u5730\u9762\u4f5c\u6218\u884c\u52a8\u4e2d\u9646\u6218\u961f\u7684\u4f24\u4ea1";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

