/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class TargetAnalysis {
    public static float DAMAGE_TO_MODULES_BONUS = 100.0f;
    public static float DAMAGE_TO_FRIGATES = 5.0f;
    public static float DAMAGE_TO_DESTROYERS = 10.0f;
    public static float DAMAGE_TO_CRUISERS = 15.0f;
    public static float DAMAGE_TO_CAPITALS = 20.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToDestroyers().modifyPercent(id, DAMAGE_TO_DESTROYERS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToDestroyers().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)DAMAGE_TO_DESTROYERS + "% \u5bf9\u9a71\u9010\u8230\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level1A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToFrigates().modifyPercent(id, DAMAGE_TO_FRIGATES);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToFrigates().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)DAMAGE_TO_FRIGATES + "% \u5bf9\u62a4\u536b\u8230\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToCruisers().modifyPercent(id, DAMAGE_TO_CRUISERS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToCruisers().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)DAMAGE_TO_CRUISERS + "% \u5bf9\u5de1\u6d0b\u8230\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToCapital().modifyPercent(id, DAMAGE_TO_CAPITALS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToCapital().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)DAMAGE_TO_CAPITALS + "% \u5bf9\u4e3b\u529b\u8230\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToTargetEnginesMult().modifyPercent(id, DAMAGE_TO_MODULES_BONUS);
            stats.getDamageToTargetWeaponsMult().modifyPercent(id, DAMAGE_TO_MODULES_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToTargetEnginesMult().unmodify(id);
            stats.getDamageToTargetWeaponsMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)DAMAGE_TO_MODULES_BONUS + "% \u5bf9\u6b66\u5668\u548c\u5f15\u64ce\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

