/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;

public class WeaponDrills {
    public static float DAMAGE_PERCENT = 10.0f;

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getCombatOPTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!Level1.isCivilian(stats)) {
                float damBonus = this.computeAndCacheThresholdBonus(stats, "wd_dam", DAMAGE_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP_LOW);
                stats.getBallisticWeaponDamageMult().modifyPercent(id, damBonus);
                stats.getEnergyWeaponDamageMult().modifyPercent(id, damBonus);
                stats.getMissileWeaponDamageMult().modifyPercent(id, damBonus);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getBallisticWeaponDamageMult().unmodifyPercent(id);
            stats.getEnergyWeaponDamageMult().unmodifyPercent(id);
            stats.getMissileWeaponDamageMult().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float damBonus = this.computeAndCacheThresholdBonus(data, stats, "wd_dam", DAMAGE_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP_LOW);
            info.addPara("+%s \u6218\u6597\u8230\u8239\u7684\u6b66\u5668\u4f24\u5bb3 (\u6700\u9ad8\uff1a%s) ", 0.0f, this.hc, this.hc, (int)damBonus + "%", (int)DAMAGE_PERCENT + "%");
            this.addOPThresholdInfo(info, data, stats, OP_LOW_THRESHOLD);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

