/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class WingCommander {
    public static final float SPEED_BONUS = 25.0f;
    public static final float DAMAGE_TO_FIGHTERS_BONUS = 30.0f;
    public static final float DAMAGE_TO_MISSILES_BONUS = 30.0f;
    public static final float TARGET_LEADING_BONUS = 50.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxSpeed().modifyPercent(id, 25.0f);
            stats.getAcceleration().modifyPercent(id, 25.0f);
            stats.getDeceleration().modifyPercent(id, 25.0f);
            stats.getTurnAcceleration().modifyPercent(id, 50.0f);
            stats.getMaxTurnRate().modifyPercent(id, 25.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxSpeed().unmodify(id);
            stats.getAcceleration().unmodify(id);
            stats.getDeceleration().unmodify(id);
            stats.getTurnAcceleration().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+25% \u6700\u9ad8\u822a\u901f\u548c\u673a\u52a8\u6027";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }

    public static class Level2A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToFighters().modifyFlat(id, 0.3f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToFighters().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+30% \u5bf9\u6218\u673a\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }

    public static class Level2B
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToMissiles().modifyFlat(id, 0.3f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToMissiles().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+30% \u5bf9\u5bfc\u5f39\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getAutofireAimAccuracy().modifyFlat(id, 0.5f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getAutofireAimAccuracy().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+50% \u6295\u5f39\u7cbe\u5ea6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.SHIP_FIGHTERS;
        }
    }
}

