/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;

public class WolfpackTactics {
    public static float DAMAGE_TO_LARGER_BONUS = 20.0f;
    public static float DAMAGE_TO_LARGER_BONUS_DEST = 10.0f;
    public static float PEAK_TIME_BONUS = 50.0f;
    public static float PEAK_TIME_BONUS_DEST = 25.0f;

    public static boolean isFrigateAndOfficer(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (!ship.isFrigate()) {
                return false;
            }
            return !ship.getCaptain().isDefault();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        if (!member.isFrigate()) {
            return false;
        }
        return !member.getCaptain().isDefault();
    }

    public static boolean isDestroyerAndOfficer(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (!ship.isDestroyer()) {
                return false;
            }
            return !ship.getCaptain().isDefault();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        if (!member.isDestroyer()) {
            return false;
        }
        return !member.getCaptain().isDefault();
    }

    public static class Level1A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (WolfpackTactics.isFrigateAndOfficer(stats)) {
                stats.getDamageToDestroyers().modifyPercent(id, DAMAGE_TO_LARGER_BONUS);
                stats.getDamageToCruisers().modifyPercent(id, DAMAGE_TO_LARGER_BONUS);
                stats.getDamageToCapital().modifyPercent(id, DAMAGE_TO_LARGER_BONUS);
                stats.getPeakCRDuration().modifyPercent(id, PEAK_TIME_BONUS);
            } else if (WolfpackTactics.isDestroyerAndOfficer(stats)) {
                stats.getDamageToCruisers().modifyPercent(id, DAMAGE_TO_LARGER_BONUS_DEST);
                stats.getDamageToCapital().modifyPercent(id, DAMAGE_TO_LARGER_BONUS_DEST);
                stats.getPeakCRDuration().modifyPercent(id, PEAK_TIME_BONUS_DEST);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToDestroyers().unmodifyPercent(id);
            stats.getDamageToCruisers().unmodifyPercent(id);
            stats.getDamageToCapital().unmodifyPercent(id);
            stats.getPeakCRDuration().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "+" + Math.round(DAMAGE_TO_LARGER_BONUS) + "% \u5bf9\u8239\u4f53\u7ea7\u522b\u5927\u4e8e\u81ea\u8eab\u7684\u8230\u8239\u9020\u6210\u7684\u4f24\u5bb3 (\u81ea\u8eab\u4e3a\u62a4\u536b\u8230\u65f6)\uff0c" + "+" + Math.round(DAMAGE_TO_LARGER_BONUS_DEST) + "% \u5bf9\u8239\u4f53\u7ea7\u522b\u5927\u4e8e\u81ea\u8eab\u7684\u8230\u8239\u9020\u6210\u7684\u4f24\u5bb3 (\u81ea\u8eab\u4e3a\u9a71\u9010\u8230\u65f6)\uff0c\n" + "+" + (int)PEAK_TIME_BONUS + "% \u5cf0\u503c\u65f6\u95f4 (\u81ea\u8eab\u4e3a\u62a4\u536b\u8230\u65f6)\uff0c" + "+" + (int)PEAK_TIME_BONUS_DEST + "% \u5cf0\u503c\u65f6\u95f4 (\u81ea\u8eab\u4e3a\u9a71\u9010\u8230\u65f6) ";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level1C
    extends BaseSkillEffectDescription
    implements AfterShipCreationSkillEffect {
        public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        }

        public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }
    }
}

