/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.plugins.impl.CoreAutofitPlugin;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSubmarketPlugin
implements SubmarketPlugin {
    public static float TRADE_IMPACT_DAYS = 120.0f;
    protected MarketAPI market;
    protected SubmarketAPI submarket;
    protected CargoAPI cargo;
    protected float minSWUpdateInterval = 30.0f;
    protected float sinceSWUpdate = 31.0f;
    protected float sinceLastCargoUpdate = 31.0f;
    protected Random itemGenRandom = new Random();

    @Override
    public void init(SubmarketAPI submarket) {
        this.submarket = submarket;
        this.market = submarket.getMarket();
    }

    protected Object readResolve() {
        return this;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public CargoAPI getCargo() {
        if (this.cargo == null) {
            this.cargo = Global.getFactory().createCargo(true);
            this.cargo.initMothballedShips(this.submarket.getFaction().getId());
        }
        return this.cargo;
    }

    @Override
    public CargoAPI getCargoNullOk() {
        return this.cargo;
    }

    public void setCargo(CargoAPI cargo) {
        this.cargo = cargo;
    }

    @Override
    public void updateCargoPrePlayerInteraction() {
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.sinceLastCargoUpdate += days;
        this.sinceSWUpdate += days;
    }

    @Override
    public boolean okToUpdateShipsAndWeapons() {
        return this.sinceSWUpdate >= this.minSWUpdateInterval;
    }

    @Override
    public void addAllCargo(CargoAPI otherCargo) {
        for (CargoStackAPI stack : otherCargo.getStacksCopy()) {
            if (stack.isNull()) continue;
            this.getCargo().addItems(stack.getType(), stack.getData(), stack.getSize());
        }
    }

    @Override
    public float getTariff() {
        return this.market.getTariff().getModifiedValue();
    }

    @Override
    public String getBuyVerb() {
        return "\u8d2d\u4e70";
    }

    @Override
    public String getSellVerb() {
        return "\u51fa\u552e";
    }

    @Override
    public boolean isFreeTransfer() {
        return false;
    }

    @Override
    public boolean isEnabled(CoreUIAPI ui) {
        return ui.getTradeMode() == CampaignUIAPI.CoreUITradeMode.OPEN || this.isBlackMarket();
    }

    @Override
    public SubmarketPlugin.OnClickAction getOnClickAction(CoreUIAPI ui) {
        return SubmarketPlugin.OnClickAction.OPEN_SUBMARKET;
    }

    @Override
    public String getDialogText(CoreUIAPI ui) {
        return null;
    }

    @Override
    public Highlights getDialogTextHighlights(CoreUIAPI ui) {
        return null;
    }

    @Override
    public SubmarketPlugin.DialogOption[] getDialogOptions(CoreUIAPI ui) {
        return null;
    }

    @Override
    public String getTooltipAppendix(CoreUIAPI ui) {
        return null;
    }

    @Override
    public Highlights getTooltipAppendixHighlights(CoreUIAPI ui) {
        return null;
    }

    @Override
    public SubmarketPlugin.PlayerEconomyImpactMode getPlayerEconomyImpactMode() {
        return SubmarketPlugin.PlayerEconomyImpactMode.NONE;
    }

    @Override
    public float getPlayerTradeImpactMult() {
        return 1.0f;
    }

    @Override
    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
        CommodityOnMarketAPI com;
        float qty;
        if (!this.isParticipatesInEconomy()) {
            return;
        }
        SubmarketPlugin.PlayerEconomyImpactMode mode = this.getPlayerEconomyImpactMode();
        SharedData.getData().getPlayerActivityTracker().getPlayerTradeData(this.submarket).addTransaction(transaction);
        for (CargoStackAPI stack : transaction.getSold().getStacksCopy()) {
            if (!stack.isCommodityStack() || (qty = stack.getSize() * this.getPlayerTradeImpactMult()) <= 0.0f) continue;
            com = this.market.getCommodityData(stack.getCommodityId());
            if (mode == SubmarketPlugin.PlayerEconomyImpactMode.BOTH) {
                com.addTradeMod("sell_" + Misc.genUID(), qty, TRADE_IMPACT_DAYS);
                continue;
            }
            if (mode == SubmarketPlugin.PlayerEconomyImpactMode.PLAYER_SELL_ONLY) {
                com.addTradeModPlus("sell_" + Misc.genUID(), qty, TRADE_IMPACT_DAYS);
                continue;
            }
            if (mode != SubmarketPlugin.PlayerEconomyImpactMode.PLAYER_BUY_ONLY && mode != SubmarketPlugin.PlayerEconomyImpactMode.NONE) continue;
            com.addTradeModMinus("sell_" + Misc.genUID(), qty, TRADE_IMPACT_DAYS);
        }
        for (CargoStackAPI stack : transaction.getBought().getStacksCopy()) {
            if (!stack.isCommodityStack() || (qty = stack.getSize() * this.getPlayerTradeImpactMult()) <= 0.0f) continue;
            com = this.market.getCommodityData(stack.getCommodityId());
            if (mode == SubmarketPlugin.PlayerEconomyImpactMode.BOTH) {
                com.addTradeMod("buy_" + Misc.genUID(), -qty, TRADE_IMPACT_DAYS);
                continue;
            }
            if (mode == SubmarketPlugin.PlayerEconomyImpactMode.PLAYER_SELL_ONLY || mode == SubmarketPlugin.PlayerEconomyImpactMode.NONE) {
                com.addTradeModPlus("buy_" + Misc.genUID(), -qty, TRADE_IMPACT_DAYS);
                continue;
            }
            if (mode != SubmarketPlugin.PlayerEconomyImpactMode.PLAYER_BUY_ONLY) continue;
            com.addTradeModMinus("buy_" + Misc.genUID(), -qty, TRADE_IMPACT_DAYS);
        }
    }

    @Override
    public boolean isMilitaryMarket() {
        return false;
    }

    @Override
    public boolean isBlackMarket() {
        return this.market.getFaction().isHostileTo(this.submarket.getFaction());
    }

    @Override
    public boolean isOpenMarket() {
        return false;
    }

    @Override
    public boolean isParticipatesInEconomy() {
        return true;
    }

    @Override
    public boolean isIllegalOnSubmarket(String commodityId, SubmarketPlugin.TransferAction action) {
        return this.market.isIllegal(commodityId);
    }

    @Override
    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        if (!stack.isCommodityStack()) {
            return false;
        }
        return this.isIllegalOnSubmarket((String)stack.getData(), action);
    }

    @Override
    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return "\u7981\u6b62\u5728 " + this.submarket.getNameOneLine().toLowerCase() + " \u4e2d\u4ea4\u6613";
    }

    @Override
    public boolean isIllegalOnSubmarket(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL && !this.isBlackMarket() && Misc.isAutomated(member);
    }

    @Override
    public String getIllegalTransferText(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        if (action == SubmarketPlugin.TransferAction.PLAYER_BUY) {
            return "\u975e\u6cd5\u8d2d\u4e70";
        }
        if (this.isFreeTransfer()) {
            return "\u7981\u6b62\u5728\u6b64\u5b58\u50a8";
        }
        return "\u975e\u6cd5\u51fa\u552e";
    }

    protected void addFighters(int min, int max, int maxTier, WeightedRandomPicker<String> factionPicker) {
        int num = min + this.itemGenRandom.nextInt(max - min + 1);
        int i = 0;
        while (i < num) {
            String factionId = factionPicker.pick();
            this.addFighters(1, 1, maxTier, factionId);
            ++i;
        }
    }

    protected void addWeapons(int min, int max, int maxTier, String factionId) {
        this.addWeapons(min, max, maxTier, factionId, true);
    }

    protected void addWeapons(int min, int max, int maxTier, String factionId, boolean withCategories) {
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.itemGenRandom);
        picker.add(factionId);
        this.addWeapons(min, max, maxTier, picker, withCategories);
    }

    protected void addWeapons(int min, int max, int maxTier, WeightedRandomPicker<String> factionPicker) {
        this.addWeapons(min, max, maxTier, factionPicker, true);
    }

    protected void addWeapons(int min, int max, int maxTier, WeightedRandomPicker<String> factionPicker, boolean withCategories) {
        WeightedRandomPicker<WeaponSpecAPI> picker = new WeightedRandomPicker<WeaponSpecAPI>(this.itemGenRandom);
        WeightedRandomPicker<WeaponSpecAPI> pd = new WeightedRandomPicker<WeaponSpecAPI>(this.itemGenRandom);
        WeightedRandomPicker<WeaponSpecAPI> kinetic = new WeightedRandomPicker<WeaponSpecAPI>(this.itemGenRandom);
        WeightedRandomPicker<WeaponSpecAPI> nonKinetic = new WeightedRandomPicker<WeaponSpecAPI>(this.itemGenRandom);
        WeightedRandomPicker<WeaponSpecAPI> missile = new WeightedRandomPicker<WeaponSpecAPI>(this.itemGenRandom);
        WeightedRandomPicker<WeaponSpecAPI> strike = new WeightedRandomPicker<WeaponSpecAPI>(this.itemGenRandom);
        int i = 0;
        while (i < factionPicker.getItems().size()) {
            String factionId = factionPicker.getItems().get(i);
            float w = factionPicker.getWeight(i);
            if (factionId == null) {
                factionId = this.market.getFactionId();
            }
            float quality = Misc.getShipQuality(this.market, factionId);
            FactionAPI faction = Global.getSector().getFaction(factionId);
            for (String id : faction.getKnownWeapons()) {
                WeaponSpecAPI spec = Global.getSettings().getWeaponSpec(id);
                if (spec.getTier() > maxTier || spec.getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM) || spec.hasTag("no_sell")) continue;
                float p = DefaultFleetInflater.getTierProbability(spec.getTier(), quality);
                p = 1.0f;
                p *= w;
                if (faction.getWeaponSellFrequency().containsKey(id)) {
                    p *= faction.getWeaponSellFrequency().get(id).floatValue();
                }
                picker.add(spec, p);
                String cat = spec.getAutofitCategory();
                if (cat == null || spec.getSize() == WeaponAPI.WeaponSize.LARGE) continue;
                if (CoreAutofitPlugin.PD.equals(cat)) {
                    pd.add(spec, p);
                    continue;
                }
                if (CoreAutofitPlugin.STRIKE.equals(cat)) {
                    strike.add(spec, p);
                    continue;
                }
                if (CoreAutofitPlugin.KINETIC.equals(cat)) {
                    kinetic.add(spec, p);
                    continue;
                }
                if (CoreAutofitPlugin.MISSILE.equals(cat) || CoreAutofitPlugin.ROCKET.equals(cat)) {
                    missile.add(spec, p);
                    continue;
                }
                if (!CoreAutofitPlugin.HE.equals(cat) && !CoreAutofitPlugin.ENERGY.equals(cat)) continue;
                nonKinetic.add(spec, p);
            }
            ++i;
        }
        int num = min + this.itemGenRandom.nextInt(max - min + 1);
        if (withCategories) {
            if (num > 0 && !pd.isEmpty()) {
                this.pickAndAddWeapons(pd);
                --num;
            }
            if (num > 0 && !kinetic.isEmpty()) {
                this.pickAndAddWeapons(kinetic);
                --num;
            }
            if (num > 0 && !missile.isEmpty()) {
                this.pickAndAddWeapons(missile);
                --num;
            }
            if (num > 0 && !nonKinetic.isEmpty()) {
                this.pickAndAddWeapons(nonKinetic);
                --num;
            }
            if (num > 0 && !strike.isEmpty()) {
                this.pickAndAddWeapons(strike);
                --num;
            }
        }
        int i2 = 0;
        while (i2 < num && !picker.isEmpty()) {
            this.pickAndAddWeapons(picker);
            ++i2;
        }
    }

    protected void pickAndAddWeapons(WeightedRandomPicker<WeaponSpecAPI> picker) {
        WeaponSpecAPI spec = picker.pick();
        if (spec == null) {
            return;
        }
        int count = 1;
        switch (spec.getSize()) {
            case LARGE: {
                count = 1;
                break;
            }
            case MEDIUM: {
                count = 2;
                break;
            }
            case SMALL: {
                count = 3;
            }
        }
        count = count + this.itemGenRandom.nextInt(count + 2) - this.itemGenRandom.nextInt(count + 1);
        if (count < 1) {
            count = 1;
        }
        this.cargo.addWeapons(spec.getWeaponId(), count);
    }

    protected void addFighters(int min, int max, int maxTier, String factionId) {
        if (factionId == null) {
            factionId = this.market.getFactionId();
        }
        int num = min + this.itemGenRandom.nextInt(max - min + 1);
        float quality = Misc.getShipQuality(this.market, factionId);
        FactionAPI faction = Global.getSector().getFaction(factionId);
        WeightedRandomPicker<FighterWingSpecAPI> picker = new WeightedRandomPicker<FighterWingSpecAPI>(this.itemGenRandom);
        for (String id : faction.getKnownFighters()) {
            FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(id);
            if (spec == null) {
                throw new RuntimeException("Fighter wing spec with id [" + id + "] not found");
            }
            if (spec.getTier() > maxTier || spec.hasTag("no_sell")) continue;
            float p = DefaultFleetInflater.getTierProbability(spec.getTier(), quality);
            p = 1.0f;
            if (faction.getFighterSellFrequency().containsKey(id)) {
                p *= faction.getFighterSellFrequency().get(id).floatValue();
            }
            picker.add(spec, p);
        }
        int i = 0;
        while (i < num && !picker.isEmpty()) {
            FighterWingSpecAPI spec = (FighterWingSpecAPI)picker.pick();
            int count = 2;
            switch (spec.getRole()) {
                case ASSAULT: {
                    count = 2;
                    break;
                }
                case BOMBER: {
                    count = 2;
                    break;
                }
                case INTERCEPTOR: {
                    count = 4;
                    break;
                }
                case FIGHTER: {
                    count = 3;
                    break;
                }
                case SUPPORT: {
                    count = 2;
                }
            }
            count = count + this.itemGenRandom.nextInt(count + 1) - count / 2;
            this.cargo.addItems(CargoAPI.CargoItemType.FIGHTER_CHIP, spec.getId(), count);
            ++i;
        }
    }

    protected void pruneWeapons(float keepFraction) {
        CargoAPI cargo = this.getCargo();
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            if (!stack.isWeaponStack() && !stack.isFighterWingStack()) continue;
            float qty = stack.getSize();
            if (qty <= 1.0f) {
                if (!(this.itemGenRandom.nextFloat() > keepFraction)) continue;
                cargo.removeItems(stack.getType(), stack.getData(), 1.0f);
                continue;
            }
            cargo.removeItems(stack.getType(), stack.getData(), Math.round(qty * (1.0f - keepFraction)));
        }
    }

    public void addShips(String factionId, float combat, float freighter, float tanker, float transport, float liner, float utility, Float qualityOverride, float qualityMod, FactionAPI.ShipPickMode modeOverride, FactionDoctrineAPI doctrineOverride) {
        this.addShips(factionId, combat, freighter, tanker, transport, liner, utility, qualityOverride, qualityMod, modeOverride, doctrineOverride, 1000);
    }

    public void addShips(String factionId, float combat, float freighter, float tanker, float transport, float liner, float utility, Float qualityOverride, float qualityMod, FactionAPI.ShipPickMode modeOverride, FactionDoctrineAPI doctrineOverride, int maxShipSize) {
        FleetParamsV3 params = new FleetParamsV3(this.market, Global.getSector().getPlayerFleet().getLocationInHyperspace(), factionId, null, "patrolLarge", combat, freighter, tanker, transport, liner, utility, 0.0f);
        params.maxShipSize = maxShipSize;
        params.random = new Random(this.itemGenRandom.nextLong());
        params.qualityOverride = Float.valueOf(Misc.getShipQuality(this.market, factionId) + qualityMod);
        if (qualityOverride != null) {
            params.qualityOverride = Float.valueOf(qualityOverride.floatValue() + qualityMod);
        }
        params.withOfficers = false;
        params.forceAllowPhaseShipsEtc = true;
        params.treatCombatFreighterSettingAsFraction = true;
        params.modeOverride = Misc.getShipPickMode(this.market, factionId);
        if (modeOverride != null) {
            params.modeOverride = modeOverride;
        }
        params.doctrineOverride = doctrineOverride;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet != null) {
            float p = 0.5f;
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                if (this.itemGenRandom.nextFloat() > p || member.getHullSpec().hasTag("no_sell") || !this.isMilitaryMarket() && member.getHullSpec().hasTag("req_military")) continue;
                String emptyVariantId = String.valueOf(member.getHullId()) + "_Hull";
                this.addShip(emptyVariantId, true, params.qualityOverride.floatValue());
            }
        }
    }

    protected FleetMemberAPI addShip(String variantOrWingId, boolean withDmods, float quality) {
        FleetMemberAPI member = null;
        member = variantOrWingId.endsWith("_wing") ? Global.getFactory().createFleetMember(FleetMemberType.FIGHTER_WING, variantOrWingId) : Global.getFactory().createFleetMember(FleetMemberType.SHIP, variantOrWingId);
        if (withDmods) {
            float averageDmods = DefaultFleetInflater.getAverageDmodsForQuality(quality);
            int addDmods = DefaultFleetInflater.getNumDModsToAdd(member.getVariant(), averageDmods, this.itemGenRandom);
            if (addDmods > 0) {
                DModManager.setDHull(member.getVariant());
                DModManager.addDMods(member, true, addDmods, this.itemGenRandom);
            }
        }
        member.getRepairTracker().setMothballed(true);
        member.getRepairTracker().setCR(0.5f);
        this.getCargo().getMothballedShips().addFleetMember(member);
        return member;
    }

    protected void pruneShips(float mult) {
        CargoAPI cargo = this.getCargo();
        FleetDataAPI data = cargo.getMothballedShips();
        for (FleetMemberAPI member : data.getMembersListCopy()) {
            if (!(this.itemGenRandom.nextFloat() > mult)) continue;
            data.removeFleetMember(member);
        }
    }

    protected void addHullMods(int maxTier, int num) {
        this.addHullMods(maxTier, num, null);
    }

    protected void addHullMods(int maxTier, int num, String factionId) {
        CargoAPI cargo = this.getCargo();
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            if (!stack.isModSpecStack()) continue;
            cargo.removeStack(stack);
        }
        FactionAPI faction = null;
        if (factionId != null) {
            faction = Global.getSector().getFaction(factionId);
        }
        WeightedRandomPicker<HullModSpecAPI> picker = new WeightedRandomPicker<HullModSpecAPI>(this.itemGenRandom);
        for (String id : this.submarket.getFaction().getKnownHullMods()) {
            HullModSpecAPI spec = Global.getSettings().getHullModSpec(id);
            if (spec.isHidden() || spec.isAlwaysUnlocked() || spec.getTier() > maxTier) continue;
            float p = spec.getRarity();
            if (faction != null && faction.getHullmodSellFrequency().containsKey(id) && !Global.getSector().getPlayerFaction().knowsHullMod(id)) {
                p *= faction.getHullmodSellFrequency().get(id).floatValue();
            }
            picker.add(spec, p);
        }
        int i = 0;
        while (i < num) {
            String id;
            HullModSpecAPI pick = (HullModSpecAPI)picker.pickAndRemove();
            if (pick != null && !this.cargoAlreadyHasMod(id = pick.getId()) && !Global.getSector().getPlayerFaction().knowsHullMod(id)) {
                cargo.addItems(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("modspec", id), 1.0f);
            }
            ++i;
        }
    }

    protected boolean removeModFromCargo(String id) {
        CargoAPI cargo = this.getCargo();
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            if (!stack.isModSpecStack() || !stack.getData().equals(id)) continue;
            cargo.removeStack(stack);
        }
        return false;
    }

    protected boolean cargoAlreadyHasMod(String id) {
        CargoAPI cargo = this.getCargo();
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            if (!stack.isSpecialStack() || !stack.getSpecialDataIfSpecial().getId().equals("modspec") || !stack.getSpecialDataIfSpecial().getData().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Highlights getIllegalTransferTextHighlights(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return null;
    }

    @Override
    public Highlights getIllegalTransferTextHighlights(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        return null;
    }

    public float getMinSWUpdateInterval() {
        return this.minSWUpdateInterval;
    }

    public void setMinSWUpdateInterval(float minCargoUpdateInterval) {
        this.minSWUpdateInterval = minCargoUpdateInterval;
    }

    public float getSinceLastCargoUpdate() {
        return this.sinceLastCargoUpdate;
    }

    public void setSinceLastCargoUpdate(float sinceLastCargoUpdate) {
        this.sinceLastCargoUpdate = sinceLastCargoUpdate;
    }

    public float getSinceSWUpdate() {
        return this.sinceSWUpdate;
    }

    public void setSinceSWUpdate(float sinceSWUpdate) {
        this.sinceSWUpdate = sinceSWUpdate;
    }

    @Override
    public boolean hasCustomTooltip() {
        return true;
    }

    @Override
    public void createTooltip(CoreUIAPI ui, TooltipMakerAPI tooltip, boolean expanded) {
        float opad = 10.0f;
        tooltip.addTitle(this.submarket.getNameOneLine());
        String desc = this.submarket.getSpec().getDesc();
        desc = Global.getSector().getRules().performTokenReplacement(null, desc, this.market.getPrimaryEntity(), null);
        String appendix = this.submarket.getPlugin().getTooltipAppendix(ui);
        if (appendix != null) {
            desc = String.valueOf(desc) + "\n\n" + appendix;
        }
        if (desc != null && !desc.isEmpty()) {
            Highlights h;
            LabelAPI body = tooltip.addPara(desc, opad);
            if (this.getTooltipAppendixHighlights(ui) != null && (h = this.submarket.getPlugin().getTooltipAppendixHighlights(ui)) != null) {
                body.setHighlightColors(h.getColors());
                body.setHighlight(h.getText());
            }
        }
        this.createTooltipAfterDescription(tooltip, expanded);
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    @Override
    public float getTooltipWidth() {
        return 400.0f;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean showInFleetScreen() {
        return true;
    }

    @Override
    public boolean showInCargoScreen() {
        return true;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    @Override
    public SubmarketAPI getSubmarket() {
        return this.submarket;
    }

    public int getStockpileLimit(CommodityOnMarketAPI com) {
        return 0;
    }

    public float getStockpilingAddRateMult(CommodityOnMarketAPI com) {
        return 1.0f;
    }

    public boolean shouldHaveCommodity(CommodityOnMarketAPI com) {
        return true;
    }

    public void addAndRemoveStockpiledResources(float amount, boolean withShortageCountering, boolean withDecreaseToLimit, boolean withCargoUpdate) {
        for (CommodityOnMarketAPI com : this.market.getCommoditiesCopy()) {
            if (com.isNonEcon() || com.getCommodity().isMeta()) continue;
            this.addAndRemoveStockpiledResources(com, amount, withShortageCountering, withDecreaseToLimit, withCargoUpdate);
        }
    }

    protected boolean doShortageCountering(CommodityOnMarketAPI com, float amount, boolean withShortageCountering) {
        return false;
    }

    public void addAndRemoveStockpiledResources(CommodityOnMarketAPI com, float amount, boolean withShortageCountering, boolean withDecreaseToLimit, boolean withCargoUpdate) {
        float days = Global.getSector().getClock().convertToDays(amount);
        if (com.isNonEcon()) {
            return;
        }
        if (com.getCommodity().isMeta()) {
            return;
        }
        CargoAPI cargo = this.getCargo();
        if (withShortageCountering) {
            withShortageCountering = this.market.isUseStockpilesForShortages();
        }
        if (this.doShortageCountering(com, amount, withShortageCountering)) {
            return;
        }
        if (!this.shouldHaveCommodity(com)) {
            if (withDecreaseToLimit) {
                float limit = this.getStockpileLimit(com);
                float curr = cargo.getCommodityQuantity(com.getId());
                if (curr > limit && withDecreaseToLimit) {
                    float removeRate = (curr - limit) * 2.0f / 30.0f;
                    float removeAmount = removeRate * days;
                    if (curr - removeAmount < limit) {
                        removeAmount = curr - limit;
                    }
                    if (removeAmount > 0.0f && curr <= 1.0f) {
                        removeAmount = 1.0f;
                    }
                    if (removeAmount > 0.0f) {
                        cargo.removeCommodity(com.getId(), removeAmount);
                    }
                }
            }
            return;
        }
        float limit = this.getStockpileLimit(com);
        float curr = cargo.getCommodityQuantity(com.getId());
        if (curr < limit && withCargoUpdate) {
            if (limit <= 0.0f) {
                return;
            }
            float addRate = limit / 30.0f * this.getStockpilingAddRateMult(com);
            if (this.sinceLastCargoUpdate * addRate + curr < 1.0f) {
                return;
            }
            float addAmount = addRate * days;
            if (curr + addAmount > limit) {
                addAmount = limit - curr;
            }
            if (addAmount > 0.0f) {
                float q = cargo.getCommodityQuantity(com.getId()) + addAmount;
                if (q < 1.0f) {
                    addAmount = 1.0f;
                }
                cargo.addCommodity(com.getId(), addAmount);
            }
            return;
        }
        if (curr > limit && withDecreaseToLimit) {
            float removeRate = (curr - limit) * 2.0f / 30.0f;
            float removeAmount = removeRate * days;
            if (curr - removeAmount < limit) {
                removeAmount = curr - limit;
            }
            if (removeAmount > 0.0f && curr <= 1.0f) {
                removeAmount = 1.0f;
            }
            if (removeAmount > 0.0f) {
                cargo.removeCommodity(com.getId(), removeAmount);
            }
            return;
        }
    }

    @Override
    public String getTariffTextOverride() {
        return null;
    }

    @Override
    public String getTariffValueOverride() {
        return null;
    }

    @Override
    public String getTotalTextOverride() {
        return null;
    }

    @Override
    public String getTotalValueOverride() {
        return null;
    }

    public static class ShipSalesData {
        private String variantId;
        private float numShips;
        private float totalValue;

        public String getVariantId() {
            return this.variantId;
        }

        public void setVariantId(String variantId) {
            this.variantId = variantId;
        }

        public float getNumShips() {
            return this.numShips;
        }

        public void setNumShips(float numShips) {
            this.numShips = numShips;
        }

        public float getTotalValue() {
            return this.totalValue;
        }

        public void setTotalValue(float totalValue) {
            this.totalValue = totalValue;
        }
    }
}

