/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.impl.items.BlueprintProviderItem;
import com.fs.starfarer.api.impl.campaign.CoreCampaignPluginImpl;
import com.fs.starfarer.api.impl.campaign.DelayedBlueprintLearnScript;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.impl.campaign.submarkets.OpenMarketPlugin;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Random;
import org.apache.log4j.Logger;

public class BlackMarketPlugin
extends BaseSubmarketPlugin {
    public static Logger log = Global.getLogger(BlackMarketPlugin.class);

    public void init(SubmarketAPI submarket) {
        super.init(submarket);
    }

    public void updateCargoPrePlayerInteraction() {
        float seconds = Global.getSector().getClock().convertToSeconds(this.sinceLastCargoUpdate);
        this.addAndRemoveStockpiledResources(seconds, false, true, true);
        this.sinceLastCargoUpdate = 0.0f;
        if (this.okToUpdateShipsAndWeapons()) {
            this.sinceSWUpdate = 0.0f;
            float stability = this.market.getStabilityValue();
            this.pruneWeapons(0.0f);
            boolean military = Misc.isMilitary(this.market);
            WeightedRandomPicker<String> factionPicker = new WeightedRandomPicker<String>();
            factionPicker.add(this.market.getFactionId(), 15.0f - stability);
            factionPicker.add("independent", 4.0f);
            factionPicker.add(this.submarket.getFaction().getId(), 6.0f);
            int weapons = 6 + Math.max(0, this.market.getSize() - 1) + (military ? 5 : 0);
            int fighters = 2 + Math.max(0, (this.market.getSize() - 3) / 2) + (military ? 2 : 0);
            weapons = 6 + Math.max(0, this.market.getSize() - 1);
            fighters = 2 + Math.max(0, (this.market.getSize() - 3) / 2);
            this.addWeapons(weapons, weapons + 2, 3, factionPicker);
            this.addFighters(fighters, fighters + 2, 3, factionPicker);
            if (military) {
                weapons = this.market.getSize();
                fighters = Math.max(1, this.market.getSize() / 3);
                this.addWeapons(weapons, weapons + 2, 3, this.market.getFactionId(), false);
                this.addFighters(fighters, fighters + 2, 3, this.market.getFactionId());
            }
            float sMult = 0.5f + Math.max(0.0f, 1.0f - stability / 10.0f) * 0.5f;
            this.getCargo().getMothballedShips().clear();
            float pOther = 0.1f;
            FactionDoctrineAPI doctrine = this.market.getFaction().getDoctrine().clone();
            this.addShips(this.market.getFactionId(), 70.0f * sMult, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, null, 0.0f, null, doctrine);
            FactionDoctrineAPI doctrineOverride = this.submarket.getFaction().getDoctrine().clone();
            doctrineOverride.setWarships(3);
            doctrineOverride.setPhaseShips(2);
            doctrineOverride.setCarriers(2);
            doctrineOverride.setCombatFreighterProbability(1.0f);
            doctrineOverride.setShipSize(5);
            this.addShips(this.submarket.getFaction().getId(), 70.0f, 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, Float.valueOf(Math.min(1.0f, Misc.getShipQuality(this.market, this.market.getFactionId()) + 0.5f)), 0.0f, null, doctrineOverride, 3);
            this.addShips("independent", 15.0f + 15.0f * sMult, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, this.itemGenRandom.nextFloat() > pOther ? 0.0f : 10.0f, Float.valueOf(Math.min(1.0f, Misc.getShipQuality(this.market, this.market.getFactionId()) + 0.5f)), 0.0f, null, null, 3);
            this.addHullMods(4, 1 + this.itemGenRandom.nextInt(3));
        }
        this.getCargo().sort();
    }

    protected Object writeReplace() {
        if (this.okToUpdateShipsAndWeapons()) {
            this.pruneWeapons(0.0f);
            this.getCargo().getMothballedShips().clear();
        }
        return this;
    }

    public int getStockpileLimit(CommodityOnMarketAPI com) {
        float limit = OpenMarketPlugin.getBaseStockpileLimit(com);
        Random random = new Random(this.market.getId().hashCode() + this.submarket.getSpecId().hashCode() + Global.getSector().getClock().getMonth() * 170000);
        limit *= 0.9f + 0.2f * random.nextFloat();
        float sm = 1.0f - this.market.getStabilityValue() / 10.0f;
        if ((limit *= 0.25f + 0.75f * sm) < 0.0f) {
            limit = 0.0f;
        }
        return (int)limit;
    }

    public SubmarketPlugin.PlayerEconomyImpactMode getPlayerEconomyImpactMode() {
        return SubmarketPlugin.PlayerEconomyImpactMode.PLAYER_SELL_ONLY;
    }

    public float getDesiredCommodityQuantity(CommodityOnMarketAPI com) {
        boolean illegal = this.market.isIllegal(com.getId());
        if (illegal) {
            return com.getStockpile();
        }
        float blackMarketLegalFraction = 1.0f - 0.09f * this.market.getStabilityValue();
        return com.getStockpile() * blackMarketLegalFraction;
    }

    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
        super.reportPlayerMarketTransaction(transaction);
        FactionAPI faction = this.submarket.getFaction();
        BlackMarketPlugin.delayedLearnBlueprintsFromTransaction(faction, this.getCargo(), transaction, 60.0f + 60.0f * (float)Math.random());
    }

    public static void delayedLearnBlueprintsFromTransaction(FactionAPI faction, CargoAPI cargo, PlayerMarketTransaction transaction) {
        BlackMarketPlugin.delayedLearnBlueprintsFromTransaction(faction, cargo, transaction, 60.0f + 60.0f * (float)Math.random());
    }

    public static void delayedLearnBlueprintsFromTransaction(FactionAPI faction, CargoAPI cargo, PlayerMarketTransaction transaction, float daysDelay) {
        DelayedBlueprintLearnScript script = new DelayedBlueprintLearnScript(faction.getId(), daysDelay);
        for (CargoStackAPI stack : transaction.getSold().getStacksCopy()) {
            SpecialItemPlugin plugin = stack.getPlugin();
            if (!(plugin instanceof BlueprintProviderItem)) continue;
            BlueprintProviderItem bpi = (BlueprintProviderItem)((Object)plugin);
            boolean learnedSomething = false;
            if (bpi.getProvidedFighters() != null) {
                for (String id : bpi.getProvidedFighters()) {
                    if (faction.knowsFighter(id)) continue;
                    script.getFighters().add(id);
                    learnedSomething = true;
                }
            }
            if (bpi.getProvidedWeapons() != null) {
                for (String id : bpi.getProvidedWeapons()) {
                    if (faction.knowsWeapon(id)) continue;
                    script.getWeapons().add(id);
                    learnedSomething = true;
                }
            }
            if (bpi.getProvidedShips() != null) {
                for (String id : bpi.getProvidedShips()) {
                    if (faction.knowsShip(id)) continue;
                    script.getShips().add(id);
                    learnedSomething = true;
                }
            }
            if (bpi.getProvidedIndustries() != null) {
                for (String id : bpi.getProvidedIndustries()) {
                    if (faction.knowsIndustry(id)) continue;
                    script.getIndustries().add(id);
                    learnedSomething = true;
                }
            }
            if (!learnedSomething) continue;
            cargo.removeItems(stack.getType(), stack.getData(), 1.0f);
        }
        if (!(script.getFighters().isEmpty() && script.getWeapons().isEmpty() && script.getShips().isEmpty() && script.getIndustries().isEmpty())) {
            Global.getSector().addScript(script);
            cargo.sort();
        }
    }

    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return false;
    }

    public boolean isIllegalOnSubmarket(String commodityId, SubmarketPlugin.TransferAction action) {
        return false;
    }

    public float getTariff() {
        return 0.0f;
    }

    public boolean isBlackMarket() {
        return true;
    }

    public String getTooltipAppendix(CoreUIAPI ui) {
        if (this.isEnabled(ui)) {
            float p = CoreCampaignPluginImpl.computeSmugglingSuspicionLevel(this.market);
            if (p < 0.05f) {
                return "\u6000\u7591\u7a0b\u5ea6\uff1a\u65e0";
            }
            if (p < 0.1f) {
                return "\u6000\u7591\u7a0b\u5ea6\uff1a\u8f7b\u5fae";
            }
            if (p < 0.2f) {
                return "\u6000\u7591\u7a0b\u5ea6\uff1a\u4e2d\u7b49";
            }
            if (p < 0.3f) {
                return "\u6000\u7591\u7a0b\u5ea6\uff1a\u8f83\u9ad8";
            }
            if (p < 0.5f) {
                return "\u6000\u7591\u7a0b\u5ea6\uff1a\u975e\u5e38\u9ad8";
            }
            return "\u6000\u7591\u7a0b\u5ea6\uff1a\u6781\u9ad8";
        }
        return null;
    }

    public Highlights getTooltipAppendixHighlights(CoreUIAPI ui) {
        String appendix = this.getTooltipAppendix(ui);
        if (appendix == null) {
            return null;
        }
        Highlights h = new Highlights();
        h.setText(appendix);
        h.setColors(Misc.getNegativeHighlightColor());
        return h;
    }
}

