/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.EconomyAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LocalResourcesSubmarketPlugin
extends BaseSubmarketPlugin
implements EconomyAPI.EconomyUpdateListener,
EconomyTickListener {
    public static float STOCKPILE_MULT_PRODUCTION = Global.getSettings().getFloat("stockpileMultProduction");
    public static float STOCKPILE_MULT_EXCESS = Global.getSettings().getFloat("stockpileMultExcess");
    public static float STOCKPILE_MULT_IMPORTS = Global.getSettings().getFloat("stockpileMultImports");
    public static float STOCKPILE_MAX_MONTHS = Global.getSettings().getFloat("stockpileMaxMonths");
    public static float STOCKPILE_COST_MULT = Global.getSettings().getFloat("stockpileCostMult");
    public static float STOCKPILE_SHORTAGE_COST_MULT = Global.getSettings().getFloat("stockpileShortageCostMult");
    protected CargoAPI taken;
    protected CargoAPI left;
    protected Map<String, MutableStat> stockpilingBonus = new HashMap<String, MutableStat>();
    protected transient CargoAPI preTransactionCargoCopy = null;

    public LocalResourcesSubmarketPlugin() {
        this.taken = Global.getFactory().createCargo(true);
        this.left = Global.getFactory().createCargo(true);
    }

    public void init(SubmarketAPI submarket) {
        super.init(submarket);
        Global.getSector().getEconomy().addUpdateListener(this);
        Global.getSector().getListenerManager().addListener(this);
    }

    public boolean showInFleetScreen() {
        return false;
    }

    public boolean showInCargoScreen() {
        return true;
    }

    public boolean isEnabled(CoreUIAPI ui) {
        return true;
    }

    public void advance(float amount) {
        super.advance(amount);
        this.addAndRemoveStockpiledResources(amount, true, false, true);
    }

    public boolean shouldHaveCommodity(CommodityOnMarketAPI com) {
        if (this.market.isIllegal(com)) {
            return !com.getCommodityMarketData().getMarketShareData(this.market).isSourceIsIllegal();
        }
        return true;
    }

    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        if (stack.getCommodityId() == null) {
            return true;
        }
        return stack.getResourceIfResource().hasTag("nonecon");
    }

    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return "\u53ea\u80fd\u5b58\u50a8\u8d44\u6e90";
    }

    public int getStockpileLimit(CommodityOnMarketAPI com) {
        int demand = com.getMaxDemand();
        int shippingGlobal = com.getCommodityMarketData().getMaxShipping(com.getMarket(), false);
        int available = com.getAvailable();
        String modId = this.submarket.getSpecId();
        MutableStat.StatMod mod = com.getAvailableStat().getFlatStatMod(modId);
        if (mod != null && (available -= (int)mod.value) < 0) {
            available = 0;
        }
        int production = com.getMaxSupply();
        production = Math.min(production, available);
        int export = 0;
        demand = com.getMaxDemand();
        export = Math.min(production, shippingGlobal);
        int extra = available - Math.max(export, demand);
        if (extra < 0) {
            extra = 0;
        }
        int deficit = demand - available;
        int imports = available - production;
        if (imports < 0) {
            imports = 0;
        }
        float unit = com.getCommodity().getEconUnit();
        float limit = 0.0f;
        limit += STOCKPILE_MULT_EXCESS * BaseIndustry.getSizeMult(extra) * unit;
        limit += STOCKPILE_MULT_PRODUCTION * BaseIndustry.getSizeMult(production -= extra) * unit;
        limit += STOCKPILE_MULT_IMPORTS * BaseIndustry.getSizeMult(imports) * unit;
        String cid = com.getId();
        if (this.stockpilingBonus.containsKey(cid)) {
            limit += this.stockpilingBonus.get(cid).getModifiedValue() * unit;
        }
        limit *= STOCKPILE_MAX_MONTHS;
        if (deficit > 0) {
            limit = 0.0f;
        }
        if (limit < 0.0f) {
            limit = 0.0f;
        }
        return (int)limit;
    }

    public float getStockpilingAddRateMult(CommodityOnMarketAPI com) {
        return 1.0f / STOCKPILE_MAX_MONTHS;
    }

    public void commodityUpdated(String commodityId) {
        if (Global.getSector().isPaused()) {
            CommodityOnMarketAPI com = this.market.getCommodityData(commodityId);
            this.addAndRemoveStockpiledResources(com, 0.0f, true, false, false);
        }
    }

    public void economyUpdated() {
        if (Global.getSector().isPaused()) {
            this.addAndRemoveStockpiledResources(0.0f, true, false, false);
        }
    }

    public boolean isEconomyListenerExpired() {
        return !this.market.hasSubmarket(this.submarket.getSpecId());
    }

    public boolean isParticipatesInEconomy() {
        return false;
    }

    public boolean isHidden() {
        return !this.market.isPlayerOwned();
    }

    public float getTariff() {
        return 0.0f;
    }

    public boolean isFreeTransfer() {
        return true;
    }

    public void updateCargoPrePlayerInteraction() {
        this.preTransactionCargoCopy = this.getCargo().createCopy();
        this.preTransactionCargoCopy.sort();
        this.getCargo().sort();
    }

    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
        this.sinceLastCargoUpdate = 0.0f;
        this.preTransactionCargoCopy = this.getCargo().createCopy();
        this.preTransactionCargoCopy.sort();
        this.taken.addAll(transaction.getBought());
        this.left.addAll(transaction.getSold());
        CargoAPI copy = this.taken.createCopy();
        this.taken.removeAll(this.left);
        this.left.removeAll(copy);
    }

    protected Object readResolve() {
        super.readResolve();
        if (this.taken == null) {
            this.taken = Global.getFactory().createCargo(true);
        }
        if (this.left == null) {
            this.left = Global.getFactory().createCargo(true);
        }
        if (this.stockpilingBonus == null) {
            this.stockpilingBonus = new HashMap<String, MutableStat>();
        }
        return this;
    }

    public MutableStat getStockpilingBonus(String cid) {
        MutableStat stat = this.stockpilingBonus.get(cid);
        if (stat == null) {
            stat = new MutableStat(0.0f);
            this.stockpilingBonus.put(cid, stat);
        }
        return stat;
    }

    public CargoAPI getLeft() {
        return this.left;
    }

    public int getEstimatedShortageCounteringCostPerMonth() {
        ArrayList<CommodityOnMarketAPI> all = new ArrayList<CommodityOnMarketAPI>(this.market.getAllCommodities());
        float totalCost = 0.0f;
        CargoAPI cargo = this.getCargo();
        for (CommodityOnMarketAPI com : all) {
            int curr = (int)cargo.getCommodityQuantity(com.getId());
            if (curr <= 0) continue;
            float units = LocalResourcesSubmarketPlugin.getDeficitMonthlyCommodityUnits(com);
            units = Math.min(units, cargo.getCommodityQuantity(com.getId()));
            if (!((units -= this.taken.getCommodityQuantity(com.getId())) > 0.0f)) continue;
            float per = LocalResourcesSubmarketPlugin.getStockpilingUnitPrice(com.getCommodity(), true);
            totalCost += units * per;
        }
        return (int)totalCost;
    }

    public static int getStockpilingUnitPrice(CommoditySpecAPI spec, boolean forShortageCountering) {
        int result;
        float mult = STOCKPILE_COST_MULT;
        if (forShortageCountering) {
            mult = STOCKPILE_SHORTAGE_COST_MULT;
        }
        if ((result = Math.round(spec.getBasePrice() * mult)) < 1) {
            result = 1;
        }
        return result;
    }

    public static float getDeficitMonthlyCommodityUnits(CommodityOnMarketAPI com) {
        int available;
        int demand;
        String modId = "local_resources";
        MutableStat.StatMod mod = com.getAvailableStat().getFlatMods().get(modId);
        float modAlready = 0.0f;
        if (mod != null) {
            modAlready = mod.value;
        }
        if ((demand = com.getMaxDemand()) > (available = Math.round((float)com.getAvailable() - modAlready))) {
            float deficitDrawBaseAmount = BaseIndustry.getSizeMult(demand) - BaseIndustry.getSizeMult(available);
            return deficitDrawBaseAmount *= com.getCommodity().getEconUnit();
        }
        return 0.0f;
    }

    protected boolean doShortageCountering(CommodityOnMarketAPI com, float amount, boolean withShortageCountering) {
        CargoAPI cargo = this.getCargo();
        String modId = this.submarket.getSpecId();
        com.getAvailableStat().unmodifyFlat(modId);
        int demand = com.getMaxDemand();
        int available = com.getAvailable();
        if (withShortageCountering && demand > available) {
            int deficit = demand - available;
            if (deficit != deficit) {
                return false;
            }
            float deficitDrawBaseAmount = BaseIndustry.getSizeMult(demand) - BaseIndustry.getSizeMult(available);
            float \u5929 = Global.getSector().getClock().convertToDays(amount);
            float drawAmount = (deficitDrawBaseAmount *= com.getCommodity().getEconUnit()) * \u5929 / 30.0f;
            float curr = cargo.getCommodityQuantity(com.getId());
            if (curr > 0.0f && deficitDrawBaseAmount > 0.0f) {
                int daysLeft = (int)(curr / deficitDrawBaseAmount * 30.0f);
                String daysStr = "\u5929";
                if (daysLeft <= 1) {
                    daysLeft = 1;
                    daysStr = "\u5929";
                }
                com.getAvailableStat().modifyFlat(modId, deficit, "\u672c\u5730\u8d44\u6e90\u5e93\u5b58 ( " + daysLeft + " " + daysStr + " \u540e\u6d88\u8017\u5b8c\u6bd5) ");
                float free = this.left.getCommodityQuantity(com.getId());
                free = Math.min(drawAmount, free);
                this.left.removeCommodity(com.getId(), free);
                if (drawAmount > 0.0f) {
                    cargo.removeCommodity(com.getId(), drawAmount);
                }
                drawAmount -= free;
                if (this.market.isPlayerOwned() && drawAmount > 0.0f) {
                    MonthlyReport report = SharedData.getData().getCurrentReport();
                    MonthlyReport.FDNode node = report.getCounterShortageNode(this.market);
                    CargoAPI tooltipCargo = (CargoAPI)node.custom2;
                    float addToTooltipCargo = drawAmount;
                    float q = tooltipCargo.getCommodityQuantity(com.getId()) + addToTooltipCargo;
                    if (q < 1.0f) {
                        addToTooltipCargo = 1.0f;
                    }
                    tooltipCargo.addCommodity(com.getId(), addToTooltipCargo);
                    float unitPrice = LocalResourcesSubmarketPlugin.getStockpilingUnitPrice(com.getCommodity(), true);
                    MonthlyReport.FDNode comNode = report.getNode(node, com.getId());
                    CommoditySpecAPI spec = com.getCommodity();
                    comNode.icon = spec.getIconName();
                    comNode.upkeep += unitPrice * drawAmount;
                    comNode.custom = com;
                    if (comNode.custom2 == null) {
                        comNode.custom2 = Float.valueOf(0.0f);
                    }
                    comNode.custom2 = Float.valueOf(((Float)comNode.custom2).floatValue() + drawAmount);
                    float qty = Math.max(1.0f, ((Float)comNode.custom2).floatValue());
                    qty = (float)Math.ceil(qty);
                    comNode.name = String.valueOf(spec.getName()) + " " + "\u00d7" + Misc.getWithDGS(qty);
                    comNode.tooltipCreator = report.getMonthlyReportTooltip();
                }
            }
            return true;
        }
        return false;
    }

    public void reportEconomyMonthEnd() {
        if (this.isEconomyListenerExpired()) {
            Global.getSector().getListenerManager().removeListener(this);
            return;
        }
    }

    public void reportEconomyTick(int iterIndex) {
        if (this.isEconomyListenerExpired()) {
            Global.getSector().getListenerManager().removeListener(this);
            return;
        }
        int lastIterInMonth = (int)Global.getSettings().getFloat("economyIterPerMonth") - 1;
        if (iterIndex != lastIterInMonth) {
            return;
        }
        if (this.market.isPlayerOwned()) {
            CargoAPI copy = this.taken.createCopy();
            this.taken.removeAll(this.left);
            this.left.removeAll(copy);
            MonthlyReport report = SharedData.getData().getCurrentReport();
            for (CargoStackAPI stack : this.taken.getStacksCopy()) {
                if (!stack.isCommodityStack()) continue;
                MonthlyReport.FDNode node = report.getRestockingNode(this.market);
                CargoAPI tooltipCargo = (CargoAPI)node.custom2;
                float addToTooltipCargo = stack.getSize();
                String cid = stack.getCommodityId();
                float q = tooltipCargo.getCommodityQuantity(cid) + addToTooltipCargo;
                if (q < 1.0f) {
                    addToTooltipCargo = 1.0f;
                }
                tooltipCargo.addCommodity(cid, addToTooltipCargo);
                float unitPrice = LocalResourcesSubmarketPlugin.getStockpilingUnitPrice(stack.getResourceIfResource(), false);
                MonthlyReport.FDNode comNode = report.getNode(node, cid);
                CommoditySpecAPI spec = stack.getResourceIfResource();
                comNode.icon = spec.getIconName();
                comNode.upkeep += unitPrice * addToTooltipCargo;
                comNode.custom = this.market.getCommodityData(cid);
                if (comNode.custom2 == null) {
                    comNode.custom2 = Float.valueOf(0.0f);
                }
                comNode.custom2 = Float.valueOf(((Float)comNode.custom2).floatValue() + addToTooltipCargo);
                float qty = Math.max(1.0f, ((Float)comNode.custom2).floatValue());
                qty = (float)Math.ceil(qty);
                comNode.name = String.valueOf(spec.getName()) + " " + "\u00d7" + Misc.getWithDGS(qty);
                comNode.tooltipCreator = report.getMonthlyReportTooltip();
            }
        }
        this.taken.clear();
    }

    public String getBuyVerb() {
        return "\u62ff\u53d6";
    }

    public String getSellVerb() {
        return "\u79bb\u5f00";
    }

    public String getTariffTextOverride() {
        return "\u6708\u5e95\u5c06\u6263\u9664";
    }

    public String getTariffValueOverride() {
        if (this.preTransactionCargoCopy == null) {
            return null;
        }
        CargoAPI cargo = this.getCargo();
        float total = 0.0f;
        HashSet<String> seen = new HashSet<String>();
        for (CargoStackAPI stack : this.preTransactionCargoCopy.getStacksCopy()) {
            String cid;
            if (!stack.isCommodityStack() || seen.contains(cid = stack.getCommodityId())) continue;
            seen.add(cid);
            CommodityOnMarketAPI com = this.market.getCommodityData(cid);
            int pre = (int)this.preTransactionCargoCopy.getCommodityQuantity(cid);
            int post = (int)cargo.getCommodityQuantity(cid);
            int units = pre - post;
            units = (int)((float)units - this.left.getCommodityQuantity(cid));
            if (units <= 0) continue;
            float price = LocalResourcesSubmarketPlugin.getStockpilingUnitPrice(com.getCommodity(), false);
            total += price * (float)units;
        }
        return Misc.getDGSCredits(total);
    }

    public String getTotalTextOverride() {
        return "\u73b0\u5728\u5c06\u6263\u9664";
    }

    public String getTotalValueOverride() {
        return "0\u00a2";
    }

    public boolean isTooltipExpandable() {
        return false;
    }

    public float getTooltipWidth() {
        return 500.0f;
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        ArrayList<CommodityOnMarketAPI> all = new ArrayList<CommodityOnMarketAPI>(this.market.getAllCommodities());
        Collections.sort(all, new Comparator<CommodityOnMarketAPI>(){

            @Override
            public int compare(CommodityOnMarketAPI o1, CommodityOnMarketAPI o2) {
                int limit1 = LocalResourcesSubmarketPlugin.this.getStockpileLimit(o1);
                int limit2 = LocalResourcesSubmarketPlugin.this.getStockpileLimit(o2);
                return limit2 - limit1;
            }
        });
        float opad = 10.0f;
        tooltip.beginGridFlipped(400.0f, 1, 70.0f, opad);
        int j = 0;
        for (CommodityOnMarketAPI com : all) {
            int limit;
            if (com.isNonEcon() || com.getCommodity().isMeta() || !this.shouldHaveCommodity(com) || (limit = Math.round((float)this.getStockpileLimit(com) * this.getStockpilingAddRateMult(com))) <= 0) continue;
            tooltip.addToGrid(0, j++, com.getCommodity().getName(), Misc.getWithDGS(limit));
        }
        tooltip.addPara("\u90e8\u5206\u6b96\u6c11\u5730\u751f\u4ea7\u7684\u8d27\u7269\u4f1a\u5728\u6b64\u53ef\u89c1\u3002\u4f60\u53ef\u4ee5\u4ee5\u8d27\u7269\u57fa\u7840\u4ef7\u683c\u7684 %s \u4ece\u6b96\u6c11\u5730\u5e02\u573a\u62ff\u53d6\u8fd9\u4e9b\u8d27\u7269\u3002\u8be5\u5f00\u652f\u4f1a\u5728\u6708\u5e95\u6263\u9664\u3002", opad, Misc.getHighlightColor(), Math.round(STOCKPILE_COST_MULT * 100.0f) + "%");
        tooltip.addPara("\u8fd9\u4e9b\u8d27\u7269\u4e5f\u53ef\u4ee5\u88ab\u7528\u6765\u5e94\u5bf9\u77ed\u671f\u77ed\u7f3a\uff0c\u8fd9\u5c06\u82b1\u8d39\u8d27\u7269\u57fa\u672c\u4ef7\u503c\u7684 %s}\u3002\u5982\u679c\u4f60\u5728\u6b64\u989d\u5916\u5b58\u653e\u8d27\u7269\uff0c\u90a3\u4e9b\u8d27\u7269\u4e5f\u4f1a\u88ab\u4f7f\u7528\uff0c\u4f46\u4e0d\u4f1a\u9020\u6210\u5f00\u9500\u3002", opad, Misc.getHighlightColor(), Math.round(STOCKPILE_SHORTAGE_COST_MULT * 100.0f) + "%");
        tooltip.addSectionHeading("\u6bcf\u6708\u5e93\u5b58\u50a8\u5907\u91cf", this.market.getFaction().getBaseUIColor(), this.market.getFaction().getDarkUIColor(), Alignment.MID, opad);
        if (j > 0) {
            tooltip.addGrid(opad);
            tooltip.addPara("\u8d44\u6e90\u7684\u6700\u5927\u5e93\u5b58\u91cf\u4e0d\u5f97\u8d85\u8fc7\u6bcf\u6708\u4ea7\u91cf\u7684 %s.", opad, Misc.getHighlightColor(), (int)STOCKPILE_MAX_MONTHS + "\u00d7");
        } else {
            tooltip.addPara("\u6ca1\u6709\u5e93\u5b58\u3002", opad);
        }
    }
}

