/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class StoragePlugin
extends BaseSubmarketPlugin {
    private boolean playerPaidToUnlock = false;

    public void init(SubmarketAPI submarket) {
        super.init(submarket);
    }

    public void updateCargoPrePlayerInteraction() {
    }

    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        if (this.market.isPlayerOwned()) {
            return false;
        }
        return super.isIllegalOnSubmarket(stack, action);
    }

    public boolean isIllegalOnSubmarket(String commodityId, SubmarketPlugin.TransferAction action) {
        if (this.market.isPlayerOwned()) {
            return false;
        }
        return super.isIllegalOnSubmarket(commodityId, action);
    }

    public boolean isIllegalOnSubmarket(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        if (this.market.isPlayerOwned() || this.market.getFaction() != null && this.market.getFaction().isNeutralFaction()) {
            return false;
        }
        return super.isIllegalOnSubmarket(member, action);
    }

    public boolean isParticipatesInEconomy() {
        return false;
    }

    public float getTariff() {
        return 0.0f;
    }

    public boolean isFreeTransfer() {
        return true;
    }

    public String getBuyVerb() {
        return "\u62ff\u53d6";
    }

    public String getSellVerb() {
        return "\u5b58\u653e";
    }

    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return "\u65e0\u6cd5\u5b58\u50a8\u8fdd\u7981\u54c1";
    }

    public boolean isEnabled(CoreUIAPI ui) {
        return true;
    }

    public void setPlayerPaidToUnlock(boolean playerPaidToUnlock) {
        this.playerPaidToUnlock = playerPaidToUnlock;
    }

    public SubmarketPlugin.OnClickAction getOnClickAction(CoreUIAPI ui) {
        if (this.playerPaidToUnlock) {
            return SubmarketPlugin.OnClickAction.OPEN_SUBMARKET;
        }
        return SubmarketPlugin.OnClickAction.SHOW_TEXT_DIALOG;
    }

    private int getUnlockCost() {
        return 5000;
    }

    private boolean canPlayerAffordUnlock() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        int credits = (int)playerFleet.getCargo().getCredits().get();
        return credits >= this.getUnlockCost();
    }

    public String getDialogText(CoreUIAPI ui) {
        if (this.canPlayerAffordUnlock()) {
            return "\u4f7f\u7528\u6b64\u5730\u4ed3\u5e93\u9700\u8981\u7f34\u7eb3\u4e00\u6b21\u6027\u4f7f\u7528\u8d39 " + this.getUnlockCost() + " \u661f\u5e01\u3002";
        }
        return "\u4f7f\u7528\u6b64\u5730\u4ed3\u5e93\u9700\u8981\u7f34\u7eb3\u4e00\u6b21\u6027\u4f7f\u7528\u8d39 " + this.getUnlockCost() + " \u661f\u5e01\uff0c\u4f60\u4e70\u4e0d\u8d77\u3002";
    }

    public Highlights getDialogTextHighlights(CoreUIAPI ui) {
        Highlights h = new Highlights();
        h.setText("" + this.getUnlockCost());
        if (this.canPlayerAffordUnlock()) {
            h.setColors(Misc.getHighlightColor());
        } else {
            h.setColors(Misc.getNegativeHighlightColor());
        }
        return h;
    }

    public SubmarketPlugin.DialogOption[] getDialogOptions(CoreUIAPI ui) {
        if (this.canPlayerAffordUnlock()) {
            return new SubmarketPlugin.DialogOption[]{new SubmarketPlugin.DialogOption("\u652f\u4ed8", new Script(){

                public void run() {
                    CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                    playerFleet.getCargo().getCredits().subtract(StoragePlugin.this.getUnlockCost());
                    StoragePlugin.this.playerPaidToUnlock = true;
                }
            }), new SubmarketPlugin.DialogOption("\u653e\u5f03", null)};
        }
        return new SubmarketPlugin.DialogOption[]{new SubmarketPlugin.DialogOption("\u653e\u5f03", null)};
    }

    public String getTooltipAppendix(CoreUIAPI ui) {
        return null;
    }

    public Highlights getTooltipAppendixHighlights(CoreUIAPI ui) {
        return null;
    }

    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        int shipCost;
        if (!this.market.isInEconomy()) {
            return;
        }
        float opad = 10.0f;
        float pad = 3.0f;
        if (this.market.isPlayerOwned()) {
            tooltip.addPara(Misc.getTokenReplaced("\u7531\u4e8e $market \u5728\u4f60\u7684\u63a7\u5236\u4e4b\u4e0b\uff0c\u6240\u4ee5\u5c06\u4e0d\u4f1a\u6536\u53d6\u4efb\u4f55\u4f7f\u7528\u8d39\u4e0e\u79df\u91d1\u3002", this.market.getPrimaryEntity()), opad);
            return;
        }
        float f = Misc.getStorageFeeFraction();
        int percent = (int)(f * 100.0f);
        Color h = Misc.getHighlightColor();
        if (!this.playerPaidToUnlock) {
            tooltip.addPara("\u9700\u652f\u4ed8 %s \u9996\u6b21\u4f7f\u7528\u8d39\uff0c\u4e14\u6309\u7167\u5b58\u50a8\u7269\u603b\u4ef7\u503c\u7684 %s \u4f5c\u4e3a\u6bcf\u6708\u79df\u91d1\u3002", opad, h, this.getUnlockCost() + "\u00a2", percent + "%");
            return;
        }
        int cargoCost = (int)(Misc.getStorageCargoValue(this.market) * f);
        if (cargoCost + (shipCost = (int)(Misc.getStorageShipValue(this.market) * f)) > 0) {
            tooltip.addPara("\u6bcf\u6708\u79df\u91d1 (\u5b58\u50a8\u7269\u603b\u4ef7\u503c\u7684 %s )\uff1a", opad, h, percent + "%");
            tooltip.beginGridFlipped(300.0f, 1, 80.0f, 10.0f);
            int j = 0;
            tooltip.addToGrid(0, j++, "\u4ed3\u5e93\u91cc\u7684\u8230\u8239", Misc.getDGSCredits(shipCost));
            tooltip.addToGrid(0, j++, "\u5b58\u50a8\u7684\u8d27\u7269", Misc.getDGSCredits(cargoCost));
            tooltip.addGrid(pad);
        } else {
            tooltip.addPara("\u6bcf\u6708\u7684\u8d39\u7528\u4e0e\u5f00\u652f\u7b49\u4e8e\u50a8\u5b58\u7269\u54c1\u57fa\u7840\u4ef7\u503c\u7684 %s.", opad, h, percent + "%");
        }
    }
}

