/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidImpact;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidSource;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.RingRenderer;
import com.fs.starfarer.api.impl.campaign.terrain.RingSystemTerrainPlugin;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;

public class AsteroidBeltTerrainPlugin
extends BaseRingTerrain
implements AsteroidSource {
    private transient RingRenderer rr;
    protected boolean needToCreateAsteroids = true;
    public AsteroidBeltParams params;

    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    public void renderOnMap(float factor, float alphaMult) {
        if (this.params == null) {
            return;
        }
        if (this.rr == null) {
            this.rr = new RingRenderer("systemMap", "map_asteroid_belt");
        }
        Color color = Global.getSettings().getColor("asteroidBeltMapColor");
        float bandWidth = this.params.bandWidthInEngine;
        bandWidth = 300.0f;
        this.rr.render(this.entity.getLocation(), this.params.middleRadius - bandWidth * 0.5f, this.params.middleRadius + bandWidth * 0.5f, color, false, factor, alphaMult);
    }

    public void regenerateAsteroids() {
        this.createAsteroids();
    }

    protected void createAsteroids() {
        if (!(this.params instanceof AsteroidBeltParams)) {
            return;
        }
        Random rand = new Random(Global.getSector().getClock().getTimestamp() + (long)this.entity.getId().hashCode());
        LocationAPI location = this.entity.getContainingLocation();
        int i = 0;
        while (i < this.params.numAsteroids) {
            float size = this.params.minSize + rand.nextFloat() * (this.params.maxSize - this.params.minSize);
            AsteroidAPI asteroid = location.addAsteroid(size);
            asteroid.setFacing(rand.nextFloat() * 360.0f);
            float currRadius = this.params.middleRadius - this.params.bandWidthInEngine / 2.0f + rand.nextFloat() * this.params.bandWidthInEngine;
            float angle = rand.nextFloat() * 360.0f;
            float orbitDays = this.params.minOrbitDays + rand.nextFloat() * (this.params.maxOrbitDays - this.params.minOrbitDays);
            asteroid.setCircularOrbit(this.entity, angle, currRadius, orbitDays);
            Misc.setAsteroidSource(asteroid, this);
            ++i;
        }
        this.needToCreateAsteroids = false;
    }

    public void advance(float amount) {
        if (this.needToCreateAsteroids) {
            this.createAsteroids();
        }
        super.advance(amount);
    }

    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        if (param instanceof AsteroidBeltParams) {
            this.params = (AsteroidBeltParams)param;
            this.name = this.params.name;
            if (this.name == null) {
                this.name = "\u5c0f\u884c\u661f\u5e26";
            }
        }
    }

    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        super.render(layer, viewport);
    }

    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            if (Misc.isSlowMoving(fleet)) {
                fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_2", "\u9690\u85cf\u4e8e " + this.getNameForTooltip().toLowerCase(), RingSystemTerrainPlugin.getVisibilityMult(fleet), fleet.getStats().getDetectedRangeMod());
            }
            if (!fleet.isInHyperspaceTransition()) {
                String key = "$asteroidImpactTimeout";
                String sKey = "$skippedImpacts";
                String recentKey = "$recentImpact";
                float probPerSkip = 0.15f;
                float maxProb = 1.0f;
                float maxSkipsToTrack = 7.0f;
                float durPerSkip = 0.2f;
                MemoryAPI mem = fleet.getMemoryWithoutUpdate();
                if (!mem.contains(key)) {
                    float expire2 = mem.getExpire(sKey);
                    if (expire2 < 0.0f) {
                        expire2 = 0.0f;
                    }
                    float hitProb = Misc.getFleetRadiusTerrainEffectMult(fleet) * 0.5f;
                    hitProb = 0.5f;
                    hitProb = expire2 / durPerSkip * probPerSkip;
                    if (hitProb > maxProb) {
                        hitProb = maxProb;
                    }
                    if ((float)Math.random() < hitProb) {
                        boolean hadRecent = mem.is(recentKey, true);
                        fleet.addScript(new AsteroidImpact(fleet, hadRecent &= (float)Math.random() > 0.5f));
                        mem.set(sKey, true, 0.0f);
                        mem.set(recentKey, true, 0.5f + 1.0f * (float)Math.random());
                    } else {
                        mem.set(sKey, true, Math.min(expire2 + durPerSkip, maxSkipsToTrack * durPerSkip));
                    }
                    mem.set(key, true, (float)((double)0.05f + (double)0.1f * Math.random()));
                }
            }
        }
    }

    public boolean hasTooltip() {
        return true;
    }

    public String getNameForTooltip() {
        return "\u5c0f\u884c\u661f\u5e26";
    }

    public String getNameAOrAn() {
        return "\u4e00\u4e2a";
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle(this.getNameForTooltip());
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("\u822a\u884c\u5f71\u54cd", Alignment.MID, pad);
            nextPad = small;
        }
        tooltip.addPara("\u53ef\u80fd\u4f1a\u906d\u9047\u5c0f\u884c\u661f\u7684\u649e\u51fb\uff0c\u4e0d\u4ec5\u4f1a\u77ed\u6682\u5730\u8ba9\u8230\u961f\u504f\u79bb\u822a\u5411\uff0c\u5f53\u51fa\u73b0\u76f4\u63a5\u649e\u51fb\u4e8b\u6545\u65f6\uff0c\u5c06\u9020\u6210\u4e2d\u7b49\u7a0b\u5ea6\u7684\u635f\u4f24\u3002", nextPad);
        tooltip.addPara("\u89c4\u6a21\u8f83\u5c0f\u7684\u8230\u961f\u901a\u5e38\u80fd\u907f\u5f00\u5c0f\u884c\u661f\u7684\u76f4\u63a5\u649e\u51fb\uff0c\u800c\u8fdb\u884c\u7f13\u901f\u822a\u884c\u7684\u8230\u961f\u5c06\u6ca1\u6709\u4efb\u4f55\u98ce\u9669\u3002", pad, highlight, "\u7f13\u901f\u822a\u884c");
        String stop = Global.getSettings().getControlStringForEnumName("GO_SLOW");
        tooltip.addPara("\u964d\u4f4e\u5728\u5176\u4e2d\u9759\u6b62\u6216 \u7f13\u901f\u822a\u884c* \u7684\u8230\u961f%s \u88ab\u4fa6\u6d4b\u5230\u7684\u8303\u56f4\u3002", nextPad, highlight, (int)((1.0f - RingSystemTerrainPlugin.getVisibilityMult(Global.getSector().getPlayerFleet())) * 100.0f) + "%");
        tooltip.addPara("* \u6309\u4f4f %s \u505c\u6b62\u822a\u884c\uff0c\u540c\u65f6\u6309\u4f4f\u9f20\u6807\u5de6\u952e\u5219\u6539\u4e3a\u7f13\u901f\u822a\u884c\u3002\u4e00\u652f\u5904\u4e8e\u7f13\u901f\u822a\u884c\u72b6\u6001\u7684\u8230\u961f\u5b87\u5b99\u822a\u884c\u901f\u5ea6\u4ec5\u4e3a\u6700\u6162\u8230\u8239\u7684\u4e00\u534a\u3002", nextPad, Misc.getGrayColor(), highlight, stop);
        if (expanded) {
            tooltip.addSectionHeading("\u6218\u6597\u5f71\u54cd", Alignment.MID, pad);
            tooltip.addPara("\u5728\u6218\u573a\u4e0a\u51fa\u73b0\u5927\u91cf\u7684\u5c0f\u884c\u661f\u3002\u591a\u5230\u8db3\u4ee5\u5728\u6218\u6597\u4e2d\u9020\u6210\u5a01\u80c1\u3002", small);
        }
    }

    public boolean isTooltipExpandable() {
        return true;
    }

    public float getTooltipWidth() {
        return 350.0f;
    }

    public String getEffectCategory() {
        return "asteroid_belt";
    }

    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.REDUCES_SPEED_LARGE || flag == TerrainAIFlags.DANGEROUS_UNLESS_GO_SLOW || flag == TerrainAIFlags.NOT_SUPER_DANGEROUS_UNLESS_GO_SLOW;
    }

    public void reportAsteroidPersisted(SectorEntityToken asteroid) {
        if (Misc.getAsteroidSource(asteroid) == this) {
            --this.params.numAsteroids;
        }
    }

    public static class AsteroidBeltParams
    extends BaseRingTerrain.RingParams {
        public int numAsteroids;
        public float minOrbitDays;
        public float maxOrbitDays;
        public float minSize;
        public float maxSize;

        public AsteroidBeltParams(int numAsteroids, float orbitRadius, float width, float minOrbitDays, float maxOrbitDays, float minSize, float maxSize, String name) {
            super(width, orbitRadius, null, name);
            this.numAsteroids = numAsteroids;
            this.minOrbitDays = minOrbitDays;
            this.maxOrbitDays = maxOrbitDays;
            this.minSize = minSize;
            this.maxSize = maxSize;
        }
    }
}

