/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidBeltTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;

public class AsteroidFieldTerrainPlugin
extends AsteroidBeltTerrainPlugin {
    public AsteroidFieldParams params;
    private transient SpriteAPI icon = null;

    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (AsteroidFieldParams)param;
        this.name = this.params.name;
        if (this.name == null) {
            this.name = "\u5c0f\u884c\u661f\u7fa4";
        }
        this.params.numAsteroids = this.params.minAsteroids;
        if (this.params.maxAsteroids > this.params.minAsteroids) {
            this.params.numAsteroids += new Random().nextInt(this.params.maxAsteroids - this.params.minAsteroids);
        }
    }

    public void renderOnMap(float factor, float alphaMult) {
    }

    public void regenerateAsteroids() {
        this.createAsteroidField();
    }

    protected void createAsteroidField() {
        float fieldRadius;
        if (!(this.params instanceof AsteroidFieldParams)) {
            return;
        }
        Random rand = new Random(Global.getSector().getClock().getTimestamp() + (long)this.entity.getId().hashCode());
        this.params.bandWidthInEngine = fieldRadius = this.params.minRadius + (this.params.maxRadius - this.params.minRadius) * rand.nextFloat();
        this.params.middleRadius = fieldRadius / 2.0f;
        LocationAPI location = this.entity.getContainingLocation();
        if (location == null) {
            return;
        }
        int i = 0;
        while (i < this.params.numAsteroids) {
            float size = this.params.minSize + (this.params.maxSize - this.params.minSize) * rand.nextFloat();
            AsteroidAPI asteroid = location.addAsteroid(size);
            asteroid.setFacing(rand.nextFloat() * 360.0f);
            float r = rand.nextFloat();
            r = 1.0f - r * r;
            float currRadius = fieldRadius * r;
            float minOrbitDays = Math.max(1.0f, currRadius * 0.05f);
            float maxOrbitDays = Math.max(2.0f, currRadius * 2.0f * 0.05f);
            float orbitDays = minOrbitDays + rand.nextFloat() * (maxOrbitDays - minOrbitDays);
            float angle = rand.nextFloat() * 360.0f;
            asteroid.setCircularOrbit(this.entity, angle, currRadius, orbitDays);
            Misc.setAsteroidSource(asteroid, this);
            ++i;
        }
        this.needToCreateAsteroids = false;
    }

    public void advance(float amount) {
        if (this.needToCreateAsteroids) {
            this.createAsteroidField();
        }
        super.advance(amount);
    }

    public String getNameForTooltip() {
        return "\u5c0f\u884c\u661f\u7fa4";
    }

    public void reportAsteroidPersisted(SectorEntityToken asteroid) {
        if (Misc.getAsteroidSource(asteroid) == this) {
            --this.params.numAsteroids;
        }
    }

    public static class AsteroidFieldParams
    extends BaseRingTerrain.RingParams {
        public float minRadius;
        public float maxRadius;
        public int minAsteroids;
        public int maxAsteroids;
        public float minSize;
        public float maxSize;
        public int numAsteroids;

        public AsteroidFieldParams(float minRadius, float maxRadius, int minAsteroids, int maxAsteroids, float minSize, float maxSize, String name) {
            super(maxRadius, maxRadius / 2.0f, null, name);
            this.minRadius = minRadius;
            this.maxRadius = maxRadius;
            this.minAsteroids = minAsteroids;
            this.maxAsteroids = maxAsteroids;
            this.minSize = minSize;
            this.maxSize = maxSize;
        }
    }
}

