/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class AsteroidImpact
implements EveryFrameScript {
    public static float DURATION_SECONDS = 0.2f;
    protected CampaignFleetAPI fleet;
    protected float elapsed;
    protected Vector2f dV;

    public AsteroidImpact(CampaignFleetAPI fleet, boolean dealDamage) {
        this.fleet = fleet;
        Vector2f v = fleet.getVelocity();
        float angle = Misc.getAngleInDegrees(v);
        float speed = v.length();
        if (speed < 10.0f) {
            angle = fleet.getFacing();
        }
        float mult = Misc.getFleetRadiusTerrainEffectMult(fleet);
        float arc = 120.0f - 60.0f * mult;
        angle += (float)Math.random() * arc - arc / 2.0f;
        angle += 180.0f;
        if (Misc.isSlowMoving(fleet) || mult <= 0.0f) {
            this.elapsed = DURATION_SECONDS;
            this.dV = new Vector2f();
        } else if (fleet.isInCurrentLocation()) {
            Vector2f test;
            float dist;
            if (dealDamage) {
                FleetMemberAPI member2;
                WeightedRandomPicker<FleetMemberAPI> targets = new WeightedRandomPicker<FleetMemberAPI>();
                for (FleetMemberAPI member2 : fleet.getFleetData().getMembersListCopy()) {
                    float w = 1.0f;
                    switch (member2.getHullSpec().getHullSize()) {
                        case CAPITAL_SHIP: {
                            w = 20.0f;
                            break;
                        }
                        case CRUISER: {
                            w = 10.0f;
                            break;
                        }
                        case DESTROYER: {
                            w = 5.0f;
                            break;
                        }
                        case FRIGATE: {
                            w = 1.0f;
                        }
                    }
                    targets.add(member2, w);
                }
                member2 = (FleetMemberAPI)targets.pick();
                if (member2 != null) {
                    float damageMult = fleet.getCurrBurnLevel() - (float)Misc.getGoSlowBurnLevel(fleet);
                    if (damageMult < 1.0f) {
                        damageMult = 1.0f;
                    }
                    Misc.applyDamage(member2, null, damageMult, true, "asteroid_impact", "\u5c0f\u884c\u661f\u649e\u51fb", true, null, String.valueOf(member2.getShipName()) + " \u56e0\u906d\u53d7\u5c0f\u884c\u661f\u7684\u76f4\u63a5\u649e\u51fb\u800c\u53d7\u5230\u635f\u4f24\u3002");
                } else {
                    dealDamage = false;
                }
            }
            if (!dealDamage && fleet.isPlayerFleet()) {
                Global.getSector().getCampaignUI().addMessage("\u56e0\u906d\u53d7\u5c0f\u884c\u661f\u7684\u649e\u51fb\u800c\u5bfc\u81f4\u822a\u901f\u964d\u4f4e", Misc.getNegativeHighlightColor());
            }
            if ((dist = Misc.getDistance(test = Global.getSector().getPlayerFleet().getLocation(), fleet.getLocation())) < HyperspaceTerrainPlugin.STORM_STRIKE_SOUND_RANGE) {
                float volumeMult = 0.75f;
                if ((volumeMult *= 0.5f + 0.5f * mult) > 0.0f) {
                    if (dealDamage) {
                        Global.getSoundPlayer().playSound("hit_heavy", 1.0f, 1.0f * volumeMult, fleet.getLocation(), Misc.ZERO);
                    } else {
                        Global.getSoundPlayer().playSound("hit_shield_heavy_gun", 1.0f, 1.0f * volumeMult, fleet.getLocation(), Misc.ZERO);
                    }
                }
            }
            float size = 10.0f + (float)Math.random() * 6.0f;
            AsteroidAPI asteroid = fleet.getContainingLocation().addAsteroid(size *= 0.67f);
            asteroid.setFacing((float)Math.random() * 360.0f);
            Vector2f av = Misc.getUnitVectorAtDegreeAngle(angle + 180.0f);
            av.scale(fleet.getVelocity().length() + (20.0f + 20.0f * (float)Math.random()) * mult);
            asteroid.getVelocity().set((ReadableVector2f)av);
            Vector2f al = Misc.getUnitVectorAtDegreeAngle(angle + 180.0f);
            al.scale(fleet.getRadius());
            Vector2f.add((Vector2f)al, (Vector2f)fleet.getLocation(), (Vector2f)al);
            asteroid.setLocation(al.x, al.y);
            float sign = Math.signum(asteroid.getRotation());
            asteroid.setRotation(sign * (50.0f + 50.0f * (float)Math.random()));
            Misc.fadeInOutAndExpire(asteroid, 0.2f, 1.0f + 1.0f * (float)Math.random(), 1.0f);
            Vector2f iv = fleet.getVelocity();
            iv = new Vector2f((ReadableVector2f)iv);
            iv.scale(0.7f);
            float glowSize = 100.0f + 100.0f * mult + 50.0f * (float)Math.random();
            Color color = new Color(255, 165, 100, 255);
            Misc.addHitGlow(fleet.getContainingLocation(), al, iv, glowSize, color);
        }
        this.dV = Misc.getUnitVectorAtDegreeAngle(angle);
        float impact = speed * 1.0f * (0.5f + mult * 0.5f);
        this.dV.scale(impact);
        this.dV.scale(1.0f / DURATION_SECONDS);
    }

    public void advance(float amount) {
        this.fleet.setOrbit(null);
        Vector2f v = this.fleet.getVelocity();
        this.fleet.setVelocity(v.x + this.dV.x * amount, v.y + this.dV.y * amount);
        this.elapsed += amount;
    }

    public boolean isDone() {
        return this.elapsed >= DURATION_SECONDS;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

