/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainPlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.loading.TerrainSpecAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTerrain
implements CampaignTerrainPlugin {
    public static final float EXTRA_SOUND_RADIUS = 100.0f;
    protected SectorEntityToken entity;
    protected String terrainId;
    protected String name = "\u4e0d\u660e";
    private transient TerrainSpecAPI spec = null;
    public static String TERRAIN_LOCK_KEY = "$terrain_mutex_key";

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        this.terrainId = terrainId;
        this.entity = entity;
    }

    @Override
    public String getIconSpriteName() {
        return null;
    }

    public SectorEntityToken getRelatedEntity() {
        return null;
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    @Override
    public String getTerrainId() {
        return this.terrainId;
    }

    protected boolean shouldCheckFleetsToApplyEffect() {
        return true;
    }

    @Override
    public void advance(float amount) {
        CampaignFleetAPI fleet;
        if (amount <= 0.0f) {
            return;
        }
        List<CampaignFleetAPI> fleets = this.entity.getContainingLocation().getFleets();
        if (this.shouldCheckFleetsToApplyEffect()) {
            float renderRange = this.getRenderRange();
            float days = Global.getSector().getClock().convertToDays(amount);
            for (CampaignFleetAPI fleet2 : fleets) {
                float dist;
                if (fleet2.isStationMode() || (dist = Misc.getDistance(fleet2.getLocation(), this.entity.getLocation())) > renderRange) continue;
                String cat = this.getEffectCategory();
                String key = "$terrain_" + cat;
                MemoryAPI mem = fleet2.getMemoryWithoutUpdate();
                if (cat != null && !this.stacksWithSelf() && mem.contains(key) || !this.containsEntity(fleet2)) continue;
                this.applyEffect(fleet2, days);
                if (cat == null) continue;
                mem.set(key, true, 0.0f);
            }
        }
        if ((fleet = Global.getSector().getPlayerFleet()) != null && this.entity.isInCurrentLocation() && this.containsPoint(fleet.getLocation(), fleet.getRadius() + this.getExtraSoundRadius())) {
            float prox;
            float volumeMult = prox = this.getProximitySoundFactor();
            float suppressionMult = prox;
            if (volumeMult > 0.0f) {
                String soundId;
                if (this.shouldPlayLoopOne() && (soundId = this.getSpec().getLoopOne()) != null) {
                    Global.getSector().getCampaignUI().suppressMusic(this.spec.getMusicSuppression() * suppressionMult);
                    Global.getSoundPlayer().playLoop(soundId, fleet, this.getLoopOnePitch(), this.getLoopOneVolume() * volumeMult, fleet.getLocation(), Misc.ZERO);
                }
                if (this.shouldPlayLoopTwo() && (soundId = this.getSpec().getLoopTwo()) != null) {
                    Global.getSector().getCampaignUI().suppressMusic(this.spec.getMusicSuppression() * suppressionMult);
                    Global.getSoundPlayer().playLoop(soundId, fleet, this.getLoopTwoPitch(), this.getLoopTwoVolume() * volumeMult, fleet.getLocation(), Misc.ZERO);
                }
                if (this.shouldPlayLoopThree() && (soundId = this.getSpec().getLoopThree()) != null) {
                    Global.getSector().getCampaignUI().suppressMusic(this.spec.getMusicSuppression() * suppressionMult);
                    Global.getSoundPlayer().playLoop(soundId, fleet, this.getLoopThreePitch(), this.getLoopThreeVolume() * volumeMult, fleet.getLocation(), Misc.ZERO);
                }
                if (this.shouldPlayLoopFour() && (soundId = this.getSpec().getLoopFour()) != null) {
                    Global.getSector().getCampaignUI().suppressMusic(this.spec.getMusicSuppression() * suppressionMult);
                    Global.getSoundPlayer().playLoop(soundId, fleet, this.getLoopFourPitch(), this.getLoopFourVolume() * volumeMult, fleet.getLocation(), Misc.ZERO);
                }
            }
        }
    }

    protected float getExtraSoundRadius() {
        return 100.0f;
    }

    public String getEffectCategory() {
        throw new RuntimeException("Override BaseTerrain.getEffectCategory()");
    }

    @Override
    public boolean containsEntity(SectorEntityToken other) {
        return this.containsPoint(other.getLocation(), other.getRadius()) && !this.isPreventedFromAffecting(other);
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        return false;
    }

    public boolean stacksWithSelf() {
        return false;
    }

    public void applyEffect(SectorEntityToken entity, float days) {
    }

    public float getProximitySoundFactor() {
        return 1.0f;
    }

    public String getModId() {
        return String.valueOf(this.terrainId) + "_stat_mod";
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        throw new RuntimeException("Override BaseTerrain.getActiveLayers() to return the CampaignEngineLayers the terrain should render in.");
    }

    @Override
    public float getRenderRange() {
        throw new RuntimeException("Override BaseTerrain.getRenderRange() to return the maximum distance to render this terrain at (should exceed visible radius).");
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
    }

    @Override
    public void renderOnMap(float factor, float alphaMult) {
    }

    @Override
    public void renderOnMapAbove(float factor, float alphaMult) {
    }

    @Override
    public boolean hasTooltip() {
        return false;
    }

    protected void createFirstSection(TooltipMakerAPI tooltip, boolean expanded) {
    }

    protected void createTravelSection(TooltipMakerAPI tooltip, boolean expanded, float firstPad) {
    }

    protected void createCombatSection(TooltipMakerAPI tooltip, boolean expanded) {
    }

    protected boolean shouldPlayLoopOne() {
        return this.getSpec().getLoopOne() != null;
    }

    protected boolean shouldPlayLoopTwo() {
        return this.getSpec().getLoopTwo() != null;
    }

    protected boolean shouldPlayLoopThree() {
        return this.getSpec().getLoopThree() != null;
    }

    protected boolean shouldPlayLoopFour() {
        return this.getSpec().getLoopFour() != null;
    }

    protected float getLoopOnePitch() {
        return 1.0f;
    }

    protected float getLoopOneVolume() {
        return 1.0f;
    }

    protected float getLoopTwoPitch() {
        return 1.0f;
    }

    protected float getLoopTwoVolume() {
        return 1.0f;
    }

    protected float getLoopThreePitch() {
        return 1.0f;
    }

    protected float getLoopThreeVolume() {
        return 1.0f;
    }

    protected float getLoopFourPitch() {
        return 1.0f;
    }

    protected float getLoopFourVolume() {
        return 1.0f;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        this.createFirstSection(tooltip, expanded);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("\u822a\u884c\u5f71\u54cd", Alignment.MID, pad);
            nextPad = small;
        }
        this.createTravelSection(tooltip, expanded, nextPad);
        if (expanded) {
            tooltip.addSectionHeading("\u6218\u6597\u5f71\u54cd", Alignment.MID, pad);
            this.createCombatSection(tooltip, expanded);
        }
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public String getTerrainName() {
        return this.name;
    }

    @Override
    public String getNameAOrAn() {
        return "a";
    }

    @Override
    public void setTerrainName(String name) {
        this.name = name;
    }

    @Override
    public Color getNameColor() {
        return Global.getSettings().getColor("buttonText");
    }

    @Override
    public boolean hasAIFlag(Object flag) {
        return false;
    }

    @Override
    public boolean hasAIFlag(Object flag, CampaignFleetAPI fleet) {
        return this.hasAIFlag(flag);
    }

    @Override
    public float getMaxEffectRadius(Vector2f locFrom) {
        return 0.0f;
    }

    @Override
    public float getMinEffectRadius(Vector2f locFrom) {
        return 0.0f;
    }

    @Override
    public float getOptimalEffectRadius(Vector2f locFrom) {
        return 0.0f;
    }

    @Override
    public boolean hasMapIcon() {
        return true;
    }

    @Override
    public TerrainSpecAPI getSpec() {
        if (this.spec != null) {
            return this.spec;
        }
        this.spec = Global.getSettings().getTerrainSpec(this.terrainId);
        return this.spec;
    }

    @Override
    public boolean canPlayerHoldStationIn() {
        return true;
    }

    @Override
    public void renderOnRadar(Vector2f radarCenter, float factor, float alphaMult) {
    }

    @Override
    public String getNameForTooltip() {
        return this.getTerrainName();
    }

    public boolean isPreventedFromAffecting(SectorEntityToken other) {
        if (other.getMemoryWithoutUpdate() == null) {
            return false;
        }
        String id = this.entity.getId();
        String key = TERRAIN_LOCK_KEY;
        String lockId = other.getMemoryWithoutUpdate().getString(key);
        return lockId != null && !lockId.equals(id);
    }

    protected void preventOtherTerrainFromAffecting(SectorEntityToken other) {
        this.preventOtherTerrainFromAffecting(other, 0.1f);
    }

    protected void preventOtherTerrainFromAffecting(SectorEntityToken other, float dur) {
        String id = this.entity.getId();
        other.getMemoryWithoutUpdate().set(TERRAIN_LOCK_KEY, id, dur);
    }
}

