/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.combat.BattleCreationPluginImpl;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NebulaTerrainPlugin
extends BaseTiledTerrain
implements BattleCreationPluginImpl.NebulaTextureProvider {
    public static final float TILE_SIZE = 400.0f;
    public static final float VISIBLITY_MULT = 0.5f;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.TERRAIN_2, CampaignEngineLayers.TERRAIN_8);
    private transient CampaignEngineLayers currLayer = null;

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        if (this.name == null || this.name.equals("\u4e0d\u660e")) {
            this.name = "\u661f\u4e91";
        }
    }

    @Override
    public String getNameForTooltip() {
        return "\u661f\u4e91";
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_2, CampaignEngineLayers.TERRAIN_8);
        return this;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public String getNebulaMapTex() {
        return Global.getSettings().getSpriteName(this.params.cat, String.valueOf(this.params.key) + "_map");
    }

    @Override
    public String getNebulaTex() {
        return Global.getSettings().getSpriteName(this.params.cat, this.params.key);
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        this.currLayer = layer;
        super.render(layer, viewport);
    }

    @Override
    public float getTileRenderSize() {
        return 1000.0f;
    }

    @Override
    public float getTileContainsSize() {
        return 600.0f;
    }

    @Override
    public float getTileSize() {
        return 400.0f;
    }

    @Override
    protected void renderSubArea(float startColumn, float endColumn, float startRow, float endRow, float factor, int samples, float alphaMult) {
        super.renderSubArea(startColumn, endColumn, startRow, endRow, factor, samples, alphaMult);
    }

    @Override
    public void preRender(CampaignEngineLayers layer, float alphaMult) {
        GL11.glEnable((int)3042);
        if (this.entity.isInHyperspace()) {
            GL11.glBlendFunc((int)770, (int)771);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        if (layer == CampaignEngineLayers.TERRAIN_8) {
            alphaMult *= 0.2f;
        }
        Color color = this.getRenderColor();
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
    }

    @Override
    public void preMapRender(float alphaMult) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Color color = this.getRenderColor();
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
    }

    @Override
    public Color getRenderColor() {
        return Color.white;
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_1", "\u661f\u4e91\u5185", 0.5f, fleet.getStats().getDetectedRangeMod());
            float penalty = Misc.getBurnMultForTerrain(fleet);
            fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_2", "\u661f\u4e91\u5185", penalty, fleet.getStats().getFleetwideMaxBurnMod());
        }
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        Color text = Misc.getTextColor();
        tooltip.addTitle("\u661f\u4e91");
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("\u822a\u884c\u5f71\u54cd", Alignment.MID, pad);
            nextPad = small;
        }
        tooltip.addPara("\u964d\u4f4e %s \u8230\u961f\u5728\u5176\u5185\u65f6\u53ef\u88ab\u4fa6\u6d4b\u8303\u56f4\u3002", nextPad, highlight, "50%");
        tooltip.addPara("\u964d\u4f4e %s \u8230\u961f\u7684\u822a\u884c\u901f\u5ea6\uff0c\u66f4\u5927\u7684\u8230\u961f\u5c06\u906d\u53d7\u66f4\u4e25\u91cd\u7684\u901f\u5ea6\u60e9\u7f5a\u3002", pad, highlight, (int)(Misc.BURN_PENALTY_MULT * 100.0f) + "%");
        float penalty = Misc.getBurnMultForTerrain(Global.getSector().getPlayerFleet());
        String penaltyStr = Misc.getRoundedValue(1.0f - penalty);
        tooltip.addPara("\u4f60\u7684\u8230\u961f\u901f\u5ea6\u964d\u4f4e\u4e86 %s.", pad, highlight, Math.round((1.0f - penalty) * 100.0f) + "%");
        if (expanded) {
            tooltip.addSectionHeading("\u6218\u6597\u5f71\u54cd", Alignment.MID, pad);
            tooltip.addPara("\u5c3d\u7ba1\u6218\u573a\u4e0a\u4f1a\u5b58\u5728\u5927\u91cf\u661f\u4e91\uff0c\u4f46\u5176\u4ecb\u8d28\u7684\u5bc6\u5ea6\u5374\u4e0d\u8db3\u4ee5\u5f71\u54cd\u8230\u8239\u7684\u6700\u9ad8\u822a\u901f\u3002", small);
        }
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public String getEffectCategory() {
        return "nebula-like";
    }

    @Override
    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.REDUCES_DETECTABILITY || flag == TerrainAIFlags.REDUCES_SPEED_LARGE || flag == TerrainAIFlags.TILE_BASED;
    }
}

