/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.RingRenderer;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class RingSystemTerrainPlugin
extends BaseRingTerrain {
    private static float VISIBLITY_MULT = 0.25f;
    private static float VISIBLITY_MULT_NPC = 0.5f;
    private transient RingRenderer rr;
    private String nameForTooltip = null;

    public static float getVisibilityMult(CampaignFleetAPI fleet) {
        if (fleet != null && fleet.isPlayerFleet()) {
            return VISIBLITY_MULT;
        }
        return VISIBLITY_MULT_NPC;
    }

    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.name = this.params.name;
        if (this.name == null) {
            this.name = "\u884c\u661f\u73af";
        }
    }

    public void renderOnMap(float factor, float alphaMult) {
        if (this.params == null) {
            return;
        }
        if (this.rr == null) {
            this.rr = new RingRenderer("systemMap", "map_ring");
        }
        Color color = Global.getSettings().getColor("ringSystemMapColor");
        if (this.entity.getOrbitFocus() instanceof PlanetAPI) {
            PlanetAPI planetAPI = (PlanetAPI)this.entity.getOrbitFocus();
        }
        boolean spiral = this.params.bandWidthInEngine / 2.0f + 10.0f >= this.params.middleRadius;
        this.rr.render(this.entity.getLocation(), this.params.middleRadius - this.params.bandWidthInEngine * 0.5f, this.params.middleRadius + this.params.bandWidthInEngine * 0.5f, color, spiral, factor, alphaMult);
    }

    public void advance(float amount) {
        super.advance(amount);
    }

    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        super.render(layer, viewport);
    }

    public void applyEffect(SectorEntityToken entity, float days) {
        CampaignFleetAPI fleet;
        if (entity instanceof CampaignFleetAPI && Misc.isSlowMoving(fleet = (CampaignFleetAPI)entity)) {
            fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_1", "\u9690\u85cf\u4e8e \u884c\u661f\u73af\u4e2d", RingSystemTerrainPlugin.getVisibilityMult(fleet), fleet.getStats().getDetectedRangeMod());
        }
    }

    public boolean hasTooltip() {
        return true;
    }

    public String getNameForTooltip() {
        if (this.nameForTooltip == null) {
            return "\u884c\u661f\u73af";
        }
        return this.nameForTooltip;
    }

    public void setNameForTooltip(String nameForTooltip) {
        this.nameForTooltip = nameForTooltip;
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle(this.getNameForTooltip());
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("\u822a\u884c\u5f71\u54cd", Alignment.MID, pad);
            nextPad = small;
        }
        String stop = Global.getSettings().getControlStringForEnumName("GO_SLOW");
        tooltip.addPara("\u964d\u4f4e\u5728\u5176\u4e2d\u9759\u6b62\u6216 \u7f13\u901f\u822a\u884c* \u7684\u8230\u961f%s \u88ab\u4fa6\u6d4b\u5230\u7684\u8303\u56f4\u3002", nextPad, highlight, (int)((1.0f - VISIBLITY_MULT) * 100.0f) + "%");
        tooltip.addPara("* \u6309\u4f4f %s \u505c\u6b62\u822a\u884c\uff0c\u540c\u65f6\u6309\u4f4f\u9f20\u6807\u5de6\u952e\u5219\u6539\u4e3a\u7f13\u901f\u822a\u884c\u3002", nextPad, Misc.getGrayColor(), highlight, stop);
        if (expanded) {
            tooltip.addSectionHeading("\u6218\u6597\u5f71\u54cd", Alignment.MID, pad);
            tooltip.addPara("\u8bb8\u591a\u5c0f\u661f\u4f53\u7ec4\u6210\u7684\u884c\u661f\u73af\u5c06\u4f1a\u51fa\u73b0\u5728\u6218\u573a\u4e0a\u3002\u867d\u7136\u6570\u91cf\u4e0d\u591a\uff0c\u4f46\u4f9d\u7136\u4f1a\u5728\u6218\u6597\u4e2d\u63d0\u9ad8\u822a\u884c\u5371\u9669\u3002", small);
        }
    }

    public boolean isTooltipExpandable() {
        return true;
    }

    public float getTooltipWidth() {
        return 350.0f;
    }

    public String getEffectCategory() {
        return "ringsystem-like";
    }

    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.HIDING_STATIONARY;
    }
}

