/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTerrain;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlipstreamTerrainPlugin
extends BaseTerrain {
    public static final String LOCATION_SLIPSTREAM_KEY = "local_slipstream_terrain";
    public static final float MIN_POINT_DIST = 20.0f;
    public static final float MAX_POINT_DIST = 250.0f;
    public static final float WIDTH_GROWTH_PER_DAY = 200.0f;
    protected Map<SectorEntityToken, Stream> streams = new LinkedHashMap<SectorEntityToken, Stream>();
    protected transient Map<SectorEntityToken, StreamPoint> containsCache = new HashMap<SectorEntityToken, StreamPoint>();
    protected TimeoutTracker<SectorEntityToken> disrupted = new TimeoutTracker();
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);

    public static CampaignTerrainAPI getSlipstream(LocationAPI location) {
        if (location == null) {
            return null;
        }
        return (CampaignTerrainAPI)location.getPersistentData().get(LOCATION_SLIPSTREAM_KEY);
    }

    public static SlipstreamTerrainPlugin getSlipstreamPlugin(LocationAPI location) {
        CampaignTerrainAPI slipstream = SlipstreamTerrainPlugin.getSlipstream(location);
        if (slipstream != null) {
            return (SlipstreamTerrainPlugin)slipstream.getPlugin();
        }
        return null;
    }

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.readResolve();
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
    }

    public TimeoutTracker<SectorEntityToken> getDisrupted() {
        return this.disrupted;
    }

    public void disrupt(CampaignFleetAPI fleet, float dur) {
        this.disrupted.set(fleet, dur);
    }

    private void advancePoints(Stream s, float days) {
        Iterator<StreamPoint> iter2 = s.points.iterator();
        while (iter2.hasNext()) {
            StreamPoint p = iter2.next();
            p.daysLeft -= days;
            p.width += 200.0f * days;
            if (!(p.daysLeft <= 0.0f)) continue;
            iter2.remove();
        }
    }

    protected Stream getStream(SectorEntityToken key) {
        Stream s = this.streams.get(key);
        if (s == null) {
            s = new Stream(key, 50);
            this.streams.put(key, s);
        }
        return s;
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            this.containsPointCaching(fleet, fleet.getLocation(), fleet.getRadius());
            if (this.containsCache.containsKey(fleet)) {
                StreamPoint point = this.containsCache.get(fleet);
                float fleetBurn = fleet.getFleetData().getBurnLevel();
                float cfr_ignored_0 = point.burn;
                float diff = point.burn - fleetBurn;
                if (diff > 2.0f) {
                    diff = 2.0f;
                }
                diff = (int)diff;
                diff = 2.0f;
                fleet.getStats().addTemporaryModFlat(0.1f, this.getModId(), "\u4f4d\u4e8e\u6ed1\u6d41\u5185\u90e8", diff, fleet.getStats().getFleetwideMaxBurnMod());
            }
        }
    }

    @Override
    public boolean containsEntity(SectorEntityToken other) {
        return this.containsPointCaching(other, other.getLocation(), other.getRadius()) && !this.isPreventedFromAffecting(other);
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        return this.containsPointCaching(null, point, radius);
    }

    private boolean containsPointCaching(SectorEntityToken key, Vector2f point, float radius) {
        return key != null && this.containsCache.containsKey(key);
    }

    Object readResolve() {
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);
        if (this.containsCache == null) {
            this.containsCache = new HashMap<SectorEntityToken, StreamPoint>();
        }
        return this;
    }

    Object writeReplace() {
        return this;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public boolean stacksWithSelf() {
        return super.stacksWithSelf();
    }

    @Override
    public float getRenderRange() {
        return Float.MAX_VALUE;
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle(this.getTerrainName());
        tooltip.addPara("\u964d\u4f4e %s \u8230\u961f\u53ef\u88ab\u4fa6\u6d4b\u8303\u56f4\u3002", pad, highlight, "50%");
        tooltip.addPara("\u4e0d\u4e0e\u5176\u4ed6\u540c\u7c7b\u5730\u5f62\u6548\u679c\u53e0\u52a0\u3002", pad);
    }

    @Override
    public boolean isTooltipExpandable() {
        return false;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public String getTerrainName() {
        return "\u6ed1\u6d41";
    }

    @Override
    public String getNameForTooltip() {
        return "\u6ed1\u6d41";
    }

    @Override
    public String getEffectCategory() {
        return "slipstream";
    }

    public static class Stream {
        public transient float minX;
        public transient float minY;
        public transient float maxX;
        public transient float maxY;
        public List<StreamPoint> points = new ArrayList<StreamPoint>();
        public SectorEntityToken key;
        public int particlesPerPoint;

        public Stream(SectorEntityToken key, int particlesPerPoint) {
            this.key = key;
            this.particlesPerPoint = particlesPerPoint;
            this.readResolve();
        }

        Object readResolve() {
            this.minX = Float.MAX_VALUE;
            this.minY = Float.MAX_VALUE;
            this.maxX = -3.4028235E38f;
            this.maxY = -3.4028235E38f;
            for (StreamPoint p : this.points) {
                this.updateMinMax(p);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.points.isEmpty();
        }

        public StreamPoint getLastPoint() {
            if (this.isEmpty()) {
                return null;
            }
            return this.points.get(this.points.size() - 1);
        }

        public StreamPoint getFirstPoint() {
            if (this.isEmpty()) {
                return null;
            }
            return this.points.get(0);
        }

        private void updateMinMax(StreamPoint p) {
            if (p.x < this.minX) {
                this.minX = p.x;
            }
            if (p.y < this.minY) {
                this.minY = p.y;
            }
            if (p.x > this.maxX) {
                this.maxX = p.x;
            }
            if (p.y > this.maxY) {
                this.maxY = p.y;
            }
        }

        public void addPoint(StreamPoint p) {
            this.updateMinMax(p);
            this.points.add(p);
        }

        public boolean isNearViewport(ViewportAPI v, float pad) {
            float x = v.getLLX();
            float y = v.getLLY();
            float w = v.getVisibleWidth();
            float h = v.getVisibleHeight();
            if (this.minX > x + w + pad) {
                return false;
            }
            if (this.minY > y + h + pad) {
                return false;
            }
            if (this.maxX < x - pad) {
                return false;
            }
            return !(this.maxY < y - pad);
        }

        public boolean couldContainLocation(Vector2f loc, float radius) {
            if (this.minX > loc.x + radius) {
                return false;
            }
            if (this.minY > loc.y + radius) {
                return false;
            }
            if (this.maxX < loc.x - radius) {
                return false;
            }
            return !(this.maxY < loc.y - radius);
        }
    }

    public static class StreamPoint {
        public float x;
        public float y;
        public float daysLeft;
        public float burn;
        public float width;

        public StreamPoint(float x, float y, float daysLeft, float burn, float width) {
            this.x = x;
            this.y = y;
            this.daysLeft = daysLeft;
            this.burn = burn;
            this.width = width;
        }
    }
}

