/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class StarCoronaAkaMainyuTerrainPlugin
extends StarCoronaTerrainPlugin {
    public static final float ARC = 100.0f;

    public float getAuroraAlphaMultForAngle(float angle) {
        SectorEntityToken star = this.params.relatedEntity.getLightSource();
        if (star != null) {
            float max;
            float toStar = Misc.getAngleInDegrees(this.params.relatedEntity.getLocation(), star.getLocation());
            float diff = Misc.getAngleDiff(toStar, angle);
            if (diff < (max = 50.0f)) {
                return Math.max(0.0f, 1.0f - diff / max);
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public Color getAuroraColorForAngle(float angle) {
        if (this.color == null) {
            this.color = this.params.relatedEntity instanceof PlanetAPI ? ((PlanetAPI)this.params.relatedEntity).getSpec().getAtmosphereColor() : Color.white;
            this.color = Misc.setAlpha(this.color, 155);
        }
        if (this.flareManager.isInActiveFlareArc(angle)) {
            return this.flareManager.getColorForAngle(this.color, angle);
        }
        return super.getAuroraColorForAngle(angle);
    }

    public boolean containsPoint(Vector2f point, float radius) {
        float toStar;
        SectorEntityToken star = this.params.relatedEntity.getLightSource();
        if (star != null && !Misc.isInArc(toStar = Misc.getAngleInDegrees(this.params.relatedEntity.getLocation(), star.getLocation()), 100.0f, this.params.relatedEntity.getLocation(), point)) {
            return false;
        }
        return super.containsPoint(point, radius);
    }

    public String getTerrainName() {
        return "\u79bb\u5b50\u98ce\u66b4";
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        tooltip.addTitle("\u79bb\u5b50\u98ce\u66b4");
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("\u822a\u884c\u5f71\u54cd", Alignment.MID, small);
            nextPad = small;
        }
        tooltip.addPara("\u5f3a\u70c8\u7684\u70ed\u8f90\u5c04\u5728\u9010\u6e10\u964d\u4f4e\u6240\u6709\u8230\u8239\u7684\u6218\u5907\u503c (CR)\u3002", nextPad);
        tooltip.addPara("\u4ece\u5927\u6c14\u4e2d\u55b7\u51fa\u7684\u7535\u79bb\u5b50\u6c14\u4f53\u4f7f\u884c\u661f\u96be\u4ee5\u63a5\u8fd1\u3002", pad);
        if (expanded) {
            tooltip.addSectionHeading("\u6218\u6597\u5f71\u54cd", Alignment.MID, pad);
            tooltip.addPara("\u964d\u4f4e\u8230\u8239\u7684\u5cf0\u503c\u65f6\u95f4\uff0c\u5e76\u52a0\u901f\u6d88\u8017\u53c2\u6218\u8230\u8239\u7684\u6218\u5907\u503c (CR)\u3002", small);
        }
    }
}

