/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class GalatianAcademyStipend
implements EconomyTickListener,
TooltipMakerAPI.TooltipCreator {
    public static float DURATION = 1115.0f;
    public static int STIPEND = 15000;
    protected long startTime = 0L;

    public GalatianAcademyStipend() {
        Global.getSector().getListenerManager().addListener(this);
        this.startTime = Global.getSector().getClock().getTimestamp();
        Global.getSector().getMemoryWithoutUpdate().set("$playerReceivingGAStipend", true);
    }

    public void reportEconomyTick(int iterIndex) {
        if (!Global.getSettings().getBoolean("enableStipend")) {
            return;
        }
        int lastIterInMonth = (int)Global.getSettings().getFloat("economyIterPerMonth") - 1;
        if (iterIndex != lastIterInMonth) {
            return;
        }
        float daysActive = Global.getSector().getClock().getElapsedDaysSince(this.startTime);
        MarketAPI ancyra = Global.getSector().getEconomy().getMarket("ancyra_market");
        if (daysActive > DURATION || ancyra == null) {
            Global.getSector().getListenerManager().removeListener(this);
            Global.getSector().getMemoryWithoutUpdate().unset("$playerReceivingGAStipend");
            return;
        }
        MonthlyReport report = SharedData.getData().getCurrentReport();
        int stipend = this.getStipend();
        MonthlyReport.FDNode fleetNode = report.getNode(MonthlyReport.FLEET);
        MonthlyReport.FDNode stipendNode = report.getNode(fleetNode, "GA_stipend");
        stipendNode.income = stipend;
        stipendNode.name = "\u6765\u81ea Galatian \u5b66\u9662\u7684\u8865\u52a9\u6d25\u8d34";
        stipendNode.icon = Global.getSettings().getSpriteName("income_report", "generic_income");
        stipendNode.tooltipCreator = this;
    }

    protected int getStipend() {
        return STIPEND;
    }

    public void reportEconomyMonthEnd() {
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
        float daysActive = Global.getSector().getClock().getElapsedDaysSince(this.startTime);
        tooltip.addPara("Galatian \u5b66\u9662\u5c06\u6bcf\u6708\u7ed9\u4f60 %s \u7684\u8865\u52a9\u6d25\u8d34\uff0c\u6765\u611f\u8c22\u4f60\u6700\u8fd1\u63d0\u4f9b\u7684\u5e2e\u52a9\u3002", 0.0f, Misc.getHighlightColor(), Misc.getDGSCredits(this.getStipend()));
        float rem = DURATION - daysActive;
        int months = (int)(rem / 30.0f);
        if (months > 0) {
            tooltip.addPara("\u4f60\u8fd8\u80fd\u7ee7\u7eed\u9886\u53d6 %s \u4e2a\u6708\u7684\u8865\u52a9\u6d25\u8d34\u3002", 10.0f, Misc.getHighlightColor(), "" + months);
        } else if (months <= 0) {
            tooltip.addPara("\u8865\u52a9\u6d25\u8d34\u5df2\u7ecf\u53d1\u653e\u5b8c\u6bd5\u3002", 10.0f);
        }
    }

    public float getTooltipWidth(Object tooltipParam) {
        return 450.0f;
    }

    public boolean isTooltipExpandable(Object tooltipParam) {
        return false;
    }
}

