/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CommDirectoryEntryAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.SourceBasedFleetManager;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;

public class RogueMinerMiscFleetManager
extends SourceBasedFleetManager {
    protected float daysRemaining = 40.0f;

    public RogueMinerMiscFleetManager(SectorEntityToken source) {
        super(source, 3.0f, 0, 5, 5.0f);
    }

    public void advance(float amount) {
        super.advance(amount);
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysRemaining -= days;
        if (this.daysRemaining <= 0.0f && this.source != null) {
            if (this.source.getMarket() != null && this.source.getMarket().isInEconomy()) {
                this.source.setFaction("independent");
                this.source.getMarket().setFactionId("independent");
                if (this.source.getMarket().getCommDirectory() != null && this.source.getMarket().getCommDirectory().getEntriesCopy() != null) {
                    for (CommDirectoryEntryAPI entry : this.source.getMarket().getCommDirectory().getEntriesCopy()) {
                        if (entry.getType() != CommDirectoryEntryAPI.EntryType.PERSON || !(entry.getEntryData() instanceof PersonAPI)) continue;
                        PersonAPI p = (PersonAPI)entry.getEntryData();
                        p.setFaction("independent");
                    }
                }
                FactionAPI ind = Global.getSector().getFaction("independent");
                if (this.source.getMarket() != null && this.source.getMarket().getSubmarket("open_market") != null) {
                    this.source.getMarket().getSubmarket("open_market").setFaction(ind);
                }
            }
            this.setDone(true);
        }
    }

    protected CampaignFleetAPI spawnFleet() {
        MarketAPI market2;
        if (this.source == null) {
            return null;
        }
        CampaignFleetAPI fleet = RogueMinerMiscFleetManager.createEmptyRogueFleet("\u6d41\u6c13\u77ff\u5de5\u7684\u90e8\u961f", false);
        WeightedRandomPicker<String> picker1 = new WeightedRandomPicker<String>();
        picker1.add("cerberus_d_Standard");
        picker1.add("hound_d_Standard");
        picker1.add("kite_pirates_Raider");
        WeightedRandomPicker<String> picker2 = new WeightedRandomPicker<String>();
        picker2.add("hammerhead_d_CS");
        picker2.add("enforcer_d_Strike");
        picker2.add("sunder_d_Assault");
        picker2.add("buffalo2_FS");
        picker2.add("condor_Support");
        picker2.add("condor_Attack");
        fleet.getFleetData().addFleetMember((String)picker1.pick());
        fleet.getFleetData().addFleetMember((String)picker1.pick());
        if ((float)Math.random() > 0.5f) {
            fleet.getFleetData().addFleetMember((String)picker1.pick());
        }
        fleet.getFleetData().addFleetMember((String)picker2.pick());
        if ((float)Math.random() > 0.5f) {
            fleet.getFleetData().addFleetMember((String)picker2.pick());
        }
        fleet.getFleetData().sort();
        LocationAPI location = this.source.getContainingLocation();
        location.addEntity(fleet);
        fleet.setLocation(this.source.getLocation().x, this.source.getLocation().y);
        WeightedRandomPicker<MarketAPI> marketPicker = new WeightedRandomPicker<MarketAPI>();
        for (MarketAPI market2 : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market2 == this.source || market2.isHidden() || !"pirates".equals(market2.getFactionId())) continue;
            float dist = Misc.getDistance(this.source.getLocationInHyperspace(), market2.getLocationInHyperspace());
            float w = Math.max(1000.0f, 50000.0f - dist);
            marketPicker.add(market2, w);
        }
        market2 = (MarketAPI)marketPicker.pick();
        if (market2 != null) {
            fleet.addAssignment(FleetAssignment.RAID_SYSTEM, ((StarSystemAPI)this.source.getContainingLocation()).getCenter(), 40.0f);
            Misc.giveStandardReturnAssignments(fleet, market2.getPrimaryEntity(), "\u6b63\u5728\u524d\u5f80", false);
        } else {
            fleet.addAssignment(FleetAssignment.RAID_SYSTEM, ((StarSystemAPI)this.source.getContainingLocation()).getCenter(), 100.0f);
            Misc.giveStandardReturnToSourceAssignments(fleet, false);
        }
        return fleet;
    }

    public static CampaignFleetAPI createEmptyRogueFleet(String name, boolean withFaction) {
        CampaignFleetAPI fleet = FleetFactoryV3.createEmptyFleet("pirates", "mercScout", null);
        fleet.setName(name);
        fleet.setNoFactionInName(!withFaction);
        fleet.removeAbility("interdiction_pulse");
        fleet.getStats().getFleetwideMaxBurnMod().modifyMult("tutorial", 0.6f);
        fleet.getMemoryWithoutUpdate().set("$isPirate", true);
        fleet.getMemoryWithoutUpdate().set("$cfai_noJump", true);
        fleet.getMemoryWithoutUpdate().set("$rogueMiner", true);
        fleet.getMemoryWithoutUpdate().set("$core_fleetNoMilitaryResponse", true);
        return fleet;
    }

    public static CampaignFleetAPI createGuardFleet(boolean stronger) {
        CampaignFleetAPI fleet = RogueMinerMiscFleetManager.createEmptyRogueFleet("\u6d41\u6c13\u77ff\u5de5\u7684\u90e8\u961f", false);
        WeightedRandomPicker<String> picker1 = new WeightedRandomPicker<String>();
        picker1.add("cerberus_d_Standard");
        picker1.add("hound_d_Standard");
        picker1.add("kite_pirates_Raider");
        picker1.add("shepherd_Frontier");
        WeightedRandomPicker<String> picker2 = new WeightedRandomPicker<String>();
        picker2.add("hammerhead_d_CS");
        picker2.add("enforcer_d_Strike");
        picker2.add("sunder_d_Assault");
        picker2.add("buffalo2_FS");
        fleet.getFleetData().addFleetMember((String)picker1.pick());
        if (stronger) {
            fleet.getFleetData().addFleetMember((String)picker1.pick());
        }
        if ((float)Math.random() > 0.5f) {
            fleet.getFleetData().addFleetMember((String)picker1.pick());
        }
        fleet.getFleetData().addFleetMember((String)picker2.pick());
        fleet.getFleetData().sort();
        return fleet;
    }
}

