/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class SpacerObligation
implements EconomyTickListener,
TooltipMakerAPI.TooltipCreator {
    public static int DEBT_BASE = 1000;
    public static int DEBT_PER_LEVEL = 3000;
    protected long startTime = 0L;

    public SpacerObligation() {
        Global.getSector().getListenerManager().addListener(this);
        this.startTime = Global.getSector().getClock().getTimestamp();
    }

    public void reportEconomyTick(int iterIndex) {
        int lastIterInMonth = (int)Global.getSettings().getFloat("economyIterPerMonth") - 1;
        if (iterIndex != lastIterInMonth) {
            return;
        }
        MonthlyReport report = SharedData.getData().getCurrentReport();
        int debt = this.getDebt();
        MonthlyReport.FDNode fleetNode = report.getNode(MonthlyReport.FLEET);
        MonthlyReport.FDNode stipendNode = report.getNode(fleetNode, "SpacerObligation");
        stipendNode.upkeep = debt;
        stipendNode.name = "\u4e3a\u4f60\u66fe\u72af\u4e0b\u7684\u9519\u8bef\u4e70\u5355";
        stipendNode.icon = Global.getSettings().getSpriteName("income_report", "generic_expense");
        stipendNode.tooltipCreator = this;
    }

    protected int getDebt() {
        return DEBT_BASE + (Global.getSector().getPlayerStats().getLevel() - 1) * DEBT_PER_LEVEL;
    }

    public void reportEconomyMonthEnd() {
    }

    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
        tooltip.addPara("\u4f60\u4ece\u4e0d\u5411\u4ed6\u4eba\u63d0\u53ca\u6b64\u4e8b\u3002", 0.0f, Misc.getHighlightColor(), Misc.getDGSCredits(this.getDebt()));
    }

    public float getTooltipWidth(Object tooltipParam) {
        return 450.0f;
    }

    public boolean isTooltipExpandable(Object tooltipParam) {
        return false;
    }
}

