/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialLayInCourseDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected MarketAPI ancyra;
    protected PersonAPI contact;

    public TutorialLayInCourseDialogPluginImpl(MarketAPI ancyra, PersonAPI contact) {
        this.ancyra = ancyra;
        this.contact = contact;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showFleetInfo("\u4f60\u7684\u8230\u961f", this.playerFleet, null, null);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        String name = this.ancyra.getName();
        String personName = String.valueOf(this.contact.getPost().toLowerCase()) + " " + this.contact.getName().getLast();
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph("\u51fb\u8d25\u6d77\u76d7\u540e\uff0c\u4f60\u5c31\u6536\u5230\u4e86\u4e00\u5219\u7d27\u6025\u901a\u4fe1\uff0c\u8be5\u6d88\u606f\u6765\u6e90\u4e8e " + name + "\u3002");
                this.textPanel.addParagraph("\u6d88\u606f\u5f88\u7b80\u5355\uff0c\u8981\u6c42\u4f60\u5c3d\u5feb\u524d\u5f80\u90a3\u91cc\u5e76\u8054\u7cfb " + personName + " \u3002");
                this.options.clearOptions();
                this.options.addOption("\u7ee7\u7eed", (Object)OptionId.CONT1, null);
                break;
            }
            case CONT1: {
                this.textPanel.addParagraph("\u73b0\u5728\u8ba9\u6211\u4eec\u542f\u52a8\u81ea\u52a8\u5bfc\u822a\u7cfb\u7edf\u6765\u524d\u5f80 " + name + "\u3002\u5c3d\u7ba1\u4f60\u4e0d\u4e00\u5b9a\u9700\u8981\u8fd9\u4e48\u505a\uff0c" + "\u4f46\u5b83\u6709\u52a9\u4e8e\u8ddf\u8e2a\u4f60\u8981\u53bb\u7684\u5730\u65b9\uff0c\u4ee5\u53ca\u4e86\u89e3\u5230\u8fbe\u90a3\u91cc\u9700\u8981\u591a\u957f\u65f6\u95f4\u3002");
                String intel = Global.getSettings().getControlStringForEnumName("CORE_INTEL");
                this.textPanel.addPara("\u9000\u51fa\u6b64\u5bf9\u8bdd\u6846\u540e\uff0c\u6309 %s \u6253\u5f00\u60c5\u62a5\u4fe1\u606f\u9762\u677f\u67e5\u770b\u521a\u6536\u5230\u7684\u6d88\u606f\u4e0e\u8be6\u7ec6\u5185\u5bb9\u3002", Misc.getHighlightColor(), intel);
                this.textPanel.addPara("\u9009\u62e9\u6d88\u606f\u5e76\u6309 %s \u952e\u4ee5\u6253\u5f00\u5730\u56fe\uff0c\u5c4f\u5e55\u5e94\u5df2\u805a\u7126\u5728 Ancyra \u4e0a\u3002\u7136\u540e\u5de6\u952e\u70b9\u51fb\u884c\u661f\u5e76\u6309\u4f4f\u4e0d\u653e\uff0c\u5728\u8df3\u51fa\u7684\u83dc\u5355\u4e0a\u9009\u62e9 %s}\u3002\u6216\u8005\u4f60\u53ef\u4ee5\u76f4\u63a5\u53f3\u952e\u70b9\u51fb Ancyra\u3002", Misc.getHighlightColor(), "\"\u5728\u5730\u56fe\u4e0a\u663e\u793a\"", "\"\u81ea\u52a8\u5bfc\u822a\"");
                this.options.clearOptions();
                this.options.addOption("\u7ee7\u7eed", (Object)OptionId.CONT2, null);
                break;
            }
            case CONT2: {
                String map = Global.getSettings().getControlStringForEnumName("CORE_MAP");
                this.textPanel.addPara("\u4f60\u4e5f\u53ef\u4ee5\u6309 %s \u6253\u5f00\u5730\u56fe\u627e\u5230 Ancyra \u540e\uff0c\u624b\u52a8\u822a\u884c\u524d\u5f80\u3002", Misc.getHighlightColor(), map);
                this.textPanel.addParagraph("\u4e00\u65e6\u4f60\u5230\u8fbe\u4e86 Ancyra\uff0c\u6253\u5f00\u901a\u8baf\u76ee\u5f55\u5e76\u8054\u7cfb " + personName + "\u3002");
                this.options.clearOptions();
                this.options.addOption("\u5b8c\u6210", (Object)OptionId.CONT3, null);
                break;
            }
            case CONT3: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        CONT1,
        CONT2,
        CONT3;

    }
}

