/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CommDirectoryEntryAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyIntel;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.submarkets.StoragePlugin;
import com.fs.starfarer.api.impl.campaign.tutorial.GalatianAcademyStipend;
import com.fs.starfarer.api.impl.campaign.tutorial.RogueMinerMiscFleetManager;
import com.fs.starfarer.api.impl.campaign.tutorial.SaveNagScript;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialLeashAssignmentAI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.ui.HintPanelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialMissionIntel
extends BaseIntelPlugin
implements EveryFrameScript {
    public static final String TUT_STAGE = "$tutStage";
    public static final String REASON = "tut";
    protected float elapsedDays = 0.0f;
    protected StarSystemAPI system;
    protected PlanetAPI ancyra;
    protected PlanetAPI pontus;
    protected PlanetAPI tetra;
    protected SectorEntityToken derinkuyu;
    protected SectorEntityToken probe;
    protected SectorEntityToken inner;
    protected SectorEntityToken fringe;
    protected SectorEntityToken detachment;
    protected SectorEntityToken relay;
    protected PersonAPI mainContact;
    protected PersonAPI dataContact;
    protected PersonAPI jangalaContact;
    protected PlanetAPI jangala;
    protected FactionAPI faction;
    protected TutorialMissionStage stage = TutorialMissionStage.INIT;
    protected int preRecoverFleetSize = 2;

    public static boolean isTutorialInProgress() {
        return Global.getSector().getMemoryWithoutUpdate().contains("$tutorialRespawn");
    }

    public TutorialMissionIntel() {
        this.faction = Global.getSector().getFaction("hegemony");
        this.system = Global.getSector().getStarSystem("galatia");
        this.ancyra = (PlanetAPI)this.system.getEntityById("ancyra");
        this.pontus = (PlanetAPI)this.system.getEntityById("pontus");
        this.tetra = (PlanetAPI)this.system.getEntityById("tetra");
        this.derinkuyu = this.system.getEntityById("derinkuyu_station");
        this.probe = this.system.getEntityById("galatia_probe");
        this.inner = this.system.getEntityById("galatia_jump_point_alpha");
        this.fringe = this.system.getEntityById("galatia_jump_point_fringe");
        this.detachment = this.system.getEntityById("tutorial_security_detachment");
        this.relay = this.system.getEntityById("ancyra_relay");
        this.mainContact = TutorialMissionIntel.createMainContact(this.ancyra);
        this.dataContact = Global.getSector().getFaction("independent").createRandomPerson();
        this.dataContact.setRankId(Ranks.AGENT);
        this.dataContact.setPostId(Ranks.POST_AGENT);
        this.derinkuyu.getMarket().getCommDirectory().addPerson(this.dataContact);
        this.mainContact.getMemoryWithoutUpdate().set("$tut_mainContact", true);
        this.mainContact.getMemoryWithoutUpdate().set("$tut_eventRef", this);
        Misc.makeImportant(this.mainContact, REASON);
        Global.getSector().getMemoryWithoutUpdate().set("$tut_jangalaContactName", this.mainContact.getNameString());
        this.updateStage(TutorialMissionStage.INIT, null);
        this.setImportant(true);
        Global.getSector().getIntelManager().addIntel(this);
        Global.getSector().addScript(this);
    }

    public static PersonAPI createMainContact(PlanetAPI ancyra) {
        PersonAPI mainContact = ancyra.getFaction().createRandomPerson();
        mainContact.setRankId(Ranks.CITIZEN);
        mainContact.setPostId(Ranks.POST_STATION_COMMANDER);
        ancyra.getMarket().getCommDirectory().addPerson(mainContact);
        ancyra.getMarket().addPerson(mainContact);
        return mainContact;
    }

    public static PersonAPI getJangalaContact() {
        StarSystemAPI corvus = Global.getSector().getStarSystem("Corvus");
        PlanetAPI jangala = (PlanetAPI)corvus.getEntityById("jangala");
        for (CommDirectoryEntryAPI entry : jangala.getMarket().getCommDirectory().getEntriesCopy()) {
            PersonAPI curr;
            if (entry.getType() != CommDirectoryEntryAPI.EntryType.PERSON || !(entry.getEntryData() instanceof PersonAPI) || !Ranks.POST_STATION_COMMANDER.equals((curr = (PersonAPI)entry.getEntryData()).getPostId())) continue;
            return curr;
        }
        return null;
    }

    public PersonAPI getMainContact() {
        return this.mainContact;
    }

    protected void updateStage(TutorialMissionStage stage, TextPanelAPI text) {
        this.stage = stage;
        Global.getSector().getMemoryWithoutUpdate().set(TUT_STAGE, stage.name());
        if (stage != TutorialMissionStage.INIT) {
            this.sendUpdateIfPlayerHasIntel((Object)stage, text);
        }
    }

    protected void endEvent() {
        this.endAfterDelay();
        Global.getSector().getMemoryWithoutUpdate().unset(TUT_STAGE);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    @Override
    protected void advanceImpl(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return;
        }
        this.elapsedDays += days;
        if (this.probe == null) {
            this.probe = this.system.getEntityById("galatia_probe");
        }
        if (this.tetra == null) {
            this.tetra = (PlanetAPI)this.system.getEntityById("tetra");
        }
        if (this.derinkuyu == null) {
            this.derinkuyu = this.system.getEntityById("derinkuyu_station");
        }
        if (this.inner == null) {
            this.inner = this.system.getEntityById("galatia_jump_point_alpha");
        }
        if (this.fringe == null) {
            this.fringe = this.system.getEntityById("galatia_jump_point_fringe");
        }
        if (this.detachment == null) {
            this.detachment = this.system.getEntityById("tutorial_security_detachment");
        }
        if (this.stage == TutorialMissionStage.GO_GET_AI_CORE) {
            int cores = (int)player.getCargo().getCommodityQuantity("gamma_core");
            float distToProbe = Misc.getDistance(player.getLocation(), this.probe.getLocation());
            if (cores > 0 && (!this.probe.isAlive() || distToProbe < 300.0f)) {
                Misc.makeImportant(this.mainContact, REASON);
                this.updateStage(TutorialMissionStage.GOT_AI_CORE, null);
            }
        }
        if (this.stage == TutorialMissionStage.GO_RECOVER_SHIPS) {
            int count = 0;
            for (FleetMemberAPI member : player.getFleetData().getMembersListCopy()) {
                ++count;
            }
            int wrecks = 0;
            for (SectorEntityToken entity : this.system.getEntitiesWithTag("salvageable")) {
                String id = entity.getCustomEntityType();
                if (id == null || !"wreck".equals(id)) continue;
                ++wrecks;
            }
            if (count >= this.preRecoverFleetSize + 2 || wrecks < 3) {
                Misc.makeImportant(this.mainContact, REASON);
                Misc.makeUnimportant(this.tetra, REASON);
                this.updateStage(TutorialMissionStage.RECOVERED_SHIPS, null);
            }
        }
        if (this.stage == TutorialMissionStage.GO_STABILIZE) {
            boolean fringeStable;
            boolean innerStable = this.inner.getMemoryWithoutUpdate().getExpire("$unstable") > 0.0f;
            boolean bl = fringeStable = this.fringe.getMemoryWithoutUpdate().getExpire("$unstable") > 0.0f;
            if (innerStable || fringeStable) {
                Misc.makeImportant(this.mainContact, REASON);
                Misc.makeUnimportant(this.inner, REASON);
                this.updateStage(TutorialMissionStage.STABILIZED, null);
            }
        }
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        if (action.equals("startGetData")) {
            this.dataContact.getMemoryWithoutUpdate().set("$tut_dataContact", true);
            this.dataContact.getMemoryWithoutUpdate().set("$tut_eventRef", this);
            Misc.makeImportant(this.dataContact, REASON);
            Misc.makeUnimportant(this.mainContact, REASON);
            this.detachment.getMemoryWithoutUpdate().set("$patrolAllowTOff", true);
            this.updateStage(TutorialMissionStage.GO_GET_DATA, text);
            Global.getSector().getMemoryWithoutUpdate().set("$tutMadeContactAtAncyra", true);
            this.saveNag();
        } else if (action.equals("endGetData")) {
            Misc.cleanUpMissionMemory(this.dataContact.getMemoryWithoutUpdate(), "tut_");
            Misc.makeUnimportant(this.dataContact, REASON);
            Misc.makeImportant(this.mainContact, REASON);
            this.updateStage(TutorialMissionStage.GOT_DATA, text);
        } else if (action.equals("goSalvage")) {
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.makeImportant(this.probe, REASON);
            this.updateStage(TutorialMissionStage.GO_GET_AI_CORE, text);
            this.saveNag();
        } else if (action.equals("goRecover")) {
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.makeImportant(this.tetra, REASON);
            FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "mudskipper_Standard");
            playerFleet.getFleetData().addFleetMember(member);
            AddRemoveCommodity.addFleetMemberGainText(member, dialog.getTextPanel());
            this.preRecoverFleetSize = playerFleet.getFleetData().getNumMembers();
            this.updateStage(TutorialMissionStage.GO_RECOVER_SHIPS, text);
        } else if (action.equals("goStabilize")) {
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.makeImportant(this.inner, REASON);
            this.addWeaponsToStorage();
            this.inner.getMemoryWithoutUpdate().set("$canStabilize", true);
            this.fringe.getMemoryWithoutUpdate().set("$canStabilize", true);
            this.updateStage(TutorialMissionStage.GO_STABILIZE, text);
            this.saveNag();
        } else if (action.equals("pickJangalaContact")) {
            StarSystemAPI corvus = Global.getSector().getStarSystem("Corvus");
            this.jangala = (PlanetAPI)corvus.getEntityById("jangala");
            this.jangalaContact = TutorialMissionIntel.getJangalaContact();
            MemoryAPI mem = this.mainContact.getMemoryWithoutUpdate();
            mem.set("$jangalaContactPost", this.jangalaContact.getPost().toLowerCase(), 0.0f);
            mem.set("$jangalaContactLastName", this.jangalaContact.getName().getLast(), 0.0f);
            float distLY = Misc.getDistanceLY(playerFleet.getLocationInHyperspace(), this.jangala.getLocationInHyperspace());
            float fuel = playerFleet.getLogistics().getFuelCostPerLightYear() * (distLY += 4.0f);
            fuel = (float)(Math.ceil(fuel / 10.0f) * 10.0);
            mem.set("$jangalaFuel", (int)fuel);
        } else if (action.equals("deliverReport")) {
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.cleanUpMissionMemory(this.mainContact.getMemoryWithoutUpdate(), "tut_");
            Misc.makeUnimportant(this.inner, REASON);
            this.jangalaContact.getMemoryWithoutUpdate().set("$tut_jangalaContact", true);
            this.jangalaContact.getMemoryWithoutUpdate().set("$tut_eventRef", this);
            Misc.makeImportant(this.jangalaContact, REASON);
            this.updateStage(TutorialMissionStage.DELIVER_REPORT, text);
            TutorialMissionIntel.endGalatiaPortionOfMission(true, true);
            Global.getSector().getMemoryWithoutUpdate().unset("$tutorialRespawn");
        } else if (action.equals("reportDelivered")) {
            Misc.makeUnimportant(this.jangalaContact, REASON);
            Misc.cleanUpMissionMemory(this.jangalaContact.getMemoryWithoutUpdate(), "tut_");
            this.updateStage(TutorialMissionStage.DONE, text);
            MarketAPI jangala = Global.getSector().getEconomy().getMarket("jangala");
            if (jangala != null) {
                SystemBountyManager.getInstance().addOrResetBounty(jangala);
            }
            this.endEvent();
        } else if (action.equals("doRepairs")) {
            for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
                member.getRepairTracker().setMothballed(false);
                member.getStatus().repairFully();
                float max = member.getRepairTracker().getMaxCR();
                max = Math.max(max, 0.7f);
                float curr = member.getRepairTracker().getBaseCR();
                if (!(max > curr)) continue;
                member.getRepairTracker().applyCREvent(max - curr, "\u5728\u8239\u575e\u4fee\u7406");
            }
        } else if (action.equals("printRefitHint")) {
            String refit = Global.getSettings().getControlStringForEnumName("CORE_REFIT");
            String autofit = Global.getSettings().getControlStringForEnumName("REFIT_MANAGE_VARIANTS");
            String transponder = "";
            if (!playerFleet.isTransponderOn()) {
                transponder = "\n\n\u6b64\u5916\uff1a\u60a8\u9700\u8981\u91cd\u65b0\u5f00\u542f\u5e94\u7b54\u5668\u4ee5\u4fbf\u4f7f\u7528 Ancyra \u7684\u8bbe\u65bd\u3002";
            }
            dialog.getTextPanel().addPara("(\u5f53\u672c\u5bf9\u8bdd\u7ed3\u675f\u540e\uff0c\u6309 %s \u6765\u5f00\u542f\u88c5\u914d\u9875\u9762\u3002\u9009\u62e9\u4e00\u8258\u8230\u8239\u540e\uff0c\u4f60\u53ef\u4ee5\u6309 %s \u548c %s \u2014\u2014 \u6765\u9009\u62e9\u4f60\u60f3\u8981\u7684\u88c5\u914d\u65b9\u6848\u3002\u8230\u8239\u4f1a\u81ea\u52a8\u4f7f\u7528\u53ef\u7528\u7684\u6b66\u5668\u6765\u5c3d\u91cf\u6ee1\u8db3\u4f60\u9009\u62e9\u7684\u88c5\u914d\u65b9\u6848\u3002" + transponder, Misc.getHighlightColor(), refit, autofit, "\"\u81ea\u52a8\u88c5\u914d\"");
            dialog.getTextPanel().addPara("\u9664\u6b64\u4e4b\u5916\uff0c\u4f60\u73b0\u5728\u53ef\u4ee5\u4f7f\u7528 Ancyra \u5f53\u5730\u7684\u4ed3\u5e93\uff0c\u5e76\u4e14\u91cc\u9762\u5df2\u7ecf\u5b58\u653e\u4e86\u4e00\u4e9b\u6b66\u5668\u548c\u8865\u7ed9\u3002\u4f60\u53ef\u4ee5\u70b9\u9009 \u70b9\u9009\u4ea4\u6613\u9875\u9762\u7684 \u4ed3\u5e93 \u6309\u94ae\u6765\u62ff\u53d6\u5b83\u4eec\u3002)", Misc.getHighlightColor(), refit, autofit, "\"\u4ed3\u5e93\"");
        }
        return true;
    }

    public static void endGalatiaPortionOfMission(boolean withStipend, boolean didTutorial) {
        if (withStipend) {
            new GalatianAcademyStipend();
        }
        StarSystemAPI system = Global.getSector().getStarSystem("galatia");
        PlanetAPI ancyra = (PlanetAPI)system.getEntityById("ancyra");
        PlanetAPI pontus = (PlanetAPI)system.getEntityById("pontus");
        PlanetAPI tetra = (PlanetAPI)system.getEntityById("tetra");
        SectorEntityToken derinkuyu = system.getEntityById("derinkuyu_station");
        SectorEntityToken probe = system.getEntityById("galatia_probe");
        SectorEntityToken inner = system.getEntityById("galatia_jump_point_alpha");
        SectorEntityToken fringe = system.getEntityById("galatia_jump_point_fringe");
        SectorEntityToken relay = system.getEntityById("ancyra_relay");
        relay.getMemoryWithoutUpdate().unset("$objectiveNonFunctional");
        Global.getSector().getCharacterData().addAbility("transponder");
        Global.getSector().getCharacterData().addAbility("go_dark");
        Global.getSector().getCharacterData().addAbility("sensor_burst");
        Global.getSector().getCharacterData().addAbility("emergency_burn");
        Global.getSector().getCharacterData().addAbility("sustained_burn");
        Global.getSector().getCharacterData().addAbility("scavenge");
        Global.getSector().getCharacterData().addAbility("interdiction_pulse");
        Global.getSector().getCharacterData().addAbility("distress_call");
        FactionAPI hegemony = Global.getSector().getFaction("hegemony");
        if (hegemony.getRelToPlayer().getRel() < 0.0f) {
            hegemony.getRelToPlayer().setRel(0.0f);
        }
        Global.getSector().getEconomy().addMarket(ancyra.getMarket(), false);
        Global.getSector().getEconomy().addMarket(derinkuyu.getMarket(), false);
        HintPanelAPI hints = Global.getSector().getCampaignUI().getHintPanel();
        if (hints != null) {
            hints.clearHints(false);
        }
        if (!SystemBountyManager.getInstance().isActive(ancyra.getMarket())) {
            SystemBountyManager.getInstance().addActive(new SystemBountyIntel(ancyra.getMarket()));
        }
        RogueMinerMiscFleetManager script = new RogueMinerMiscFleetManager(derinkuyu);
        int i = 0;
        while (i < 20) {
            script.advance(1.0f);
            ++i;
        }
        system.addScript(script);
        for (CampaignFleetAPI fleet : system.getFleets()) {
            if (!"pirates".equals(fleet.getFaction().getId())) continue;
            fleet.removeScriptsOfClass(TutorialLeashAssignmentAI.class);
        }
        inner.getMemoryWithoutUpdate().unset("$unstable");
        inner.getMemoryWithoutUpdate().unset("$canStabilize");
        fringe.getMemoryWithoutUpdate().unset("$unstable");
        fringe.getMemoryWithoutUpdate().unset("$canStabilize");
        system.removeTag("system_cut_off_from_hyper");
        MarketAPI market = ancyra.getMarket();
        market.getMemoryWithoutUpdate().unset("$doNotInitCommListings");
        market.getStats().getDynamic().getMod("patrol_num_light_mod").unmodifyMult(REASON);
        market.getStats().getDynamic().getMod("patrol_num_medium_mod").unmodifyMult(REASON);
        market.getStats().getDynamic().getMod("patrol_num_heavy_mod").unmodifyMult(REASON);
        market.setEconGroup(null);
        derinkuyu.getMarket().setEconGroup(null);
    }

    protected void saveNag() {
        if (!Global.getSector().hasScript(SaveNagScript.class)) {
            Global.getSector().addScript(new SaveNagScript(10.0f));
        }
    }

    public void addWeaponsToStorage() {
        StoragePlugin plugin = (StoragePlugin)this.ancyra.getMarket().getSubmarket("storage").getPlugin();
        plugin.setPlayerPaidToUnlock(true);
        CargoAPI cargo = plugin.getCargo();
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        for (FleetMemberAPI member : player.getFleetData().getMembersListCopy()) {
            if (!member.getVariant().hasTag("ship_recoverable")) continue;
            for (WeaponSlotAPI slot : member.getVariant().getHullSpec().getAllWeaponSlotsCopy()) {
                String weaponId = this.getWeaponForSlot(slot);
                if (weaponId == null) continue;
                cargo.addWeapons(weaponId, 1);
            }
        }
        cargo.addFighters("broadsword_wing", 1);
        cargo.addFighters("piranha_wing", 1);
        cargo.addSupplies(100.0f);
        cargo.sort();
    }

    public String getWeaponForSlot(WeaponSlotAPI slot) {
        switch (slot.getWeaponType()) {
            case BALLISTIC: 
            case UNIVERSAL: 
            case HYBRID: 
            case COMPOSITE: {
                switch (slot.getSlotSize()) {
                    case LARGE: {
                        return this.pick("mark9", "hephag", "hellbore");
                    }
                    case MEDIUM: {
                        return this.pick("arbalest", "heavymortar", "shredder");
                    }
                    case SMALL: {
                        return this.pick("lightmg", "lightac", "lightmortar");
                    }
                }
                break;
            }
            case MISSILE: 
            case SYNERGY: {
                switch (slot.getSlotSize()) {
                    case LARGE: {
                        return this.pick("hammerrack");
                    }
                    case MEDIUM: {
                        return this.pick("pilum", "annihilatorpod");
                    }
                    case SMALL: {
                        return this.pick("harpoon", "sabot", "annihilator");
                    }
                }
                break;
            }
            case ENERGY: {
                switch (slot.getSlotSize()) {
                    case LARGE: {
                        return this.pick("autopulse", "hil");
                    }
                    case MEDIUM: {
                        return this.pick("miningblaster", "gravitonbeam", "pulselaser");
                    }
                    case SMALL: {
                        return this.pick("mininglaser", "taclaser", "pdlaser", "ioncannon");
                    }
                }
            }
        }
        return null;
    }

    public String pick(String ... strings) {
        return strings[new Random().nextInt(strings.length)];
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.setParaSmallInsignia();
        info.addPara(this.getName(), c, 0.0f);
        info.setParaFontDefault();
        this.addBulletPoints(info, mode);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float opad = 10.0f;
        float pad = 3.0f;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            pad = 10.0f;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        switch (this.stage) {
            case INIT: {
                info.addPara("\u8054\u7cfb " + this.getMainContactPostName() + "\uff0c\u5176\u4f4d\u7f6e\u5728 Ancyra.", tc, pad);
                break;
            }
            case GO_GET_DATA: {
                info.addPara("\u6f5c\u5165 " + this.derinkuyu.getName(), tc, pad);
                info.addPara("\u8054\u7cfb " + this.dataContact.getNameString() + " \u5e76\u83b7\u5f97\u8c03\u67e5\u62a5\u544a", tc, 0.0f);
                break;
            }
            case GOT_DATA: {
                info.addPara("\u5c06\u6570\u636e\u4ea4\u7ed9 " + this.getMainContactPostName() + "\uff0c\u5176\u4f4d\u7f6e\u5728 Ancyra.", tc, pad);
                break;
            }
            case GO_GET_AI_CORE: {
                info.addPara("\u524d\u5f80 Pontus \u6c14\u6001\u5de8\u884c\u661f\u8f68\u9053\u5916\u7684 \u5e9f\u5f03\u63a2\u6d4b\u5668\u53d6\u56de AI \u6838\u5fc3", tc, pad);
                break;
            }
            case GOT_AI_CORE: {
                info.addPara("\u628a AI \u6838\u5fc3\u4ea4\u7ed9 " + this.getMainContactPostName() + "\uff0c\u5176\u4f4d\u7f6e\u5728 Ancyra.", tc, pad);
                break;
            }
            case GO_RECOVER_SHIPS: {
                info.addPara("\u524d\u5f80 Tetra \u9644\u8fd1\u5e76\u81f3\u5c11\u6253\u635e %s \u8258\u8230\u8239", pad, tc, h, "2");
                break;
            }
            case RECOVERED_SHIPS: {
                info.addPara("\u56de\u5230 " + this.getMainContactPostName() + " \u90a3\uff0c\u5e76\u5411\u5176\u5c55\u793a\u4f60\u7684 \"\u65b0\u8239\"", tc, pad);
                break;
            }
            case GO_STABILIZE: {
                info.addPara("\u7a33\u5b9a\u661f\u7cfb\u5185\u90e8\u8df3\u8dc3\u70b9", tc, pad);
                break;
            }
            case STABILIZED: {
                info.addPara("\u56de\u5230 Ancyra \u5e76\u5e26\u56de\u4f60\u7684\u6377\u62a5", tc, pad);
                break;
            }
            case DELIVER_REPORT: {
                info.addPara("\u524d\u5f80 Jangala \u5e76\u5c06\u62a5\u7ed9\u63d0\u4ea4\u7ed9 " + this.getJangalaContactPostName() + " ", tc, pad);
                break;
            }
            case DONE: {
                info.addPara("\u5b8c\u6210", tc, pad);
            }
        }
        this.unindent(info);
    }

    @Override
    public String getName() {
        return "\u7a33\u5b9a\u8df3\u8dc3\u70b9";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    protected String getMainContactPostName() {
        return String.valueOf(this.mainContact.getPost()) + " " + this.mainContact.getNameString();
    }

    protected String getJangalaContactPostName() {
        return String.valueOf(this.jangalaContact.getPost()) + " " + this.jangalaContact.getNameString();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        boolean addedBullets = false;
        switch (this.stage) {
            case INIT: {
                info.addPara("\u4f60\u6536\u5230\u672c\u661f\u7cfb\u53ef\u5c45\u4f4f\u884c\u661f Ancyra \u7684\u8fd1\u8ddd\u79bb\u5149\u675f\u901a\u4fe1\u3002", opad);
                info.addPara("\u6d88\u606f\u5f88\u7b80\u5355\uff0c\u8981\u6c42\u4f60\u5c3d\u5feb\u524d\u5f80\u90a3\u91cc\u5e76\u8054\u7cfb " + this.getMainContactPostName() + " \u3002", opad);
                break;
            }
            case GO_GET_DATA: {
                info.addPara("\u8054\u7cfb " + this.dataContact.getNameString() + "\uff0c\u5e76\u5728 Derinkuyu \u91c7\u77ff\u7ad9\u90a3" + "\u83b7\u53d6 \u539f\u59cb\u8df3\u8dc3\u70b9\u8bfb\u6570\u3002", opad);
                info.addPara("\u987b\u5173\u95ed\u5e94\u7b54\u5668\uff0c\u56e0\u4e3a Derinkuyu \u91c7\u77ff\u7ad9\u5df2\u88ab\u6d77\u76d7\u5360\u9886\uff0c\u5426\u5219\u4f60\u7684\u8230\u961f\u5c06\u53d7\u5230\u653b\u51fb\u3002", opad);
                info.addPara("\u5229\u7528 %s \u6765\u6f5c\u5165\uff0c\u5982\u679c\u88ab\u53d1\u73b0\uff0c\u53ef\u4f7f\u7528 %s \u9003\u8dd1\u3002", opad, h, "\u533f\u8e2a", "\u7d27\u6025\u52a0\u901f");
                break;
            }
            case GOT_DATA: {
                info.addPara("\u8fd4\u56de Ancyra \u5e76\u8054\u7cfb " + this.getMainContactPostName() + " \u4ee5\u4ea4\u4ed8\u8df3\u8dc3\u70b9\u6570\u636e\u3002", opad);
                break;
            }
            case GO_GET_AI_CORE: {
                info.addPara("\u7531\u4e8e\u5206\u6790\u8be5\u8df3\u8dc3\u70b9\u6570\u636e\u9700\u8981\u4e00\u4e2a AI \u6838\u5fc3\u3002", opad);
                info.addPara("\u800c\u5728 Pontus \u6c14\u6001\u5de8\u884c\u661f\u8f68\u9053\u9644\u8fd1\u6709\u4e00\u67b6\u5e9f\u5f03\u7684 \u4eba\u4e4b\u9886-\u63a2\u6d4b\u5668\uff0c\u5982\u679c\u524d\u53bb\u56de\u6536\uff0c\u5c06\u5f88\u53ef\u80fd\u83b7\u5f97 \u4f3d\u9a6c AI \u6838\u5fc3\uff0c\u8fd9\u5c31\u5e94\u8be5\u8db3\u4ee5\u5b8c\u6210\u5206\u6790\u4efb\u52a1\u3002", opad);
                info.addPara("\u5373\u523b\u524d\u5f80 Pontus \u6c14\u6001\u5de8\u884c\u661f\uff0c\u5728\u9760\u8fd1\u5c0f\u884c\u661f\u5e26\u65f6\uff0c\u4f7f\u7528 %s \u6765\u5b9a\u4f4d\u63a2\u6d4b\u5668\u4f4d\u7f6e\u3002", opad, h, "\u4f20\u611f\u5668\u626b\u63cf");
                info.addPara("\u63a5\u8fd1\u63a2\u6d4b\u5668\u5e76\u6253\u635e\u5b83\u6765\u83b7\u5f97 AI \u6838\u5fc3\u3002", opad);
                info.addPara("\u4f46\u4f60\u5fc5\u987b\u9762\u5bf9\u90a3\u4e9b\u4ecd\u5728\u8fd0\u4f5c\u7684\u81ea\u52a8\u9632\u5fa1\u7cfb\u7edf\u3002", opad);
                break;
            }
            case GOT_AI_CORE: {
                info.addPara("\u8fd4\u56de Ancyra \u5e76\u8054\u7cfb " + this.getMainContactPostName() + " \u4ee5\u4ea4\u4ed8 AI \u6838\u5fc3\u3002", opad);
                break;
            }
            case GO_RECOVER_SHIPS: {
                info.addPara("\u524d\u5f80 Tetra \u8352\u829c\u884c\u661f\u9644\u8fd1\u7684\u6c89\u8239\u5893\u5730\uff0c\u5e76\u5c3d\u53ef\u80fd\u5730\u6062\u590d\u53ef\u7528\u8230\u8239\u3002", opad);
                info.addPara("\u5e26\u4e0a\u989d\u5916\u7684\u8239\u5458\u80fd\u6709\u52a9\u4e8e\u786e\u4fdd\u4fee\u590d\u7684\u8230\u8239\u62e5\u6709\u8db3\u591f\u8239\u5458\uff0c\u5e26\u4e0a\u989d\u5916\u7684\u8865\u7ed9\u6709\u52a9\u4e8e\u6062\u590d\u90a3\u4e9b\u8230\u8239\u7684 \u6218\u5907\u503c\u3002", opad);
                break;
            }
            case RECOVERED_SHIPS: {
                info.addPara("\u56de\u5230 " + this.getMainContactPostName() + " \u90a3\uff0c\u5e76\u5728 Ancyra \u7684\u8239\u575e\u91cc\u4e3a\u4f60\u6240\u6253\u635e\u4e0a\u7684\u8230\u8239\u914d\u5907\u5408\u9002\u6b66\u5668\u3002", opad);
                break;
            }
            case GO_STABILIZE: {
                info.addPara("\u5229\u7528 AI \u6838\u5fc3\u4ea7\u751f\u7684\u8d85\u6ce2\u5e8f\u5217\u6765\u7a33\u5b9a\u661f\u7cfb\u5185\u90e8\u8df3\u8dc3\u70b9\u3002", opad);
                info.addPara("\u4f46\u4f60\u5fc5\u987b\u5148\u51fb\u8d25\u5b88\u536b\u5b83\u7684\u6d77\u76d7\u3002", opad);
                break;
            }
            case STABILIZED: {
                info.addPara("Galatia \u4e0e\u8d85\u7a7a\u95f4\u7684\u8fde\u63a5\u5df2\u7ecf\u6062\u590d\uff0c\u8d38\u6613\u8230\u961f\u5c06\u5141\u8bb8 \u518d\u6b21\u8fdb\u51fa\u8be5\u661f\u7cfb\u3002", opad);
                info.addPara("\u800c Derinkuyu \u7684\u9886\u5bfc\u5c42\u80af\u5b9a\u5f88\u5feb\u5c31\u4f1a\u88ab\u6e34\u671b\u518d\u6b21 \u7ad9\u5728\u6b63\u4e49\u4e0e\u6cd5\u5f8b\u4e00\u8fb9\u7684\u666e\u901a\u77ff\u5de5\u4eec\u6240\u63a8\u7ffb\u3002", opad);
                break;
            }
            case DELIVER_REPORT: {
                info.addPara(String.valueOf(Misc.ucFirst(this.getMainContactPostName())) + " \u8981\u6c42\u4f60\u5373\u523b\u524d\u5f80 Jangala, " + "\u5e76\u5c06\u8fd9\u4efd\u62a5\u544a\u4ea4\u7ed9 " + this.getJangalaContactPostName() + " \u6765\u83b7\u53d6\u5956\u52b1\u3002", opad);
                info.addPara("\u786e\u4fdd\u4f60\u6709\u8db3\u591f\u7684\u71c3\u6599\u6765\u987a\u5229\u8fdc\u822a\u3002", opad);
                break;
            }
            case DONE: {
                info.addPara("\u5728\u63d0\u4ea4\u62a5\u544a\u540e\uff0c\u4f60\u4e0e\u9738\u4e3b\u95f4\u7684\u5173\u7cfb\u6709\u4e86\u5b9e\u8d28\u6027\u7684\u63d0\u5347\u3002", opad);
                info.addPara("Galatia \u4e0e\u8d85\u7a7a\u95f4\u7684\u8fde\u63a5\u5df2\u7ecf\u6062\u590d\uff0c\u8d38\u6613\u8230\u961f\u5c06\u5141\u8bb8 \u518d\u6b21\u8fdb\u51fa\u8be5\u661f\u7cfb\u3002", opad);
            }
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("campaignMissions", "tutorial");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Story");
        tags.add("hegemony");
        return tags;
    }

    @Override
    public String getCommMessageSound() {
        if (this.isSendingUpdate()) {
            return TutorialMissionIntel.getSoundStandardUpdate();
        }
        return TutorialMissionIntel.getSoundMajorPosting();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        switch (this.stage) {
            case INIT: {
                return this.ancyra;
            }
            case GO_GET_DATA: {
                return this.derinkuyu;
            }
            case GOT_DATA: {
                return this.ancyra;
            }
            case GO_GET_AI_CORE: {
                return this.pontus;
            }
            case GOT_AI_CORE: {
                return this.ancyra;
            }
            case GO_RECOVER_SHIPS: {
                return this.tetra;
            }
            case RECOVERED_SHIPS: {
                return this.ancyra;
            }
            case GO_STABILIZE: {
                return this.inner;
            }
            case STABILIZED: {
                return this.ancyra;
            }
            case DELIVER_REPORT: {
                return this.jangala;
            }
            case DONE: {
                return this.ancyra;
            }
        }
        return this.ancyra;
    }

    @Override
    public boolean canTurnImportantOff() {
        return this.isEnding();
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        return IntelInfoPlugin.IntelSortTier.TIER_2;
    }

    @Override
    public String getSortString() {
        return this.getName();
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TutorialMissionStage {
        INIT,
        GO_GET_DATA,
        GOT_DATA,
        GO_GET_AI_CORE,
        GOT_AI_CORE,
        GO_RECOVER_SHIPS,
        RECOVERED_SHIPS,
        GO_STABILIZE,
        STABILIZED,
        DELIVER_REPORT,
        DONE;

    }
}

