/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialSustainedBurnDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;
    protected MarketAPI ancyra;

    public TutorialSustainedBurnDialogPluginImpl(MarketAPI ancyra) {
        this.ancyra = ancyra;
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showFleetInfo("\u4f60\u7684\u8230\u961f", this.playerFleet, null, null);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        String name = this.ancyra.getName();
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph(String.valueOf(name) + " \u56e0\u8ddd\u79bb\u8f83\u8fdc\uff0c\u5982\u4ee5\u5f53\u524d\u7684\u822a\u884c\u901f\u5ea6\u5411\u76ee\u6807\u8fdb\u53d1\uff0c\u6240\u9700\u65f6\u95f4\u53ef\u80fd\u8f83\u957f\u3002");
                this.options.clearOptions();
                this.options.addOption("\u7ee7\u7eed", (Object)OptionId.CONT1, null);
                break;
            }
            case CONT1: {
                AbilitySpecAPI ability = Global.getSettings().getAbilitySpec("sustained_burn");
                this.textPanel.addPara("%s \u80fd\u529b\u53ef\u7528\u4e8e\u957f\u8ddd\u79bb\u822a\u884c\u3002\u542f\u52a8\u8be5\u80fd\u529b\u4f1a\u4f7f\u8230\u961f\u6682\u65f6\u9759\u6b62\uff0c\u5e76\u5c06\u5176\u52a0\u901f\u5ea6\u964d\u5230\u6700\u4f4e\uff0c\u4f46\u662f\u8230\u961f\u7684 \u6700\u5927\u5b87\u5b99\u822a\u901f \u4f1a\u5927\u5e45\u63d0\u9ad8\u3002\u6301\u7eed\u52a0\u901f\u72b6\u6001\u53ef\u4ee5\u88ab\u5176\u4ed6\u8230\u961f\u4ee5 \u963b\u65ad\u8109\u51b2 \u6240\u6253\u65ad\u3002", Misc.getHighlightColor(), "\"" + ability.getName() + "\"");
                Global.getSector().getCharacterData().addAbility(ability.getId());
                PersistentUIDataAPI.AbilitySlotsAPI slots = Global.getSector().getUIData().getAbilitySlotsAPI();
                slots.setCurrBarIndex(0);
                int slotIndex = 4;
                slots.getCurrSlotsCopy().get(slotIndex).setAbilityId(ability.getId());
                AddRemoveCommodity.addAbilityGainText(ability.getId(), this.textPanel);
                Global.getSector().getCharacterData().addAbility("interdiction_pulse");
                slots.getCurrSlotsCopy().get(6).setAbilityId("interdiction_pulse");
                AddRemoveCommodity.addAbilityGainText("interdiction_pulse", this.textPanel);
                this.options.clearOptions();
                this.options.addOption("\u7ee7\u7eed", (Object)OptionId.CONT2, null);
                break;
            }
            case CONT2: {
                AbilitySpecAPI ability = Global.getSettings().getAbilitySpec("sustained_burn");
                String control = Global.getSettings().getControlStringForEnumName("FAST_FORWARD");
                this.textPanel.addPara("\u6fc0\u6d3b %s \u6765\u524d\u5f80 " + name + " \u5c06\u66f4\u52a0\u5feb\u6377\u3002", Misc.getHighlightColor(), "\"" + ability.getName() + "\"");
                this.textPanel.addPara("\u540c\u65f6\u4f60\u4e5f\u53ef\u4ee5\u6309\u4f4f %s \u6765\u52a0\u5feb\u65f6\u95f4\u3002", Misc.getHighlightColor(), "\"" + control + "\"");
                this.options.clearOptions();
                this.options.addOption("\u5b8c\u6210", (Object)OptionId.CONT3, null);
                break;
            }
            case CONT3: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        CONT1,
        CONT2,
        CONT3;

    }
}

