/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.loading.AbilitySpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialWelcomeDialogPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected CampaignFleetAPI playerFleet;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.showFleetInfo("\u4f60\u7684\u8230\u961f", this.playerFleet, null, null);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.textPanel.addParagraph("\u6b22\u8fce\u6765\u5230 \u82f1\u4ed9\u5ea7\u661f\u57df\uff01\u4f60\u7684\u8230\u961f\u73b0\u5728\u6b63\u5728\u65e0\u4eba\u5b99\u57df\uff0c\u5e76\u4e14\u6781\u7aef\u7f3a\u4e4f\u8865\u7ed9\u3002");
                this.textPanel.addParagraph("\u5982\u679c\u65e0\u6cd5\u5728\u77ed\u65f6\u95f4\u5185\u83b7\u53d6\u989d\u5916\u7684\u7269\u8d44\u8865\u7ed9\uff0c\u4f60\u7684\u8230\u961f\u5c06\u4f1a\u9010\u6e10\u8870\u5f31\u5e76\u6700\u7ec8\u6bc1\u706d\u3002");
                this.options.clearOptions();
                this.options.addOption("\u7ee7\u7eed", (Object)OptionId.CONT1, null);
                break;
            }
            case CONT1: {
                AbilitySpecAPI ability = Global.getSettings().getAbilitySpec("scavenge");
                this.textPanel.addPara("\u5e78\u8fd0\u7684\u662f\uff0c\u9644\u8fd1\u6709\u4e00\u7247\u6b8b\u9ab8\u533a\u3002\u5411\u4e0a\u79fb\u52a8\u5230\u9644\u8fd1\uff0c\u5e76\u6fc0\u6d3b\u4f60\u7684 %s \u80fd\u529b\u6765\u5bfb\u627e\u6709\u7528\u7269\u8d44\u3002", Misc.getHighlightColor(), "\"" + ability.getName() + "\"");
                this.textPanel.addParagraph("\u6253\u635e\u5f97\u9760\u91cd\u578b\u673a\u68b0\u7684\u5e2e\u52a9\uff0c\u5e78\u8fd0\u7684\u662f\uff0c\u4f60\u7684\u8d27\u8231\u91cc\u5e94\u8be5\u8fd8\u6709\u4e00\u4e9b\u3002");
                Global.getSector().getCharacterData().addAbility(ability.getId());
                PersistentUIDataAPI.AbilitySlotsAPI slots = Global.getSector().getUIData().getAbilitySlotsAPI();
                slots.setCurrBarIndex(0);
                int slotIndex = 5;
                slots.getCurrSlotsCopy().get(slotIndex).setAbilityId(ability.getId());
                AddRemoveCommodity.addAbilityGainText(ability.getId(), this.textPanel);
                this.textPanel.addParagraph("\u83b7\u53d6\u6240\u6709\u8865\u7ed9\u548c\u4efb\u4f55\u5176\u4ed6\u6709\u4ef7\u503c\u7684\u7269\u8d44\uff0c\u4f46\u5efa\u8bae\u820d\u5f03\u90a3\u4e9b\u6c89\u91cd\u4e14\u5ec9\u4ef7\u7684\u91d1\u5c5e\u788e\u5757\u3002");
                this.textPanel.addParagraph("\u60f3\u8981\u79fb\u52a8\u8230\u961f\uff0c\u8bf7\u5f80\u8981\u79fb\u52a8\u4f4d\u7f6e\u7684\u7a7a\u767d\u5904\u70b9\u51fb [\u9f20\u6807\u5de6\u952e]\u3002");
                this.options.clearOptions();
                this.options.addOption("\u5b8c\u6210", (Object)OptionId.CONT2, null);
                break;
            }
            case CONT2: {
                Global.getSector().setPaused(false);
                this.dialog.dismiss();
            }
        }
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionId {
        INIT,
        CONT1,
        CONT2;

    }
}

