/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SlipstreamEntityPlugin
extends BaseCustomEntityPlugin {
    public static float MAX_PARTICLES_ADD_PER_FRAME = 100.0f;
    public static float RAD_PER_DEG = (float)Math.PI / 180;
    protected SlipstreamParams params = new SlipstreamParams();
    protected float texelsPerPixel = 1.0f;
    protected transient List<SlipstreamParticle> particles = new ArrayList<SlipstreamParticle>();
    protected float texProgress1 = 0.0f;
    protected float texProgress2 = 0.0f;
    protected float texProgress3 = 0.0f;
    protected FaderUtil fader = new FaderUtil(0.0f, 0.5f, 0.5f);
    protected boolean playerWasInSlipstream = false;

    public static Vector2f rotateAroundOrigin(Vector2f v, float cos, float sin) {
        Vector2f r = new Vector2f();
        r.x = v.x * cos - v.y * sin;
        r.y = v.x * sin + v.y * cos;
        return r;
    }

    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.params = (SlipstreamParams)pluginParams;
        this.fader.fadeIn();
        this.texProgress1 = (float)Math.random();
        this.texProgress2 = (float)Math.random();
        this.texProgress3 = (float)Math.random();
        this.readResolve();
    }

    public float getRenderRange() {
        return Math.max(this.params.width, this.params.length) * 1.5f;
    }

    Object readResolve() {
        if (this.particles == null) {
            this.particles = new ArrayList<SlipstreamParticle>();
        }
        return this;
    }

    public void advance(float amount) {
        if (!this.entity.isInCurrentLocation()) {
            return;
        }
        this.applyEffectToFleets(amount);
        this.fader.advance(amount);
        this.entity.getLocation().x += Misc.getSpeedForBurnLevel(this.params.burnLevel) * amount;
        this.entity.setFacing(0.0f);
        this.params.minColor = new Color(0.5f, 0.3f, 0.75f, 0.85f);
        this.params.maxColor = new Color(0.5f, 0.6f, 1.0f, 1.0f);
        this.params.spriteColor1 = new Color(0.3f, 0.5f, 1.0f, 0.67f);
        this.params.minDur = 1.0f;
        this.params.maxDur = 4.0f;
        this.params.minSpeed = 700.0f;
        this.params.maxSpeed = 1500.0f;
        this.params.minSpeed = Misc.getSpeedForBurnLevel(25.0f);
        this.params.maxSpeed = Misc.getSpeedForBurnLevel(35.0f);
        this.params.maxSpeedForTex = Misc.getSpeedForBurnLevel(15.0f);
        this.params.lineLengthFractionOfSpeed = 0.25f;
        this.params.burnLevel = 30;
        this.params.numParticles = 1000;
        this.params.width = 512.0f;
        this.params.length = 10000.0f;
        this.params.minColor = new Color(0.5f, 0.3f, 0.75f, 0.1f);
        this.params.maxColor = new Color(0.5f, 0.6f, 1.0f, 0.5f);
        this.params.maxDur = 6.0f;
        SpriteAPI sprite = Global.getSettings().getSprite("misc", this.params.spriteKey1);
        this.texelsPerPixel = sprite.getHeight() / this.params.width;
        Vector2f dir = Misc.getUnitVectorAtDegreeAngle(this.entity.getFacing());
        float cos = dir.x;
        float sin = dir.y;
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        int added = 0;
        while (this.particles.size() < this.params.numParticles && (float)added < MAX_PARTICLES_ADD_PER_FRAME) {
            ++added;
            SlipstreamParticle p = new SlipstreamParticle();
            float fLength = (float)Math.random() * 0.8f;
            float sign = Math.signum((float)Math.random() - 0.5f);
            float r = (float)Math.random() * 0.7f;
            float fWidth = 0.5f + sign * (1.0f - (float)Math.sqrt(r)) * fLength * 0.5f;
            fWidth = 0.5f + sign * r * (0.5f + 0.5f * fLength) * 0.5f;
            fWidth = (float)Math.random() * 0.8f + 0.1f;
            float speed = this.params.minSpeed + (this.params.maxSpeed - this.params.minSpeed) * (float)Math.random();
            float dur = this.params.minDur + (this.params.maxDur - this.params.minDur) * (float)Math.random();
            float minDistFromSource = speed * dur * 0.25f;
            p.loc.set(-fLength * (this.params.length - minDistFromSource) - minDistFromSource, fWidth * this.params.width - this.params.width / 2.0f);
            p.loc = SlipstreamEntityPlugin.rotateAroundOrigin(p.loc, cos, sin);
            p.loc.x += x;
            p.loc.y += y;
            float angleToEntity = Misc.getAngleInDegrees(p.loc, this.entity.getLocation());
            float turnDir = Misc.getClosestTurnDirection(this.entity.getFacing(), angleToEntity);
            float diff = Math.min(30.0f, Misc.getAngleDiff(angleToEntity, this.entity.getFacing()) * 0.5f);
            diff = 0.0f;
            p.vel.set((ReadableVector2f)Misc.getUnitVectorAtDegreeAngle(this.entity.getFacing() + turnDir * diff));
            p.vel.scale(speed);
            p.remaining = dur;
            p.color = this.getRandomColor();
            this.particles.add(p);
        }
        Iterator<SlipstreamParticle> iter = this.particles.iterator();
        while (iter.hasNext()) {
            SlipstreamParticle p = iter.next();
            p.remaining -= amount;
            p.elapsed += amount;
            if (p.remaining <= 0.0f) {
                iter.remove();
                continue;
            }
            boolean shouldFadeOut = false;
            Vector2f toEntity = Vector2f.sub((Vector2f)this.entity.getLocation(), (Vector2f)p.loc, (Vector2f)new Vector2f());
            boolean bl = shouldFadeOut = Vector2f.dot((Vector2f)toEntity, (Vector2f)p.vel) < 0.0f;
            if (shouldFadeOut && p.elapsed > 1.0f) {
                p.remaining = Math.min(p.remaining, 0.5f);
            }
            p.loc.x += p.vel.x * amount;
            p.loc.y += p.vel.y * amount;
        }
        float texSpeed = Misc.getSpeedForBurnLevel(this.params.burnLevel);
        float unitsPerOneTexIter = sprite.getWidth();
        float texUnitsPerSecondForSpeed = texSpeed / unitsPerOneTexIter * this.texelsPerPixel;
        this.texProgress1 -= texUnitsPerSecondForSpeed * amount;
        this.texProgress2 += texUnitsPerSecondForSpeed * amount * 1.9f;
        this.texProgress3 += texUnitsPerSecondForSpeed * amount * 0.7f;
    }

    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        SpriteAPI sprite = Global.getSettings().getSprite("misc", this.params.spriteKey1);
        sprite.setNormalBlend();
        sprite.setColor(this.params.spriteColor1);
        this.renderLayer(sprite, this.texProgress1, viewport.getAlphaMult());
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float zoom = Global.getSector().getViewport().getViewMult();
        GL11.glLineWidth((float)Math.max(1.0f, Math.min(2.0f, 2.0f / zoom)));
        GL11.glEnable((int)2848);
        GL11.glBegin((int)1);
        for (SlipstreamParticle p : this.particles) {
            if (!viewport.isNearViewport(p.loc, 500.0f)) continue;
            float a = viewport.getAlphaMult();
            if (p.remaining <= 0.5f) {
                a = p.remaining / 0.5f;
            } else if (p.elapsed < 1.0f) {
                a = p.elapsed / 1.0f;
            }
            Vector2f start = new Vector2f((ReadableVector2f)p.loc);
            Vector2f end = new Vector2f((ReadableVector2f)p.loc);
            start.x += p.vel.x * this.params.lineLengthFractionOfSpeed * 0.1f;
            start.y += p.vel.y * this.params.lineLengthFractionOfSpeed * 0.1f;
            end.x -= p.vel.x * this.params.lineLengthFractionOfSpeed * 0.9f;
            end.y -= p.vel.y * this.params.lineLengthFractionOfSpeed * 0.9f;
            Misc.setColor(p.color, 0.0f);
            GL11.glVertex2f((float)start.x, (float)start.y);
            Misc.setColor(p.color, a);
            GL11.glVertex2f((float)p.loc.x, (float)p.loc.y);
            GL11.glVertex2f((float)p.loc.x, (float)p.loc.y);
            Misc.setColor(p.color, 0.0f);
            GL11.glVertex2f((float)end.x, (float)end.y);
        }
        GL11.glEnd();
    }

    public void renderLayer(SpriteAPI sprite, float texProgress, float alpha) {
        Vector2f from = new Vector2f((ReadableVector2f)this.entity.getLocation());
        Vector2f to = Misc.getUnitVectorAtDegreeAngle(this.entity.getFacing());
        to.scale(-this.params.length);
        Vector2f.add((Vector2f)to, (Vector2f)from, (Vector2f)to);
        float length1 = 500.0f;
        length1 = Math.min(length1, Misc.getDistance(from, to));
        length1 = Misc.getDistance(from, to);
        float length2 = this.params.width / 2.0f;
        if (length1 < length2) {
            length1 = length2;
        }
        length1 += length2;
        length1 = this.params.length * 0.15f;
        length2 = this.params.length - length1;
        float w1 = length2 * 0.3f;
        float w2 = length2 * 1.5f;
        float w3 = length2 * 2.5f;
        float wMult = 0.33f;
        wMult = 1.0f;
        w1 *= wMult;
        w2 *= wMult;
        w3 *= wMult;
        w2 = w3 = this.params.width;
        w1 = w3;
        float widthMult = 0.3f;
        w1 = this.params.width * widthMult;
        w2 = this.params.width * (1.0f - (1.0f - widthMult) * (length2 / (length1 + length2)));
        w3 = this.params.width * 1.0f;
        w2 = w3 = this.params.width;
        w1 = w3;
        float angle = this.entity.getFacing() + 180.0f;
        Vector2f dest = new Vector2f((ReadableVector2f)to);
        Vector2f src = new Vector2f((ReadableVector2f)from);
        Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle);
        Vector2f dest1 = new Vector2f((ReadableVector2f)dir);
        dest1.scale(length1);
        Vector2f.add((Vector2f)dest1, (Vector2f)src, (Vector2f)dest1);
        Vector2f dest2 = new Vector2f((ReadableVector2f)dir);
        dest2.scale(length1 + length2);
        Vector2f.add((Vector2f)dest2, (Vector2f)src, (Vector2f)dest2);
        Vector2f perp = Misc.getUnitVectorAtDegreeAngle(angle + 90.0f);
        GL11.glEnable((int)3553);
        sprite.bindTexture();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        Color color = sprite.getColor();
        boolean wireframe = false;
        if (wireframe) {
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDisable((int)3553);
        }
        float tx1 = length1 / sprite.getWidth() * this.texelsPerPixel;
        GL11.glBegin((int)6);
        Misc.setColor(color, alpha * 1.0f);
        GL11.glTexCoord2f((float)(tx1 * 0.5f + texProgress), (float)0.5f);
        GL11.glVertex2f((float)((src.x + dest1.x) / 2.0f), (float)((src.y + dest1.y) / 2.0f));
        Misc.setColor(color, alpha * 0.0f);
        GL11.glTexCoord2f((float)(0.0f + texProgress), (float)0.0f);
        GL11.glVertex2f((float)(src.x + perp.x * w1 / 2.0f), (float)(src.y + perp.y * w1 / 2.0f));
        GL11.glTexCoord2f((float)(0.0f + texProgress), (float)1.0f);
        GL11.glVertex2f((float)(src.x - perp.x * w1 / 2.0f), (float)(src.y - perp.y * w1 / 2.0f));
        Misc.setColor(color, alpha * 1.0f);
        GL11.glTexCoord2f((float)(tx1 + texProgress), (float)1.0f);
        GL11.glVertex2f((float)(dest1.x - perp.x * w2 / 2.0f), (float)(dest1.y - perp.y * w2 / 2.0f));
        GL11.glTexCoord2f((float)(tx1 + texProgress), (float)0.0f);
        GL11.glVertex2f((float)(dest1.x + perp.x * w2 / 2.0f), (float)(dest1.y + perp.y * w2 / 2.0f));
        Misc.setColor(color, alpha * 0.0f);
        GL11.glTexCoord2f((float)(0.0f + texProgress), (float)0.0f);
        GL11.glVertex2f((float)(src.x + perp.x * w1 / 2.0f), (float)(src.y + perp.y * w1 / 2.0f));
        GL11.glEnd();
        float th = tx1 * length2 / length1;
        GL11.glBegin((int)6);
        Misc.setColor(color, alpha * 1.0f);
        GL11.glTexCoord2f((float)(tx1 + texProgress + th * 0.5f), (float)0.5f);
        GL11.glVertex2f((float)((dest1.x + dest2.x) / 2.0f), (float)((dest1.y + dest2.y) / 2.0f));
        Misc.setColor(color, alpha * 1.0f);
        GL11.glTexCoord2f((float)(tx1 + texProgress), (float)0.0f);
        GL11.glVertex2f((float)(dest1.x + perp.x * w2 / 2.0f), (float)(dest1.y + perp.y * w2 / 2.0f));
        GL11.glTexCoord2f((float)(tx1 + texProgress), (float)1.0f);
        GL11.glVertex2f((float)(dest1.x - perp.x * w2 / 2.0f), (float)(dest1.y - perp.y * w2 / 2.0f));
        Misc.setColor(color, alpha * 0.0f);
        GL11.glTexCoord2f((float)(tx1 + texProgress + th), (float)1.0f);
        GL11.glVertex2f((float)(dest2.x - perp.x * w3 / 2.0f), (float)(dest2.y - perp.y * w3 / 2.0f));
        GL11.glTexCoord2f((float)(tx1 + texProgress + th), (float)0.0f);
        GL11.glVertex2f((float)(dest2.x + perp.x * w3 / 2.0f), (float)(dest2.y + perp.y * w3 / 2.0f));
        Misc.setColor(color, alpha * 1.0f);
        GL11.glTexCoord2f((float)(tx1 + texProgress), (float)0.0f);
        GL11.glVertex2f((float)(dest1.x + perp.x * w2 / 2.0f), (float)(dest1.y + perp.y * w2 / 2.0f));
        GL11.glEnd();
        if (wireframe) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
    }

    public Color getRandomColor() {
        return Misc.interpolateColor(this.params.minColor, this.params.maxColor, (float)Math.random());
    }

    public float[] getLengthAndWidthFractionWithinStream(Vector2f loc) {
        float dist = Misc.getDistance(loc, this.entity.getLocation());
        if (dist > this.getRenderRange()) {
            return null;
        }
        Vector2f p3 = new Vector2f((ReadableVector2f)loc);
        Vector2f p1 = new Vector2f((ReadableVector2f)this.entity.getLocation());
        Vector2f p2 = Misc.getUnitVectorAtDegreeAngle(this.entity.getFacing() + 180.0f);
        p2.scale(this.params.length);
        Vector2f.add((Vector2f)p2, (Vector2f)p1, (Vector2f)p2);
        float u = (p3.x - p1.x) * (p2.x - p1.x) + (p3.y - p1.y) * (p2.y - p1.y);
        float denom = Vector2f.sub((Vector2f)p2, (Vector2f)p1, (Vector2f)new Vector2f()).length();
        denom *= denom;
        if (denom == 0.0f) {
            return null;
        }
        if ((u /= denom) >= 0.0f && u <= 1.0f) {
            Vector2f intersect = new Vector2f();
            intersect.x = p1.x + u * (p2.x - p1.x);
            intersect.y = p1.y + u * (p2.y - p1.y);
            float distFromLine = Vector2f.sub((Vector2f)intersect, (Vector2f)p3, (Vector2f)new Vector2f()).length();
            if (distFromLine >= this.params.width / 2.0f) {
                return null;
            }
            float[] result = new float[]{u, distFromLine / (this.params.width / 2.0f)};
            return result;
        }
        return null;
    }

    public void applyEffectToFleets(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
            this.applyEffect(fleet, days);
        }
    }

    public void applyEffect(SectorEntityToken other, float days) {
        if (other instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)other;
            float[] offset = this.getLengthAndWidthFractionWithinStream(fleet.getLocation());
            if (offset == null) {
                if (fleet.isPlayerFleet()) {
                    this.playerWasInSlipstream = false;
                }
                return;
            }
            float burnBonus = fleet.getFleetData().getBurnLevel() - fleet.getFleetData().getMinBurnLevelUnmodified();
            if (burnBonus < 0.0f) {
                burnBonus = 0.0f;
            }
            float maxSpeedWithWind = Misc.getSpeedForBurnLevel((float)this.params.burnLevel + burnBonus + 1.2f);
            if (fleet.getVelocity().length() >= maxSpeedWithWind) {
                return;
            }
            float fL = offset[0];
            float fW = offset[1];
            float intensity = 1.0f;
            if (fL > 0.75f) {
                intensity = (1.0f - fL) / 0.25f;
            } else if (fL < 0.5f) {
                intensity = fL / 0.5f;
            }
            if (fW > 0.5f) {
                intensity *= (1.0f - fW) / 0.5f;
            }
            if (intensity <= 0.0f) {
                if (fleet.isPlayerFleet()) {
                    this.playerWasInSlipstream = false;
                }
                return;
            }
            if (fleet.isPlayerFleet() && !this.playerWasInSlipstream) {
                this.playerWasInSlipstream = true;
                fleet.addFloatingText("\u8fdb\u5165\u6ed1\u6d41", Misc.setAlpha(fleet.getIndicatorColor(), 255), 0.5f);
            }
            float maxFleetBurn = fleet.getFleetData().getBurnLevel();
            float currFleetBurn = fleet.getCurrBurnLevel();
            float maxWindBurn = (float)this.params.burnLevel * 2.0f;
            float currWindBurn = intensity * maxWindBurn;
            float maxFleetBurnIntoWind = maxFleetBurn - Math.abs(currWindBurn);
            float seconds = days * Global.getSector().getClock().getSecondsPerDay();
            Vector2f windDir = Misc.getUnitVectorAtDegreeAngle(this.entity.getFacing());
            if (currWindBurn < 0.0f) {
                windDir.negate();
            }
            Vector2f velDir = Misc.normalise(new Vector2f((ReadableVector2f)fleet.getVelocity()));
            velDir.scale(currFleetBurn);
            float fleetBurnAgainstWind = -1.0f * Vector2f.dot((Vector2f)windDir, (Vector2f)velDir);
            float accelMult = 0.5f;
            accelMult *= 2.0f;
            float windSpeed = Misc.getSpeedForBurnLevel(currWindBurn);
            Vector2f windVector = new Vector2f((ReadableVector2f)windDir);
            windVector.scale(windSpeed);
            Vector2f vel = fleet.getVelocity();
            Vector2f diff = Vector2f.sub((Vector2f)windVector, (Vector2f)vel, (Vector2f)new Vector2f());
            float max = diff.length();
            diff = Misc.normalise(diff);
            diff.scale(fleet.getAcceleration() * 3.0f * seconds);
            if (diff.length() > max) {
                diff.scale(max / diff.length());
            }
            accelMult = 0.5f;
            if (fleetBurnAgainstWind > maxFleetBurnIntoWind) {
                accelMult += 0.75f + 0.25f * (fleetBurnAgainstWind - maxFleetBurnIntoWind);
            }
            windDir.scale(seconds * Math.max(fleet.getTravelSpeed(), fleet.getAcceleration()) * accelMult);
            fleet.setVelocity(vel.x + windDir.x, vel.y + windDir.y);
            Color glowColor = this.params.spriteColor1;
            int alpha = glowColor.getAlpha();
            if (alpha < 75) {
                glowColor = Misc.setAlpha(glowColor, 75);
            }
            float fleetSpeedAlongWind = Vector2f.dot((Vector2f)windDir, (Vector2f)fleet.getVelocity());
            float fleetSpeed = fleet.getVelocity().length();
            float matchingWindFraction = fleetSpeedAlongWind / windSpeed;
            float effectMag = 1.0f - matchingWindFraction * 0.5f;
            if (effectMag > 0.0f) {
                effectMag = 0.0f;
            }
            if (effectMag < 0.5f) {
                effectMag = 0.5f;
            }
            String modId = "slipstream_" + this.entity.getId();
            float durIn = 1.0f;
            float durOut = 3.0f;
            Misc.normalise(windDir);
            float sizeNormal = 10.0f + 25.0f * intensity * effectMag;
            for (FleetMemberViewAPI view : fleet.getViews()) {
                view.getWindEffectDirX().shift(modId, windDir.x * sizeNormal, durIn, durOut, 1.0f);
                view.getWindEffectDirY().shift(modId, windDir.y * sizeNormal, durIn, durOut, 1.0f);
                view.getWindEffectColor().shift(modId, glowColor, durIn, durOut, intensity);
            }
        }
    }

    public static class SlipstreamParams {
        public String spriteKey1 = "slipstream1";
        public Color spriteColor1 = new Color(0.3f, 0.5f, 1.0f, 0.67f);
        public float width;
        public float length;
        public int numParticles;
        public float minSpeed;
        public float maxSpeed;
        public float maxSpeedForTex;
        public int burnLevel = 30;
        public Color minColor;
        public Color maxColor;
        public float minDur = 0.0f;
        public float maxDur = 4.0f;
        public float lineLengthFractionOfSpeed = 0.5f;
    }

    public static class SlipstreamParticle {
        Vector2f loc = new Vector2f();
        Vector2f vel = new Vector2f();
        Color color;
        float remaining;
        float elapsed;
    }
}

