/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.world;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.shared.WormholeManager;
import java.awt.Color;
import java.util.Iterator;
import java.util.Random;

public class Limbo {
    public void generate(SectorAPI sector) {
        SpecialItemData item;
        StarSystemAPI system = sector.createStarSystem("Limbo");
        system.addTag("theme_hidden");
        system.addTag("theme_special");
        float w = Global.getSettings().getFloat("sectorWidth");
        float h = Global.getSettings().getFloat("sectorHeight");
        system.getLocation().set(-w / 2.0f + 2300.0f, -h / 2.0f + 2100.0f);
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background4.jpg");
        PlanetAPI star = system.initStar("limbo", "star_browndwarf", 400.0f, 250.0f);
        system.setLightColor(new Color(180, 205, 140));
        Random random = StarSystemGenerator.random;
        PlanetAPI planet = system.addPlanet("limbo_hades", star, "Hades", "rocky_metallic", 215.0f, 60.0f, 1700.0f, 75.0f);
        planet.getMemoryWithoutUpdate().set("$hades", true);
        planet.setCustomDescriptionId("limbo_hades");
        planet.getMarket().addCondition("no_atmosphere");
        planet.getMarket().addCondition("cold");
        planet.getMarket().addCondition("poor_light");
        planet.getMarket().addCondition("rare_ore_rich");
        float orbitRadius = planet.getRadius() + 300.0f;
        float orbitDays = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
        BaseThemeGenerator.EntityLocation loc = new BaseThemeGenerator.EntityLocation();
        loc.orbit = Global.getFactory().createCircularOrbitPointingDown(planet, random.nextFloat() * 360.0f, orbitRadius, orbitDays);
        BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addEntity(null, (LocationAPI)system, loc, "station_mining_remnant", "neutral");
        added.entity.getMemoryWithoutUpdate().set("$salvageSpecId", "limbo_mining_station");
        added.entity.setName("\u5168\u81ea\u52a8\u91c7\u77ff\u7ad9");
        added.entity.getMemoryWithoutUpdate().set("$limboMiningStation", true);
        added.entity.setCustomDescriptionId("station_mining_automated");
        CargoAPI cargo = Global.getFactory().createCargo(true);
        cargo.addCommodity("rare_metals", 200.0f + (float)random.nextInt(101));
        BaseSalvageSpecial.addExtraSalvage(added.entity, cargo);
        StarSystemGenerator.addStableLocations(system, 1);
        Iterator<SectorEntityToken> iterator = system.getEntitiesWithTag("stable_location").iterator();
        if (iterator.hasNext()) {
            SectorEntityToken curr = iterator.next();
            curr.getMemoryWithoutUpdate().set(WormholeManager.LIMBO_STABLE_LOCATION, true);
            orbitRadius = curr.getRadius() + 200.0f;
            orbitDays = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
            loc = new BaseThemeGenerator.EntityLocation();
            loc.orbit = Global.getFactory().createCircularOrbitPointingDown(curr, random.nextFloat() * 360.0f, orbitRadius, orbitDays);
            added = BaseThemeGenerator.addEntity(null, (LocationAPI)system, loc, "large_cache", "neutral");
            added.entity.getMemoryWithoutUpdate().set("$salvageSpecId", "limbo_wormhole_cache");
            added.entity.setName("\u5c01\u5b58\u7684\u8bbe\u5907\u85cf\u533f\u70b9");
            added.entity.setCustomDescriptionId("limbo_wormhole_cache");
            added.entity.getMemoryWithoutUpdate().set("$limboWormholeCache", true);
            cargo = Global.getFactory().createCargo(true);
            item = WormholeManager.createWormholeAnchor("foxtrot", "Foxtrot");
            cargo.addItems(CargoAPI.CargoItemType.SPECIAL, item, 1.0f);
            item = new SpecialItemData("wormhole_scanner", null);
            cargo.addItems(CargoAPI.CargoItemType.SPECIAL, item, 1.0f);
            cargo.addFuel(110 + random.nextInt(21));
            BaseSalvageSpecial.addExtraSalvage(added.entity, cargo);
        }
        if (Global.getSettings().isDevMode()) {
            orbitRadius = planet.getRadius() + 600.0f;
            orbitDays = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
            loc = new BaseThemeGenerator.EntityLocation();
            loc.orbit = Global.getFactory().createCircularOrbitPointingDown(planet, random.nextFloat() * 360.0f, orbitRadius, orbitDays);
            added = BaseThemeGenerator.addEntity(null, (LocationAPI)system, loc, "equipment_cache", "neutral");
            added.entity.setName("\u6d4b\u8bd5\u866b\u6d1e\u85cf\u533f\u70b9");
            CargoAPI testCargo = Global.getFactory().createCargo(true);
            WormholeManager.WormholeItemData itemData = new WormholeManager.WormholeItemData("standard", "bravo", "Bravo");
            item = new SpecialItemData("wormhole_anchor", itemData.toJsonStr());
            testCargo.addItems(CargoAPI.CargoItemType.SPECIAL, item, 1.0f);
            itemData = new WormholeManager.WormholeItemData("standard", "sierra", "Sierra");
            item = new SpecialItemData("wormhole_anchor", itemData.toJsonStr());
            testCargo.addItems(CargoAPI.CargoItemType.SPECIAL, item, 1.0f);
            item = new SpecialItemData("wormhole_scanner", null);
            testCargo.addItems(CargoAPI.CargoItemType.SPECIAL, item, 1.0f);
            BaseSalvageSpecial.addExtraSalvage(added.entity, testCargo);
        }
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

