/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.combat.CombatReadinessPlugin;
import com.fs.starfarer.api.combat.FighterLaunchBayAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.combat.LowCRShipDamageSequence;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRPluginImpl
implements CombatReadinessPlugin {
    public static float NO_SYSTEM_THRESHOLD = 0.0f;
    public static float IMPROVE_START = 0.7f;
    public static float DEGRADE_START = 0.5f;
    public static float SHIELD_MALFUNCTION_START = 0.1f;
    public static float CRITICAL_MALFUNCTION_START = 0.2f;
    public static float MALFUNCTION_START = 0.4f;
    public static float MISSILE_AMMO_REDUCTION_START = 0.4f;
    public static float MAX_MOVEMENT_CHANGE = 10.0f;
    public static float MAX_DAMAGE_TAKEN_CHANGE = 10.0f;
    public static float MAX_DAMAGE_CHANGE = 10.0f;
    public static float MAX_REFIT_CHANGE = 10.0f;
    public static float MAX_SHIELD_MALFUNCTION_CHANCE = 5.0f;
    public static float MAX_CRITICAL_MALFUNCTION_CHANCE = 25.0f;
    public static float MAX_ENGINE_MALFUNCTION_CHANCE = 7.5f;
    public static float MAX_WEAPON_MALFUNCTION_CHANCE = 10.0f;
    protected static Object[] statusKeys = new Object[]{new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object()};

    @Override
    public void applyMaxCRCrewModifiers(FleetMemberAPI member) {
        if (member == null || member.getStats() == null) {
            return;
        }
        float maxCRBasedOnLevel = 0.7f;
        member.getStats().getMaxCombatReadiness().modifyFlat("\u8239\u5458\u80fd\u529b\u589e\u76ca", maxCRBasedOnLevel, "\u57fa\u7840\u6218\u5907");
        float cf = member.getCrewFraction();
        if (cf < 1.0f) {
            float penalty = 0.5f * (1.0f - cf);
            member.getStats().getMaxCombatReadiness().modifyFlat("\u8239\u5458\u80fd\u529b\u4e0d\u8db3", -penalty, "\u8239\u5458\u4e0d\u8db3");
        } else {
            member.getStats().getMaxCombatReadiness().unmodifyFlat("\u8239\u5458\u80fd\u529b\u4e0d\u8db3");
        }
    }

    @Override
    public List<CombatReadinessPlugin.CRStatusItemData> getCRStatusDataForShip(ShipAPI ship) {
        CombatReadinessPlugin.CRStatusItemData itemData;
        CombatReadinessPlugin.CRStatusItemData itemData2;
        float startingCR = ship.getCRAtDeployment();
        float cr = ship.getCurrentCR();
        ArrayList<CombatReadinessPlugin.CRStatusItemData> list = new ArrayList<CombatReadinessPlugin.CRStatusItemData>();
        String icon = null;
        icon = cr > this.getImproveThreshold(ship.getMutableStats()) ? Global.getSettings().getSpriteName("ui", "icon_tactical_cr_bonus") : (cr < this.getDegradeThreshold(ship.getMutableStats()) ? Global.getSettings().getSpriteName("ui", "icon_tactical_cr_penalty") : Global.getSettings().getSpriteName("ui", "icon_tactical_cr_neutral"));
        String title = "\u6218\u5907\u503c " + Math.round(cr * 100.0f) + "%";
        String malfStr = this.getMalfunctionString(ship.getMutableStats(), cr);
        if (cr <= NO_SYSTEM_THRESHOLD && ship.getShield() != null) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[9], icon, title, "\u62a4\u76fe\u79bb\u7ebf", true);
            list.add(itemData2);
        }
        if (cr <= NO_SYSTEM_THRESHOLD) {
            boolean hasWings = false;
            for (FighterLaunchBayAPI bay : ship.getLaunchBaysCopy()) {
                if (bay.getWing() == null) continue;
                hasWings = true;
                break;
            }
            if (hasWings) {
                itemData = new CombatReadinessPlugin.CRStatusItemData(statusKeys[10], icon, title, "\u98de\u884c\u7532\u677f\u79bb\u7ebf", true);
                list.add(itemData);
            }
        }
        if (cr <= NO_SYSTEM_THRESHOLD && ship.getPhaseCloak() != null) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[8], icon, title, String.valueOf(ship.getPhaseCloak().getDisplayName()) + " \u79bb\u7ebf", true);
            list.add(itemData2);
        }
        if (cr <= NO_SYSTEM_THRESHOLD && ship.getSystem() != null) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[7], icon, title, String.valueOf(ship.getSystem().getDisplayName()) + " \u79bb\u7ebf", true);
            list.add(itemData2);
        }
        if (cr < this.getMalfunctionThreshold(ship.getMutableStats())) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[0], icon, title, "\u6545\u969c\u98ce\u9669\uff1a" + malfStr, true);
            list.add(itemData2);
        }
        if (startingCR < this.getMissileAmmoReductionThreshold(ship.getMutableStats())) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[2], icon, title, "\u5bfc\u5f39\u65e0\u6cd5\u987a\u5229\u88c5\u586b", true);
            list.add(itemData2);
        }
        if (cr < this.getDegradeThreshold(ship.getMutableStats())) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[3], icon, title, "\u6027\u80fd\u4e0b\u964d", true);
            list.add(itemData2);
        } else if (cr > this.getImproveThreshold(ship.getMutableStats())) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[4], icon, title, "\u6027\u80fd\u63d0\u9ad8", false);
            list.add(itemData2);
        } else {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[8], icon, title, "\u6807\u51c6\u6027\u80fd", false);
            list.add(itemData2);
        }
        if (ship.losesCRDuringCombat() && cr > 0.0f) {
            float noLossTime = ship.getMutableStats().getPeakCRDuration().computeEffective(ship.getHullSpec().getNoCRLossTime());
            if (noLossTime > ship.getTimeDeployedForCRReduction()) {
                itemData = new CombatReadinessPlugin.CRStatusItemData(statusKeys[5], icon, "\u5cf0\u503c\u65f6\u95f4", "\u5269\u4f59\u65f6\u95f4\uff1a" + (int)(noLossTime - ship.getTimeDeployedForCRReduction()) + " \u79d2", false);
                list.add(itemData);
            } else {
                itemData = new CombatReadinessPlugin.CRStatusItemData(statusKeys[6], icon, "\u4f5c\u6218\u538b\u529b", " [\u8b66\u544a] \u8d85\u51fa\u5cf0\u503c\u4e0a\u9650", true);
                list.add(itemData);
            }
        }
        return list;
    }

    private float getWeaponMalfuctionPercent(MutableShipStatsAPI stats, float cr) {
        return MAX_WEAPON_MALFUNCTION_CHANCE * (this.getMalfunctionThreshold(stats) - cr) / this.getMalfunctionThreshold(stats);
    }

    private float getEngineMalfuctionPercent(MutableShipStatsAPI stats, float cr) {
        return MAX_ENGINE_MALFUNCTION_CHANCE * (this.getMalfunctionThreshold(stats) - cr) / this.getMalfunctionThreshold(stats);
    }

    private float getCriticalMalfuctionPercent(MutableShipStatsAPI stats, float cr) {
        return MAX_CRITICAL_MALFUNCTION_CHANCE * (this.getCriticalMalfunctionThreshold(stats) - cr) / this.getCriticalMalfunctionThreshold(stats);
    }

    private float getShieldMalfuctionPercent(MutableShipStatsAPI stats, float cr) {
        return MAX_SHIELD_MALFUNCTION_CHANCE * (this.getShieldMalfunctionThreshold(stats) - cr) / this.getShieldMalfunctionThreshold(stats);
    }

    private float getMovementChangePercent(MutableShipStatsAPI stats, float cr) {
        float movementChange = 0.0f;
        float d = this.getDegradeThreshold(stats);
        float i = this.getImproveThreshold(stats);
        if (cr < d) {
            float f = (d - cr) / d;
            movementChange = -1.0f * f * MAX_MOVEMENT_CHANGE;
        } else if (cr > i) {
            float f = (cr - i) / (1.0f - i);
            movementChange = 1.0f * f * MAX_MOVEMENT_CHANGE;
        }
        return movementChange;
    }

    private float getDamageTakenChangePercent(MutableShipStatsAPI stats, float cr) {
        float damageTakenChange = 0.0f;
        float d = this.getDegradeThreshold(stats);
        float i = this.getImproveThreshold(stats);
        if (cr < d) {
            float f = (d - cr) / d;
            damageTakenChange = 1.0f * f * MAX_DAMAGE_TAKEN_CHANGE;
        } else if (cr > i) {
            float f = (cr - i) / (1.0f - i);
            damageTakenChange = -1.0f * f * MAX_DAMAGE_TAKEN_CHANGE;
        }
        return damageTakenChange;
    }

    private float getRefitTimeChangePercent(MutableShipStatsAPI stats, float cr) {
        float refitTimeChange = 0.0f;
        float d = this.getDegradeThreshold(stats);
        float i = this.getImproveThreshold(stats);
        if (cr < d) {
            float f = (d - cr) / d;
            refitTimeChange = 1.0f * f * MAX_REFIT_CHANGE;
        } else if (cr > i) {
            float f = (cr - i) / (1.0f - i);
            refitTimeChange = -1.0f * f * MAX_REFIT_CHANGE;
        }
        return refitTimeChange;
    }

    private float getDamageChangePercent(MutableShipStatsAPI stats, float cr) {
        float damageChange = 0.0f;
        float d = this.getDegradeThreshold(stats);
        float i = this.getImproveThreshold(stats);
        if (cr < d) {
            float f = (d - cr) / d;
            damageChange = -1.0f * f * MAX_DAMAGE_CHANGE;
        } else if (cr > i) {
            float f = (cr - i) / (1.0f - i);
            damageChange = 1.0f * f * MAX_DAMAGE_CHANGE;
        }
        return damageChange;
    }

    private float getAimAccuracy(float cr) {
        return cr * 1.5f - 0.5f;
    }

    @Override
    public void applyCRToStats(float cr, MutableShipStatsAPI stats, ShipAPI.HullSize hullSize) {
        boolean fighter;
        String id = "cr_effect";
        boolean bl = fighter = hullSize == ShipAPI.HullSize.FIGHTER;
        if (!fighter) {
            if (cr < this.getMalfunctionThreshold(stats)) {
                stats.getWeaponMalfunctionChance().modifyFlat(id, 0.01f * this.getWeaponMalfuctionPercent(stats, cr));
                stats.getEngineMalfunctionChance().modifyFlat(id, 0.01f * this.getEngineMalfuctionPercent(stats, cr));
            } else {
                stats.getWeaponMalfunctionChance().unmodify(id);
                stats.getEngineMalfunctionChance().unmodify(id);
            }
        }
        if (!fighter) {
            if (cr < this.getCriticalMalfunctionThreshold(stats)) {
                stats.getCriticalMalfunctionChance().modifyFlat(id, 0.01f * this.getCriticalMalfuctionPercent(stats, cr));
            } else {
                stats.getCriticalMalfunctionChance().unmodify(id);
            }
        }
        if (!fighter) {
            if (cr < this.getShieldMalfunctionThreshold(stats)) {
                stats.getShieldMalfunctionChance().modifyFlat(id, 0.01f * this.getShieldMalfuctionPercent(stats, cr));
                stats.getShieldMalfunctionFluxLevel().modifyFlat(id, 0.75f);
            } else {
                stats.getShieldMalfunctionChance().unmodify(id);
                stats.getShieldMalfunctionFluxLevel().unmodify(id);
            }
        }
        if (!fighter && stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (cr <= NO_SYSTEM_THRESHOLD) {
                ship.setShipSystemDisabled(true);
                ship.setDefenseDisabled(true);
            } else {
                ship.setShipSystemDisabled(false);
                ship.setDefenseDisabled(false);
            }
        }
        float movementChange = this.getMovementChangePercent(stats, cr);
        float damageTakenChange = this.getDamageTakenChangePercent(stats, cr);
        float damageChange = this.getDamageChangePercent(stats, cr);
        float refitTimeChange = this.getRefitTimeChangePercent(stats, cr);
        if (refitTimeChange != 0.0f) {
            stats.getFighterRefitTimeMult().modifyPercent(id, refitTimeChange);
        } else {
            stats.getFighterRefitTimeMult().unmodify(id);
        }
        if (movementChange != 0.0f) {
            stats.getMaxSpeed().modifyPercent(id, movementChange);
            stats.getAcceleration().modifyPercent(id, movementChange);
            stats.getDeceleration().modifyPercent(id, movementChange);
            stats.getTurnAcceleration().modifyPercent(id, movementChange);
            stats.getMaxTurnRate().modifyPercent(id, movementChange);
        } else {
            stats.getMaxSpeed().unmodify(id);
            stats.getAcceleration().unmodify(id);
            stats.getDeceleration().unmodify(id);
            stats.getTurnAcceleration().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
        }
        if (damageTakenChange != 0.0f) {
            stats.getArmorDamageTakenMult().modifyPercent(id, damageTakenChange);
            stats.getHullDamageTakenMult().modifyPercent(id, damageTakenChange);
            stats.getShieldDamageTakenMult().modifyPercent(id, damageTakenChange);
        } else {
            stats.getArmorDamageTakenMult().unmodify(id);
            stats.getHullDamageTakenMult().unmodify(id);
            stats.getShieldDamageTakenMult().unmodify(id);
        }
        if (damageChange != 0.0f) {
            stats.getBallisticWeaponDamageMult().modifyPercent(id, damageChange);
            stats.getEnergyWeaponDamageMult().modifyPercent(id, damageChange);
            stats.getMissileWeaponDamageMult().modifyPercent(id, damageChange);
        } else {
            stats.getBallisticWeaponDamageMult().unmodify(id);
            stats.getEnergyWeaponDamageMult().unmodify(id);
            stats.getMissileWeaponDamageMult().unmodify(id);
        }
        float aimAccuracy = this.getAimAccuracy(cr);
        stats.getAutofireAimAccuracy().modifyFlat(id, aimAccuracy);
    }

    @Override
    public void applyCRToShip(float cr, ShipAPI ship) {
        if (!ship.isFighter() && cr < this.getMissileAmmoReductionThreshold(ship.getMutableStats())) {
            for (WeaponAPI weapon : ship.getAllWeapons()) {
                if (weapon.getType() != WeaponAPI.WeaponType.MISSILE) continue;
                float ammo = (float)weapon.getMaxAmmo() * this.getMissileLoadedFraction(ship.getMutableStats(), cr);
                if (ammo < 0.0f) {
                    ammo = 0.0f;
                }
                weapon.setAmmo(Math.round(ammo));
            }
        }
        ship.setCRAtDeployment(cr);
        float c = this.getCriticalMalfunctionThreshold(ship.getMutableStats());
        if (cr < c && !ship.controlsLocked() && !ship.isFighter()) {
            float severity = (c - cr) / c;
            if (Global.getCombatEngine() != null) {
                float criticalMult = 1.0f;
                for (MutableStat.StatMod mod : ship.getMutableStats().getCriticalMalfunctionChance().getMultMods().values()) {
                    criticalMult *= mod.getValue();
                }
                Global.getCombatEngine().addPlugin(new LowCRShipDamageSequence(ship, severity *= criticalMult));
            }
        }
    }

    @Override
    public float getMissileLoadedFraction(MutableShipStatsAPI stats, float cr) {
        return 1.0f;
    }

    @Override
    public float getMalfunctionThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return MALFUNCTION_START * mult - 0.001f;
    }

    @Override
    public float getCriticalMalfunctionThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return CRITICAL_MALFUNCTION_START * mult - 0.001f;
    }

    public float getShieldMalfunctionThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return SHIELD_MALFUNCTION_START * mult;
    }

    public float getMissileAmmoReductionThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return MISSILE_AMMO_REDUCTION_START * mult - 0.001f;
    }

    public float getDegradeThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return DEGRADE_START * mult;
    }

    public float getImproveThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        return IMPROVE_START * mult;
    }

    @Override
    public CombatReadinessPlugin.CREffectDescriptionForTooltip getCREffectDescription(float cr, String shipOrWing, FleetMemberAPI member) {
        CombatReadinessPlugin.CREffectDescriptionForTooltip result = new CombatReadinessPlugin.CREffectDescriptionForTooltip();
        List<CombatReadinessPlugin.CREffectDetail> details = this.getCREffectDetails(cr, member);
        boolean hasPositive = false;
        boolean hasNegative = false;
        for (CombatReadinessPlugin.CREffectDetail detail : details) {
            if (detail.getType() == CombatReadinessPlugin.CREffectDetailType.BONUS) {
                hasPositive = true;
            }
            if (detail.getType() != CombatReadinessPlugin.CREffectDetailType.PENALTY) continue;
            hasNegative = true;
        }
        float noDeploy = Global.getSettings().getFloat("noDeployCRPercent") * 0.01f;
        String crStr = String.valueOf((int)(cr * 100.0f)) + "%";
        String str = cr < noDeploy ? String.format("\u56e0\u8be5\u8230\u6ca1\u6709\u8db3\u591f\u7684\u6218\u5907\u503c (CR)\u3002\u6240\u4ee5\u65e0\u6cd5\u5728\u6218\u6597\u4e2d\u90e8\u7f72\u3002", shipOrWing) : (cr < this.getCriticalMalfunctionThreshold(member.getStats()) ? String.format("\u8be5\u8230\u6027\u80fd\u5df2\u4e25\u91cd\u53d7\u635f\uff0c\u5982\u679c\u90e8\u7f72\u5728\u6218\u6597\u4e2d\u53ef\u80fd\u4f1a\u5bfc\u81f4\u6b66\u5668\u548c\u5f15\u64ce\u4e0d\u53ef\u4fee\u590d\u5730\u635f\u574f\u3002", shipOrWing) : (cr < this.getMalfunctionThreshold(member.getStats()) ? String.format("\u8be5\u8230\u6027\u80fd\u5df2\u5927\u5e45\u4e0b\u964d\uff0c\u540c\u65f6\u4f34\u6709\u6b66\u5668\u548c\u5f15\u64ce\u968f\u65f6\u5b95\u673a\u7684\u98ce\u9669\u3002", shipOrWing) : (cr < this.getDegradeThreshold(member.getStats()) && hasNegative ? String.format("\u8be5\u8230\u8fd8\u6ca1\u6709\u51c6\u5907\u597d\uff0c\u5f3a\u5236\u51fa\u51fb\u5c06\u4f1a\u4f7f\u5b83\u65e0\u6cd5\u5168\u529b\u4f5c\u6218\u3002", shipOrWing) : (cr < this.getImproveThreshold(member.getStats()) || !hasPositive ? String.format("\u8be5\u8230\u5f53\u524d\u62e5\u6709\u6807\u51c6\u7684\u6218\u6597\u6027\u80fd\u3002", shipOrWing) : String.format("\u8be5\u8230\u76ee\u524d\u72b6\u6001\u826f\u597d\uff0c\u53ef\u8ba9\u4e00\u4e9b\u7cfb\u7edf\u77ed\u65f6\u8d85\u8f7d\u6765\u63d0\u5347\u6027\u80fd\u3002", shipOrWing)))));
        if (member.isFighterWing()) {
            boolean canReplaceFighters = false;
            FleetDataAPI data = member.getFleetData();
            if (data != null) {
                for (FleetMemberAPI curr : data.getMembersListCopy()) {
                    if (curr.isMothballed() || curr.getNumFlightDecks() <= 0) continue;
                    canReplaceFighters = true;
                    break;
                }
            }
            if (canReplaceFighters) {
                details.add(new CombatReadinessPlugin.CREffectDetail("", "", CombatReadinessPlugin.CREffectDetailType.NEUTRAL));
                float costPer = member.getStats().getCRPerDeploymentPercent().computeEffective(member.getVariant().getHullSpec().getCRToDeploy()) / 100.0f;
                String numStr = "" + (int)Math.ceil((float)((int)(cr * 100.0f)) / (costPer * 100.0f));
                str = String.valueOf(str) + " " + numStr + " \u51c6\u5907\u5907\u7528\u6218\u6597\u673a\uff0c\u4ee5\u66ff\u6362\u6218\u6597\u4e2d\u7684\u635f\u5931\u3002";
                result.getHighlights().add(numStr);
            } else {
                details.add(new CombatReadinessPlugin.CREffectDetail("\u66f4\u6362\u6218\u673a", "\u65e0", CombatReadinessPlugin.CREffectDetailType.PENALTY));
                str = String.valueOf(str) + " \u7531\u4e8e\u6218\u8230\u7f3a\u4e4f\u76f8\u5173\u8bbe\u65bd (\u5982\u98de\u884c\u7532\u677f ) \u6218\u673a\u7684\u635f\u5931\u5c06\u65e0\u6cd5\u5f97\u5230\u8865\u7ed9\u3002";
            }
        }
        result.setString(str);
        return result;
    }

    private String getMalfunctionString(MutableShipStatsAPI stats, float cr) {
        String malfStr = "\u65e0";
        if (cr < this.getCriticalMalfunctionThreshold(stats)) {
            malfStr = "\u6781\u9ad8";
        } else if (cr < 0.3f) {
            malfStr = "\u8f83\u9ad8";
        } else if (cr < this.getMalfunctionThreshold(stats)) {
            malfStr = "\u8f83\u4f4e";
        }
        return malfStr;
    }

    @Override
    public List<CombatReadinessPlugin.CREffectDetail> getCREffectDetails(float cr, FleetMemberAPI member) {
        CombatReadinessPlugin.CREffectDetailType accType;
        String accString;
        ArrayList<CombatReadinessPlugin.CREffectDetail> result = new ArrayList<CombatReadinessPlugin.CREffectDetail>();
        int engine = (int)this.getEngineMalfuctionPercent(member.getStats(), cr);
        int weapon = (int)this.getWeaponMalfuctionPercent(member.getStats(), cr);
        int speed = Math.round(this.getMovementChangePercent(member.getStats(), cr));
        int damage = Math.round(this.getDamageTakenChangePercent(member.getStats(), cr));
        int damageDealt = Math.round(this.getDamageChangePercent(member.getStats(), cr));
        int refit = Math.round(this.getRefitTimeChangePercent(member.getStats(), cr));
        float acc = this.getAimAccuracy(cr);
        String malfStr = this.getMalfunctionString(member.getStats(), cr);
        if (acc < 0.0f) {
            accString = "\u5f88\u5dee";
            accType = CombatReadinessPlugin.CREffectDetailType.PENALTY;
        } else if (acc < 0.25f) {
            accString = "\u5dee";
            accType = CombatReadinessPlugin.CREffectDetailType.PENALTY;
        } else if ((double)acc < 0.67) {
            accString = "\u6807\u51c6";
            accType = CombatReadinessPlugin.CREffectDetailType.NEUTRAL;
        } else {
            accString = "\u4f18\u79c0";
            accType = CombatReadinessPlugin.CREffectDetailType.BONUS;
        }
        String speedStr = String.valueOf(speed) + "%";
        if (speed >= 0) {
            speedStr = "+" + speedStr;
        }
        String damageStr = String.valueOf(damage) + "%";
        if (damage >= 0) {
            damageStr = "+" + damageStr;
        }
        String rofStr = String.valueOf(damageDealt) + "%";
        if (damageDealt >= 0) {
            rofStr = "+" + rofStr;
        }
        String refitStr = String.valueOf(refit) + "%";
        if (refit >= 0) {
            refitStr = "+" + refitStr;
        }
        result.add(new CombatReadinessPlugin.CREffectDetail("\u6700\u9ad8\u822a\u901f & \u673a\u52a8\u6027", speedStr, this.getTypeFor(speed, false)));
        result.add(new CombatReadinessPlugin.CREffectDetail("\u6240\u53d7\u4f24\u5bb3", damageStr, this.getTypeFor(damage, true)));
        result.add(new CombatReadinessPlugin.CREffectDetail("\u4f24\u5bb3\u52a0\u6210", rofStr, this.getTypeFor(damageDealt, false)));
        if (member.getNumFlightDecks() > 0) {
            result.add(new CombatReadinessPlugin.CREffectDetail("\u6218\u673a\u6574\u5907\u65f6\u95f4", refitStr, this.getTypeFor(refit, true)));
        }
        result.add(new CombatReadinessPlugin.CREffectDetail("\u81ea\u52a8\u5f00\u706b\u7cbe\u51c6\u5ea6", accString, accType));
        CombatReadinessPlugin.CREffectDetailType malfType = CombatReadinessPlugin.CREffectDetailType.NEUTRAL;
        if (this.getWeaponMalfuctionPercent(member.getStats(), cr) > 0.0f) {
            malfType = CombatReadinessPlugin.CREffectDetailType.PENALTY;
        }
        result.add(new CombatReadinessPlugin.CREffectDetail("\u6545\u969c\u98ce\u9669", malfStr, malfType));
        Collection<String> slots = member.getVariant().getFittedWeaponSlots();
        boolean hasMissiles = false;
        for (String slotId : slots) {
            WeaponSpecAPI w = member.getVariant().getWeaponSpec(slotId);
            if (w.getType() != WeaponAPI.WeaponType.MISSILE) continue;
            hasMissiles = true;
            break;
        }
        if (hasMissiles) {
            float missileFraction = this.getMissileLoadedFraction(member.getStats(), cr);
            if (missileFraction < 0.0f) {
                missileFraction = 0.0f;
            }
            String missileStr = String.valueOf((int)(missileFraction * 100.0f)) + "%";
            if (missileFraction < 1.0f) {
                result.add(new CombatReadinessPlugin.CREffectDetail("\u5bfc\u5f39\u5907\u5f39\u6570", missileStr, missileFraction < 1.0f ? CombatReadinessPlugin.CREffectDetailType.PENALTY : CombatReadinessPlugin.CREffectDetailType.NEUTRAL));
            }
        }
        return result;
    }

    private CombatReadinessPlugin.CREffectDetailType getTypeFor(int val, boolean invert) {
        if (invert) {
            if (val < 0) {
                return CombatReadinessPlugin.CREffectDetailType.BONUS;
            }
            if (val > 0) {
                return CombatReadinessPlugin.CREffectDetailType.PENALTY;
            }
            return CombatReadinessPlugin.CREffectDetailType.NEUTRAL;
        }
        if (val > 0) {
            return CombatReadinessPlugin.CREffectDetailType.BONUS;
        }
        if (val < 0) {
            return CombatReadinessPlugin.CREffectDetailType.PENALTY;
        }
        return CombatReadinessPlugin.CREffectDetailType.NEUTRAL;
    }

    @Override
    public boolean isOkToPermanentlyDisable(ShipAPI ship, Object module) {
        return CRPluginImpl.isOkToPermanentlyDisableStatic(ship, module);
    }

    public static boolean isOkToPermanentlyDisableStatic(ShipAPI ship, Object module) {
        if (module instanceof ShipEngineControllerAPI.ShipEngineAPI) {
            float fractionIfDisabled = ((ShipEngineControllerAPI.ShipEngineAPI)module).getContribution() + ship.getEngineFractionPermanentlyDisabled();
            return !(fractionIfDisabled > 0.66f);
        }
        if (module instanceof WeaponAPI) {
            WeaponAPI.WeaponType type = ((WeaponAPI)module).getType();
            if (type == WeaponAPI.WeaponType.DECORATIVE || type == WeaponAPI.WeaponType.LAUNCH_BAY || type == WeaponAPI.WeaponType.SYSTEM) {
                return false;
            }
            if (ship.getCurrentCR() <= 0.0f) {
                return true;
            }
            ArrayList<WeaponAPI> usableWeapons = new ArrayList<WeaponAPI>();
            for (WeaponAPI weapon : ship.getAllWeapons()) {
                if (weapon.isPermanentlyDisabled() || weapon.isDecorative() || weapon.getSlot().isSystemSlot() || weapon.getSlot().isDecorative() || weapon.getSlot().isStationModule() || weapon.getAmmo() <= 0 || weapon.getMaxAmmo() <= 20 && !(weapon.getSpec().getAmmoPerSecond() > 0.0f)) continue;
                usableWeapons.add(weapon);
            }
            usableWeapons.remove(module);
            return usableWeapons.size() >= 1;
        }
        return false;
    }
}

