/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;
import java.util.EnumSet;

public class DamperFieldOmegaStats
extends BaseShipSystemScript {
    public static Object KEY_SHIP = new Object();
    public static float INCOMING_DAMAGE_MULT = 0.5f;
    public static float FLUX_USE_MULT = 0.5f;
    public static float REPAIR_RATE_MULT = 10.0f;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        ship.fadeToColor(KEY_SHIP, new Color(75, 75, 75, 255), 0.1f, 0.1f, effectLevel);
        ship.setWeaponGlow(effectLevel, new Color(100, 165, 255, 255), EnumSet.of(WeaponAPI.WeaponType.BALLISTIC, WeaponAPI.WeaponType.ENERGY, WeaponAPI.WeaponType.MISSILE));
        ship.getEngineController().fadeToOtherColor(KEY_SHIP, new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), effectLevel, 0.75f * effectLevel);
        ship.setJitterUnder(KEY_SHIP, new Color(100, 165, 255, 255), effectLevel, 15, 0.0f, 15.0f);
        effectLevel = 1.0f;
        stats.getBallisticWeaponFluxCostMod().modifyMult(id, 1.0f - (1.0f - FLUX_USE_MULT) * effectLevel);
        stats.getEnergyWeaponFluxCostMod().modifyMult(id, 1.0f - (1.0f - FLUX_USE_MULT) * effectLevel);
        stats.getMissileWeaponFluxCostMod().modifyMult(id, 1.0f - (1.0f - FLUX_USE_MULT) * effectLevel);
        stats.getHullDamageTakenMult().modifyMult(id, 1.0f - (1.0f - INCOMING_DAMAGE_MULT) * effectLevel);
        stats.getArmorDamageTakenMult().modifyMult(id, 1.0f - (1.0f - INCOMING_DAMAGE_MULT) * effectLevel);
        stats.getEmpDamageTakenMult().modifyMult(id, 1.0f - (1.0f - INCOMING_DAMAGE_MULT) * effectLevel);
        stats.getCombatEngineRepairTimeMult().modifyMult(id, 1.0f / (1.0f + (REPAIR_RATE_MULT - 1.0f) * effectLevel));
        stats.getCombatWeaponRepairTimeMult().modifyMult(id, 1.0f / (1.0f + (REPAIR_RATE_MULT - 1.0f) * effectLevel));
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getBallisticWeaponFluxCostMod().unmodify(id);
        stats.getEnergyWeaponFluxCostMod().unmodify(id);
        stats.getMissileWeaponFluxCostMod().unmodify(id);
        stats.getHullDamageTakenMult().unmodify(id);
        stats.getArmorDamageTakenMult().unmodify(id);
        stats.getEmpDamageTakenMult().unmodify(id);
        stats.getCombatEngineRepairTimeMult().unmodifyMult(id);
        stats.getCombatWeaponRepairTimeMult().unmodifyMult(id);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        effectLevel = 1.0f;
        float percent = (1.0f - FLUX_USE_MULT) * effectLevel * 100.0f;
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData(String.valueOf((int)percent) + "% \u4ea7\u751f\u7684\u5e45\u80fd\u964d\u4f4e", false);
        }
        percent = (1.0f - INCOMING_DAMAGE_MULT) * effectLevel * 100.0f;
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData(String.valueOf((int)percent) + "% \u964d\u4f4e\u53d7\u5230\u7684\u4f24\u5bb3", false);
        }
        percent = REPAIR_RATE_MULT * effectLevel * 100.0f;
        if (index == 2) {
            return new ShipSystemStatsScript.StatusData(String.valueOf((int)percent) + "% faster repairs", false);
        }
        return null;
    }

    public static class TargetData {
        public ShipAPI target;

        public TargetData(ShipAPI target) {
            this.target = target;
        }
    }
}

