/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InterdictorArrayStats
extends BaseShipSystemScript {
    public static final Object SHIP_KEY = new Object();
    public static final Object TARGET_KEY = new Object();
    public static final float WING_EFFECT_RANGE = 200.0f;
    public static final float RANGE = 1000.0f;
    public static final Color EFFECT_COLOR = new Color(100, 165, 255, 75);

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        String targetDataKey = String.valueOf(ship.getId()) + "_interdictor_target_data";
        Object targetDataObj = Global.getCombatEngine().getCustomData().get(targetDataKey);
        if (state == ShipSystemStatsScript.State.IN && targetDataObj == null) {
            ShipAPI target = this.findTarget(ship);
            Global.getCombatEngine().getCustomData().put(targetDataKey, new TargetData(target));
        } else if (state == ShipSystemStatsScript.State.IDLE && targetDataObj != null) {
            Global.getCombatEngine().getCustomData().remove(targetDataKey);
        }
        if (targetDataObj == null || ((TargetData)targetDataObj).target == null) {
            return;
        }
        TargetData targetData = (TargetData)targetDataObj;
        ArrayList<ShipAPI> targets = new ArrayList<ShipAPI>();
        if (targetData.target.isFighter() || targetData.target.isDrone()) {
            CombatEngineAPI engine = Global.getCombatEngine();
            List<ShipAPI> ships = engine.getShips();
            for (ShipAPI other : ships) {
                float dist;
                if (other.isShuttlePod() || other.isHulk() || !other.isDrone() && !other.isFighter() || other.getOriginalOwner() != targetData.target.getOriginalOwner() || (dist = Misc.getDistance(other.getLocation(), targetData.target.getLocation())) > 200.0f) continue;
                targets.add(other);
            }
        } else {
            targets.add(targetData.target);
        }
        boolean first = true;
        for (ShipAPI target : targets) {
            if (effectLevel >= 1.0f) {
                Color color = this.getEffectColor(target);
                color = Misc.setAlpha(color, 255);
                if (first) {
                    if (target.getFluxTracker().showFloaty() || ship == Global.getCombatEngine().getPlayerShip() || target == Global.getCombatEngine().getPlayerShip()) {
                        target.getFluxTracker().showOverloadFloatyIfNeeded("\u9a71\u52a8\u963b\u65ad\uff01", color, 4.0f, true);
                    }
                    first = false;
                }
                ShipEngineControllerAPI ec = target.getEngineController();
                float limit = ec.getFlameoutFraction();
                if (target.isDrone() || target.isFighter()) {
                    limit = 1.0f;
                }
                float disabledSoFar = 0.0f;
                boolean disabledAnEngine = false;
                ArrayList<ShipEngineControllerAPI.ShipEngineAPI> engines = new ArrayList<ShipEngineControllerAPI.ShipEngineAPI>(ec.getShipEngines());
                Collections.shuffle(engines);
                for (ShipEngineControllerAPI.ShipEngineAPI engine : engines) {
                    float contrib;
                    if (engine.isDisabled() || !(disabledSoFar + (contrib = engine.getContribution()) <= limit)) continue;
                    engine.disable();
                    disabledSoFar += contrib;
                    disabledAnEngine = true;
                }
                if (!disabledAnEngine) {
                    for (ShipEngineControllerAPI.ShipEngineAPI engine : engines) {
                        if (engine.isDisabled()) continue;
                        engine.disable();
                        break;
                    }
                }
                ec.computeEffectiveStats(ship == Global.getCombatEngine().getPlayerShip());
            }
            if (!(effectLevel > 0.0f)) continue;
            float jitterLevel = effectLevel;
            float maxRangeBonus = 20.0f + target.getCollisionRadius() * 0.25f;
            float jitterRangeBonus = jitterLevel * maxRangeBonus;
            if (state == ShipSystemStatsScript.State.OUT) {
                jitterRangeBonus = maxRangeBonus + (1.0f - jitterLevel) * maxRangeBonus;
            }
            target.setJitter(this, this.getEffectColor(target), jitterLevel, 6, 0.0f, 0.0f + jitterRangeBonus);
            if (!first) continue;
            ship.setJitter(this, this.getEffectColor(targetData.target), jitterLevel, 6, 0.0f, 0.0f + jitterRangeBonus);
        }
    }

    protected Color getEffectColor(ShipAPI ship) {
        if (ship.getEngineController().getShipEngines().isEmpty()) {
            return EFFECT_COLOR;
        }
        return Misc.setAlpha(ship.getEngineController().getShipEngines().get(0).getEngineColor(), EFFECT_COLOR.getAlpha());
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    protected ShipAPI findTarget(ShipAPI ship) {
        Misc.FindShipFilter filter = new Misc.FindShipFilter(){

            public boolean matches(ShipAPI ship) {
                return !ship.getEngineController().isFlamedOut();
            }
        };
        float range = this.getMaxRange(ship);
        boolean player = ship == Global.getCombatEngine().getPlayerShip();
        ShipAPI target = ship.getShipTarget();
        if (target != null) {
            float radSum;
            float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
            if (dist > range + (radSum = ship.getCollisionRadius() + target.getCollisionRadius())) {
                target = null;
            }
        } else {
            if (target == null || target.getOwner() == ship.getOwner()) {
                if (player) {
                    target = Misc.findClosestShipEnemyOf(ship, ship.getMouseTarget(), ShipAPI.HullSize.FIGHTER, range, true, filter);
                } else {
                    Object test = ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
                    if (test instanceof ShipAPI) {
                        float radSum;
                        target = (ShipAPI)test;
                        float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
                        if (dist > range + (radSum = ship.getCollisionRadius() + target.getCollisionRadius())) {
                            target = null;
                        }
                    }
                }
            }
            if (target == null) {
                target = Misc.findClosestShipEnemyOf(ship, ship.getLocation(), ShipAPI.HullSize.FIGHTER, range, true, filter);
            }
        }
        return target;
    }

    protected float getMaxRange(ShipAPI ship) {
        return 1000.0f;
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        if (system.isOutOfAmmo()) {
            return null;
        }
        if (system.getState() != ShipSystemAPI.SystemState.IDLE) {
            return null;
        }
        ShipAPI target = this.findTarget(ship);
        if (target != null && target != ship) {
            return "\u5c31\u7eea";
        }
        if (target == null && ship.getShipTarget() != null) {
            return "\u8d85\u51fa\u8303\u56f4";
        }
        return "\u6ca1\u6709\u76ee\u6807";
    }

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        if (system.isActive()) {
            return true;
        }
        ShipAPI target = this.findTarget(ship);
        return target != null && target != ship;
    }

    public static class TargetData {
        public ShipAPI target;
        public float sinceLastAfterimage = 0.0f;
        public boolean lastAbove = false;

        public TargetData(ShipAPI target) {
            this.target = target;
        }
    }
}

