/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LidarArrayStats
extends BaseShipSystemScript {
    public static String LIDAR_WINDUP = "lidar_windup";
    public static Color WEAPON_GLOW = new Color(255, 50, 50, 155);
    public static float RANGE_BONUS = 100.0f;
    public static float PASSIVE_RANGE_BONUS = 25.0f;
    public static float ROF_BONUS = 2.0f;
    public static float RECOIL_BONUS = 75.0f;
    public static float PROJECTILE_SPEED_BONUS = 50.0f;
    protected List<LidarDishData> dishData = new ArrayList<LidarDishData>();
    protected boolean needsUnapply = false;
    protected boolean playedWindup = false;
    protected boolean inited = false;

    public void init(ShipAPI ship) {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.needsUnapply = true;
        int turnDir = 1;
        float index = 0.0f;
        float count = 0.0f;
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (!w.isDecorative() || !w.getSpec().hasTag("lidar")) continue;
            count += 1.0f;
        }
        ArrayList<WeaponAPI> lidar = new ArrayList<WeaponAPI>();
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (!w.isDecorative() || !w.getSpec().hasTag("lidar")) continue;
            lidar.add(w);
        }
        Collections.sort(lidar, new Comparator<WeaponAPI>(){

            @Override
            public int compare(WeaponAPI o1, WeaponAPI o2) {
                return (int)Math.signum(o1.getSlot().getLocation().x - o2.getSlot().getLocation().x);
            }
        });
        for (WeaponAPI w : lidar) {
            if (!w.isDecorative() || !w.getSpec().hasTag("lidar")) continue;
            w.setSuspendAutomaticTurning(true);
            LidarDishData data = new LidarDishData();
            data.turnDir = Math.signum(turnDir);
            data.turnRate = 0.5f;
            data.turnRate = 0.1f;
            data.w = w;
            data.angle = 0.0f;
            data.phase = index / count;
            data.count = count;
            this.dishData.add(data);
            turnDir = -turnDir;
            index += 1.0f;
        }
    }

    public void rotateLidarDishes(boolean active, float effectLevel) {
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        float turnRateMult = 1.0f;
        if (active) {
            turnRateMult = 20.0f;
        }
        for (LidarDishData data : this.dishData) {
            float arc = data.w.getArc();
            float useTurnDir = data.turnDir;
            if (active) {
                useTurnDir = Misc.getClosestTurnDirection(data.angle, 0.0f);
            }
            float delta = useTurnDir * amount * data.turnRate * turnRateMult * arc;
            if (active && effectLevel > 0.0f && Math.abs(data.angle) < Math.abs(delta * 1.5f)) {
                data.angle = 0.0f;
            } else {
                data.angle += delta;
                data.phase += 1.0f * amount;
                if (arc < 360.0f) {
                    if (data.angle > arc / 2.0f && data.turnDir > 0.0f) {
                        data.angle = arc / 2.0f;
                        data.turnDir = -1.0f;
                    }
                    if (data.angle < -arc / 2.0f && data.turnDir < 0.0f) {
                        data.angle = -arc / 2.0f;
                        data.turnDir = 1.0f;
                    }
                } else {
                    data.angle %= 360.0f;
                }
            }
            float facing = data.angle + data.w.getArcFacing() + data.w.getShip().getFacing();
            data.w.setFacing(facing);
            data.w.updateBeamFromPoints();
        }
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (ship == null || ship.isHulk()) {
            if (this.needsUnapply) {
                this.unmodify(id, stats);
                for (WeaponAPI w : ship.getAllWeapons()) {
                    if (w.isDecorative() || !w.getSlot().isHardpoint() || w.isBeam() || w.getType() != WeaponAPI.WeaponType.BALLISTIC && w.getType() != WeaponAPI.WeaponType.ENERGY) continue;
                    w.setGlowAmount(0.0f, null);
                }
                this.needsUnapply = false;
            }
            return;
        }
        this.init(ship);
        boolean active = state == ShipSystemStatsScript.State.IN || state == ShipSystemStatsScript.State.ACTIVE || state == ShipSystemStatsScript.State.OUT;
        this.rotateLidarDishes(active, effectLevel);
        if (active) {
            this.modify(id, stats, effectLevel);
            this.needsUnapply = true;
        } else if (this.needsUnapply) {
            this.unmodify(id, stats);
            for (WeaponAPI w : ship.getAllWeapons()) {
                if (w.getSlot().isSystemSlot() || w.isDecorative() || !w.getSlot().isHardpoint() || w.isBeam() || w.getType() != WeaponAPI.WeaponType.BALLISTIC && w.getType() != WeaponAPI.WeaponType.ENERGY) continue;
                w.setGlowAmount(0.0f, null);
            }
            this.needsUnapply = false;
        }
        if (!active) {
            return;
        }
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (w.getSlot().isSystemSlot() || w.getType() == WeaponAPI.WeaponType.MISSILE) continue;
            if (state == ShipSystemStatsScript.State.IN) {
                if (w.isDecorative() && w.getSpec().hasTag("lidar")) continue;
                w.setForceNoFireOneFrame(true);
                continue;
            }
            if (!w.isDecorative() && w.getSlot().isHardpoint() && !w.isBeam() && (w.getType() == WeaponAPI.WeaponType.BALLISTIC || w.getType() == WeaponAPI.WeaponType.ENERGY)) continue;
            w.setForceNoFireOneFrame(true);
        }
        Color glowColor = WEAPON_GLOW;
        float lidarRange = 500.0f;
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (w.isDecorative() || !w.getSlot().isHardpoint() || w.isBeam() || w.getType() != WeaponAPI.WeaponType.BALLISTIC && w.getType() != WeaponAPI.WeaponType.ENERGY) continue;
            lidarRange = Math.max(lidarRange, w.getRange());
            w.setGlowAmount(effectLevel, glowColor);
        }
        stats.getBeamWeaponRangeBonus().modifyFlat("lidararray", lidarRange += 100.0f);
        float fireThreshold = 0.07692308f;
        fireThreshold += 0.02f;
        for (LidarDishData data : this.dishData) {
            boolean skip = data.phase % 1.0f > 1.0f / data.count;
            skip = false;
            if (skip || !data.w.isDecorative() || !data.w.getSpec().hasTag("lidar") || state != ShipSystemStatsScript.State.IN || !(Math.abs(data.angle) < 5.0f) || !(effectLevel >= fireThreshold)) continue;
            data.w.setForceFireOneFrame(true);
        }
        if ((state == ShipSystemStatsScript.State.IN && effectLevel > 0.67f || state == ShipSystemStatsScript.State.ACTIVE) && !this.playedWindup) {
            Global.getSoundPlayer().playSound(LIDAR_WINDUP, 1.0f, 1.0f, ship.getLocation(), ship.getVelocity());
            this.playedWindup = true;
        }
    }

    protected void modify(String id, MutableShipStatsAPI stats, float effectLevel) {
        float mult = 1.0f + ROF_BONUS * effectLevel;
        stats.getBallisticWeaponRangeBonus().modifyPercent(id, RANGE_BONUS);
        stats.getEnergyWeaponRangeBonus().modifyPercent(id, RANGE_BONUS);
        stats.getBallisticRoFMult().modifyMult(id, mult);
        stats.getEnergyRoFMult().modifyMult(id, mult);
        stats.getMaxRecoilMult().modifyMult(id, 1.0f - 0.01f * RECOIL_BONUS);
        stats.getRecoilPerShotMult().modifyMult(id, 1.0f - 0.01f * RECOIL_BONUS);
        stats.getRecoilDecayMult().modifyMult(id, 1.0f - 0.01f * RECOIL_BONUS);
        stats.getBallisticProjectileSpeedMult().modifyPercent(id, PROJECTILE_SPEED_BONUS);
        stats.getEnergyProjectileSpeedMult().modifyPercent(id, PROJECTILE_SPEED_BONUS);
    }

    protected void unmodify(String id, MutableShipStatsAPI stats) {
        stats.getBallisticWeaponRangeBonus().modifyPercent(id, PASSIVE_RANGE_BONUS);
        stats.getEnergyWeaponRangeBonus().modifyPercent(id, PASSIVE_RANGE_BONUS);
        stats.getBallisticRoFMult().unmodifyMult(id);
        stats.getEnergyRoFMult().unmodifyMult(id);
        stats.getMaxRecoilMult().unmodifyMult(id);
        stats.getRecoilPerShotMult().unmodifyMult(id);
        stats.getRecoilDecayMult().unmodifyMult(id);
        stats.getBallisticProjectileSpeedMult().unmodifyPercent(id);
        stats.getEnergyProjectileSpeedMult().unmodifyPercent(id);
        this.playedWindup = false;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if ((state == ShipSystemStatsScript.State.IDLE || state == ShipSystemStatsScript.State.COOLDOWN) && index == 3) {
            return new ShipSystemStatsScript.StatusData("\u6b66\u5668\u5c04\u7a0b +" + (int)PASSIVE_RANGE_BONUS + "%", false);
        }
        if (effectLevel <= 0.0f) {
            return null;
        }
        float mult = 1.0f + ROF_BONUS;
        float bonusPercent = (int)((mult - 1.0f) * 100.0f);
        if (index == 3) {
            return new ShipSystemStatsScript.StatusData("\u6b66\u5668\u5c04\u7a0b +" + (int)RANGE_BONUS + "%", false);
        }
        if (index == 2) {
            return new ShipSystemStatsScript.StatusData("\u6b66\u5668\u5c04\u901f +" + (int)bonusPercent + "%", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("\u6b66\u5668\u540e\u5750\u529b -" + (int)RECOIL_BONUS + "%", false);
        }
        if (index == 0 && PROJECTILE_SPEED_BONUS > 0.0f) {
            return new ShipSystemStatsScript.StatusData("\u5f39\u4f53\u98de\u884c\u901f\u7387 +" + (int)PROJECTILE_SPEED_BONUS + "%", false);
        }
        return null;
    }

    public String getDisplayNameOverride(ShipSystemStatsScript.State state, float effectLevel) {
        if (state == ShipSystemStatsScript.State.IDLE || state == ShipSystemStatsScript.State.COOLDOWN) {
            return "\u6fc0\u5149\u96f7\u8fbe\u9635\u5217 - \u534a\u529f\u7387";
        }
        return null;
    }

    public static class LidarDishData {
        public float turnDir;
        public float turnRate;
        public float angle;
        public float phase;
        public float count;
        public WeaponAPI w;
    }
}

