/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.combat.MoteAIScript;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MoteControlScript
extends BaseShipSystemScript {
    protected static float MAX_ATTRACTOR_RANGE = 3000.0f;
    public static float MAX_DIST_FROM_SOURCE_TO_ENGAGE_AS_PD = 2000.0f;
    public static float MAX_DIST_FROM_ATTRACTOR_TO_ENGAGE_AS_PD = 1000.0f;
    public static int MAX_MOTES = 30;
    public static int MAX_MOTES_HF = 50;
    public static float ANTI_FIGHTER_DAMAGE = 200.0f;
    public static float ANTI_FIGHTER_DAMAGE_HF = 1000.0f;
    public static float ATTRACTOR_DURATION_LOCK = 20.0f;
    public static float ATTRACTOR_DURATION = 10.0f;
    public static Map<String, MoteData> MOTE_DATA = new HashMap<String, MoteData>();
    public static String MOTELAUNCHER = "motelauncher";
    public static String MOTELAUNCHER_HF = "motelauncher_hf";
    protected IntervalUtil launchInterval = new IntervalUtil(0.75f, 1.25f);
    protected IntervalUtil attractorParticleInterval = new IntervalUtil(0.05f, 0.1f);
    protected WeightedRandomPicker<WeaponSlotAPI> launchSlots = new WeightedRandomPicker();
    protected WeaponSlotAPI attractor = null;
    protected boolean findNewTargetOnUse = true;

    static {
        MoteData normal = new MoteData();
        normal.jitterColor = new Color(100, 165, 255, 175);
        normal.empColor = new Color(100, 165, 255, 255);
        normal.maxMotes = MAX_MOTES;
        normal.antiFighterDamage = ANTI_FIGHTER_DAMAGE;
        normal.impactSound = "mote_attractor_impact_normal";
        normal.loopSound = "mote_attractor_loop";
        MOTE_DATA.put(MOTELAUNCHER, normal);
        MoteData hf = new MoteData();
        hf.jitterColor = new Color(255, 100, 255, 175);
        hf.empColor = new Color(255, 100, 255, 255);
        hf.maxMotes = MAX_MOTES_HF;
        hf.antiFighterDamage = ANTI_FIGHTER_DAMAGE_HF;
        hf.impactSound = "mote_attractor_impact_damage";
        hf.loopSound = "mote_attractor_loop_dark";
        MOTE_DATA.put(MOTELAUNCHER_HF, hf);
    }

    public static boolean isHighFrequency(ShipAPI ship) {
        return ship != null && ship.getVariant().hasHullMod("high_frequency_attractor");
    }

    public static String getWeaponId(ShipAPI ship) {
        if (MoteControlScript.isHighFrequency(ship)) {
            return MOTELAUNCHER_HF;
        }
        return MOTELAUNCHER;
    }

    public static float getAntiFighterDamage(ShipAPI ship) {
        return MoteControlScript.MOTE_DATA.get((Object)MoteControlScript.getWeaponId((ShipAPI)ship)).antiFighterDamage;
    }

    public static String getImpactSoundId(ShipAPI ship) {
        return MoteControlScript.MOTE_DATA.get((Object)MoteControlScript.getWeaponId((ShipAPI)ship)).impactSound;
    }

    public static Color getJitterColor(ShipAPI ship) {
        return MoteControlScript.MOTE_DATA.get((Object)MoteControlScript.getWeaponId((ShipAPI)ship)).jitterColor;
    }

    public static Color getEMPColor(ShipAPI ship) {
        return MoteControlScript.MOTE_DATA.get((Object)MoteControlScript.getWeaponId((ShipAPI)ship)).empColor;
    }

    public static int getMaxMotes(ShipAPI ship) {
        return MoteControlScript.MOTE_DATA.get((Object)MoteControlScript.getWeaponId((ShipAPI)ship)).maxMotes;
    }

    public static String getLoopSound(ShipAPI ship) {
        return MoteControlScript.MOTE_DATA.get((Object)MoteControlScript.getWeaponId((ShipAPI)ship)).loopSound;
    }

    public static SharedMoteAIData getSharedData(ShipAPI source) {
        String key = source + "_mote_AI_shared";
        SharedMoteAIData data = (SharedMoteAIData)Global.getCombatEngine().getCustomData().get(key);
        if (data == null) {
            data = new SharedMoteAIData();
            Global.getCombatEngine().getCustomData().put(key, data);
        }
        return data;
    }

    protected void findSlots(ShipAPI ship) {
        if (this.attractor != null) {
            return;
        }
        for (WeaponSlotAPI slot : ship.getHullSpec().getAllWeaponSlotsCopy()) {
            if (!slot.isSystemSlot()) continue;
            if (slot.getSlotSize() == WeaponAPI.WeaponSize.SMALL) {
                this.launchSlots.add(slot);
            }
            if (slot.getSlotSize() != WeaponAPI.WeaponSize.MEDIUM) continue;
            this.attractor = slot;
        }
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        SharedMoteAIData data = MoteControlScript.getSharedData(ship);
        data.elapsed += amount;
        if (data.attractorRemaining > 0.0f) {
            data.attractorRemaining -= amount;
            if (data.attractorRemaining <= 0.0f || data.attractorLock != null && !data.attractorLock.isAlive() || data.motes.isEmpty()) {
                data.attractorTarget = null;
                data.attractorLock = null;
                data.attractorRemaining = 0.0f;
            }
        }
        if (effectLevel <= 0.0f) {
            this.findNewTargetOnUse = true;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        this.attractorParticleInterval.advance(amount);
        if (this.attractorParticleInterval.intervalElapsed()) {
            this.spawnAttractorParticles(ship);
        }
        this.launchInterval.advance(amount * 5.0f);
        if (this.launchInterval.intervalElapsed()) {
            Iterator<MissileAPI> iter = data.motes.iterator();
            while (iter.hasNext()) {
                if (engine.isMissileAlive(iter.next())) continue;
                iter.remove();
            }
            if (ship.isHulk()) {
                for (MissileAPI mote : data.motes) {
                    mote.flameOut();
                }
                data.motes.clear();
                return;
            }
            int maxMotes = MoteControlScript.getMaxMotes(ship);
            if (data.motes.size() < maxMotes && data.attractorLock == null && !ship.getFluxTracker().isOverloadedOrVenting()) {
                this.findSlots(ship);
                WeaponSlotAPI slot = this.launchSlots.pick();
                Vector2f loc = slot.computePosition(ship);
                float dir = slot.computeMidArcAngle(ship);
                float arc = slot.getArc();
                String weaponId = MoteControlScript.getWeaponId(ship);
                MissileAPI mote = (MissileAPI)engine.spawnProjectile(ship, null, weaponId, loc, dir += arc * (float)Math.random() - arc / 2.0f, null);
                mote.setWeaponSpec(weaponId);
                mote.setMissileAI(new MoteAIScript(mote));
                mote.getActiveLayers().remove((Object)CombatEngineLayers.FF_INDICATORS_LAYER);
                mote.setEmpResistance(10000);
                data.motes.add(mote);
                engine.spawnMuzzleFlashOrSmoke(ship, slot, mote.getWeaponSpec(), 0, dir);
                Global.getSoundPlayer().playSound("mote_attractor_launch_mote", 1.0f, 0.25f, loc, new Vector2f());
            }
        }
        float maxMotes = MoteControlScript.getMaxMotes(ship);
        float fraction = (float)data.motes.size() / Math.max(1.0f, maxMotes);
        float volume = fraction * 3.0f;
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        if (data.motes.size() > 3) {
            Vector2f com = new Vector2f();
            for (MissileAPI mote : data.motes) {
                Vector2f.add((Vector2f)com, (Vector2f)mote.getLocation(), (Vector2f)com);
            }
            com.scale(1.0f / (float)data.motes.size());
            Global.getSoundPlayer().playLoop(MoteControlScript.getLoopSound(ship), ship, 1.0f, volume, com, new Vector2f());
        }
        if (effectLevel > 0.0f && this.findNewTargetOnUse) {
            this.calculateTargetData(ship);
            this.findNewTargetOnUse = false;
        }
        if (effectLevel == 1.0f) {
            if (data.attractorTarget == null) {
                this.calculateTargetData(ship);
            }
            this.findSlots(ship);
            Vector2f slotLoc = this.attractor.computePosition(ship);
            CombatEntityAPI asteroid = engine.spawnAsteroid(0, data.attractorTarget.x, data.attractorTarget.y, 0.0f, 0.0f);
            asteroid.setCollisionClass(CollisionClass.NONE);
            CombatEntityAPI target = asteroid;
            if (data.attractorLock != null) {
                target = data.attractorLock;
            }
            float emp = 0.0f;
            float dam = 0.0f;
            EmpArcEntityAPI arc = engine.spawnEmpArc(ship, slotLoc, ship, target, DamageType.ENERGY, dam, emp, 100000.0f, "mote_attractor_targeted_ship", 40.0f, MoteControlScript.getEMPColor(ship), new Color(255, 255, 255, 255));
            if (data.attractorLock != null) {
                arc.setTargetToShipCenter(slotLoc, data.attractorLock);
            }
            arc.setCoreWidthOverride(30.0f);
            if (data.attractorLock == null) {
                Global.getSoundPlayer().playSound("mote_attractor_targeted_empty_space", 1.0f, 1.0f, data.attractorTarget, new Vector2f());
            }
            engine.removeEntity(asteroid);
        }
    }

    protected void spawnAttractorParticles(ShipAPI ship) {
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    public void calculateTargetData(ShipAPI ship) {
        SharedMoteAIData data = MoteControlScript.getSharedData(ship);
        Vector2f targetLoc = this.getTargetLoc(ship);
        data.attractorLock = this.getLockTarget(ship, targetLoc);
        data.attractorRemaining = ATTRACTOR_DURATION;
        if (data.attractorLock != null) {
            targetLoc = new Vector2f((ReadableVector2f)data.attractorLock.getLocation());
            data.attractorRemaining = ATTRACTOR_DURATION_LOCK;
        }
        data.attractorTarget = targetLoc;
        if (data.attractorLock != null) {
            Global.getCombatEngine().addPlugin(this.createTargetJitterPlugin(data.attractorLock, ship.getSystem().getChargeUpDur(), ship.getSystem().getChargeDownDur(), MoteControlScript.getJitterColor(ship)));
        }
    }

    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        if (system.isOutOfAmmo()) {
            return null;
        }
        if (system.getState() != ShipSystemAPI.SystemState.IDLE) {
            return null;
        }
        boolean inRange = this.isMouseInRange(ship);
        if (!inRange) {
            return "\u8d85\u51fa\u8303\u56f4";
        }
        return null;
    }

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        return true;
    }

    public Vector2f getTargetedLocation(ShipAPI from) {
        Vector2f loc = from.getSystem().getTargetLoc();
        if (loc == null) {
            loc = new Vector2f((ReadableVector2f)from.getMouseTarget());
        }
        return loc;
    }

    public Vector2f getTargetLoc(ShipAPI from) {
        this.findSlots(from);
        Vector2f slotLoc = this.attractor.computePosition(from);
        Vector2f targetLoc = new Vector2f((ReadableVector2f)this.getTargetedLocation(from));
        float dist = Misc.getDistance(slotLoc, targetLoc);
        if (dist > MoteControlScript.getRange(from)) {
            targetLoc = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(slotLoc, targetLoc));
            targetLoc.scale(MoteControlScript.getRange(from));
            Vector2f.add((Vector2f)targetLoc, (Vector2f)slotLoc, (Vector2f)targetLoc);
        }
        return targetLoc;
    }

    public boolean isMouseInRange(ShipAPI from) {
        Vector2f targetLoc = new Vector2f((ReadableVector2f)from.getMouseTarget());
        return this.isLocationInRange(from, targetLoc);
    }

    public boolean isLocationInRange(ShipAPI from, Vector2f loc) {
        this.findSlots(from);
        Vector2f slotLoc = this.attractor.computePosition(from);
        float dist = Misc.getDistance(slotLoc, loc);
        return !(dist > MoteControlScript.getRange(from));
    }

    public ShipAPI getLockTarget(ShipAPI from, Vector2f loc) {
        Vector2f slotLoc = this.attractor.computePosition(from);
        for (ShipAPI other : Global.getCombatEngine().getShips()) {
            float dist;
            if (other.isFighter() || other.getOwner() == from.getOwner() || other.isHulk() || !other.isTargetable() || (dist = Misc.getDistance(slotLoc, other.getLocation())) > MoteControlScript.getRange(from) || !((dist = Misc.getDistance(loc, other.getLocation())) < other.getCollisionRadius() + 50.0f)) continue;
            return other;
        }
        return null;
    }

    public static float getRange(ShipAPI ship) {
        if (ship == null) {
            return MAX_ATTRACTOR_RANGE;
        }
        return ship.getMutableStats().getSystemRangeBonus().computeEffective(MAX_ATTRACTOR_RANGE);
    }

    protected EveryFrameCombatPlugin createTargetJitterPlugin(final ShipAPI target, final float in, final float out, final Color jitterColor) {
        return new BaseEveryFrameCombatPlugin(){
            float elapsed = 0.0f;

            @Override
            public void advance(float amount, List<InputEventAPI> events) {
                if (Global.getCombatEngine().isPaused()) {
                    return;
                }
                this.elapsed += amount;
                float level = 0.0f;
                if (this.elapsed < in) {
                    level = this.elapsed / in;
                } else if (this.elapsed < in + out) {
                    level = 1.0f - (this.elapsed - in) / out;
                    level *= level;
                } else {
                    Global.getCombatEngine().removePlugin(this);
                    return;
                }
                if (level > 0.0f) {
                    float jitterLevel = level;
                    float maxRangeBonus = 50.0f;
                    float jitterRangeBonus = jitterLevel * maxRangeBonus;
                    target.setJitterUnder(this, jitterColor, jitterLevel, 10, 0.0f, jitterRangeBonus);
                    target.setJitter(this, jitterColor, jitterLevel, 4, 0.0f, 0.0f + jitterRangeBonus);
                }
            }
        };
    }

    public static class MoteData {
        public Color jitterColor;
        public Color empColor;
        public int maxMotes;
        public float antiFighterDamage;
        public String impactSound;
        public String loopSound;
    }

    public static class SharedMoteAIData {
        public float elapsed = 0.0f;
        public List<MissileAPI> motes = new ArrayList<MissileAPI>();
        public float attractorRemaining = 0.0f;
        public Vector2f attractorTarget = null;
        public ShipAPI attractorLock = null;
    }
}

