/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.impl.combat.MoteControlScript;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class MoteOnHitEffect
implements OnHitEffectPlugin {
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        boolean withEMP = false;
        if (target instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)target;
            if (!ship.isFighter()) {
                boolean piercedShield;
                float pierceChance = 1.0f;
                boolean bl = piercedShield = shieldHit && (float)Math.random() < (pierceChance *= ship.getMutableStats().getDynamic().getValue("shield_pierced_mult"));
                if (!shieldHit || piercedShield) {
                    float emp = projectile.getEmpAmount();
                    float dam = projectile.getDamageAmount();
                    engine.spawnEmpArcPierceShields(projectile.getSource(), point, target, target, projectile.getDamageType(), dam, emp, 100000.0f, "mote_attractor_impact_emp_arc", 20.0f, MoteControlScript.getEMPColor(projectile.getSource()), new Color(255, 255, 255, 255));
                    withEMP = true;
                }
            } else {
                float damage = MoteControlScript.getAntiFighterDamage(projectile.getSource());
                Global.getCombatEngine().applyDamage(projectile, ship, point, damage, DamageType.ENERGY, 0.0f, false, false, projectile.getSource(), true);
            }
        } else if (target instanceof MissileAPI) {
            float damage = MoteControlScript.getAntiFighterDamage(projectile.getSource());
            Global.getCombatEngine().applyDamage(projectile, target, point, damage, DamageType.ENERGY, 0.0f, false, false, projectile.getSource(), true);
        }
        String impactSoundId = MoteControlScript.getImpactSoundId(projectile.getSource());
        Global.getSoundPlayer().playSound(impactSoundId, 1.0f, 1.0f, point, new Vector2f());
    }
}

