/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.combat.RiftCascadeEffect;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Noise;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NegativeExplosionVisual
extends BaseCombatLayeredRenderingPlugin {
    protected FaderUtil fader;
    protected SpriteAPI atmosphereTex;
    protected float[] noise;
    protected float[] noise1;
    protected float[] noise2;
    protected NEParams p;
    protected int segments;
    protected float noiseElapsed = 0.0f;
    protected boolean spawnedHitGlow = false;

    public NegativeExplosionVisual(NEParams p) {
        this.p = p;
    }

    @Override
    public float getRenderRadius() {
        return this.p.radius + 500.0f;
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return EnumSet.of(CombatEngineLayers.ABOVE_PARTICLES_LOWER, CombatEngineLayers.ABOVE_PARTICLES);
    }

    @Override
    public void advance(float amount) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.fader.advance(amount);
        if (this.p.noiseMag > 0.0f) {
            this.noiseElapsed += amount;
            if (this.noiseElapsed > this.p.noisePeriod) {
                this.noiseElapsed = 0.0f;
                this.noise1 = Arrays.copyOf(this.noise2, this.noise2.length);
                this.noise2 = Noise.genNoise(this.segments, this.p.noiseMag);
            }
            float f = this.noiseElapsed / this.p.noisePeriod;
            int i = 0;
            while (i < this.noise.length) {
                float n1 = this.noise1[i];
                float n2 = this.noise2[i];
                this.noise[i] = n1 + (n2 - n1) * f;
                ++i;
            }
        }
        if (!this.p.withHitGlow) {
            return;
        }
        float glowSpawnAt = 1.0f;
        if (!(this.spawnedHitGlow || this.fader.isFadingIn() && !(this.fader.getBrightness() >= this.p.spawnHitGlowAt))) {
            float size = Math.min(this.p.radius * 7.0f, this.p.radius + 150.0f);
            float coreSize = Math.max(size, this.p.radius * 4.0f);
            if (coreSize > size) {
                size = coreSize;
            }
            size *= this.p.hitGlowSizeMult;
            coreSize *= this.p.hitGlowSizeMult;
            CombatEngineAPI engine = Global.getCombatEngine();
            Vector2f point = this.entity.getLocation();
            Vector2f vel = this.entity.getVelocity();
            float dur = this.fader.getDurationOut() * glowSpawnAt;
            engine.addHitParticle(point, vel, size * 3.0f, 1.0f, dur, this.p.color);
            engine.addHitParticle(point, vel, coreSize * 1.5f, 1.0f, dur, Color.white);
            Color invert = this.p.color;
            if (this.p.invertForDarkening != null) {
                invert = this.p.invertForDarkening;
            }
            Color c = new Color(255 - invert.getRed(), 255 - invert.getGreen(), 255 - invert.getBlue(), 127);
            c = Misc.interpolateColor(c, Color.white, 0.4f);
            float durMult = 1.0f;
            int i = 0;
            while (i < 7) {
                dur = 4.0f + 4.0f * (float)Math.random();
                dur *= durMult;
                dur *= 0.5f;
                float nSize = size * 1.0f;
                Vector2f pt = Misc.getPointAtRadius(point, nSize * 0.5f);
                Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
                v.scale(nSize + nSize * (float)Math.random() * 0.5f);
                v.scale(0.15f);
                Vector2f.add((Vector2f)vel, (Vector2f)v, (Vector2f)v);
                v = new Vector2f((ReadableVector2f)this.entity.getVelocity());
                engine.addNegativeNebulaParticle(pt, v, nSize * 1.0f, 2.0f, this.p.fadeIn / dur, 0.0f, dur, c);
                ++i;
            }
            dur = this.p.fadeIn + this.p.fadeOut + 2.0f;
            float rampUp = (this.p.fadeIn + this.p.fadeOut) / (dur *= durMult);
            rampUp = 0.0f;
            c = this.p.underglow;
            int i2 = 0;
            while (i2 < 15) {
                Vector2f loc = new Vector2f((ReadableVector2f)point);
                loc = Misc.getPointWithinRadius(loc, size * 1.0f);
                float s = size * 3.0f * (0.25f + (float)Math.random() * 0.25f);
                engine.addNebulaParticle(loc, this.entity.getVelocity(), s, 1.5f, rampUp, 0.0f, dur, c);
                ++i2;
            }
            this.spawnedHitGlow = true;
        }
    }

    @Override
    public void init(CombatEntityAPI entity) {
        super.init(entity);
        this.fader = new FaderUtil(0.0f, this.p.fadeIn, this.p.fadeOut);
        this.fader.setBounceDown(true);
        this.fader.fadeIn();
        this.atmosphereTex = Global.getSettings().getSprite("combat", "corona_hard");
        float perSegment = 2.0f;
        this.segments = (int)(this.p.radius * 2.0f * 3.14f / perSegment);
        if (this.segments < 8) {
            this.segments = 8;
        }
        this.noise1 = Noise.genNoise(this.segments, this.p.noiseMag);
        this.noise2 = Noise.genNoise(this.segments, this.p.noiseMag);
        this.noise = Arrays.copyOf(this.noise1, this.noise1.length);
    }

    @Override
    public boolean isExpired() {
        return this.fader.isFadedOut();
    }

    @Override
    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float f = this.fader.getBrightness();
        float alphaMult = viewport.getAlphaMult();
        if (f < 0.5f) {
            alphaMult *= f * 2.0f;
        }
        float r = this.p.radius;
        float tSmall = this.p.thickness;
        if (this.fader.isFadingIn()) {
            r = (float)((double)r * (0.75 + Math.sqrt(f) * 0.25));
        } else {
            tSmall = Math.min((r *= 0.1f + 0.9f * f) * 1.0f, this.p.thickness);
        }
        if (layer == CombatEngineLayers.ABOVE_PARTICLES_LOWER) {
            float a = 1.0f;
            this.renderAtmosphere(x, y, r, tSmall, alphaMult * a, this.segments, this.atmosphereTex, this.noise, this.p.color, true);
            this.renderAtmosphere(x, y, r - 2.0f, tSmall, alphaMult * a, this.segments, this.atmosphereTex, this.noise, this.p.color, true);
        } else if (layer == CombatEngineLayers.ABOVE_PARTICLES) {
            float circleAlpha = 1.0f;
            if (alphaMult < 0.5f) {
                circleAlpha = alphaMult * 2.0f;
            }
            float tCircleBorder = 1.0f;
            this.renderCircle(x, y, r, circleAlpha, this.segments, Color.black);
            this.renderAtmosphere(x, y, r, tCircleBorder, circleAlpha, this.segments, this.atmosphereTex, this.noise, Color.black, false);
        }
    }

    private void renderCircle(float x, float y, float radius, float alphaMult, int segments, Color color) {
        if (this.fader.isFadingIn()) {
            alphaMult = 1.0f;
        }
        float startRad = (float)Math.toRadians(0.0);
        float endRad = (float)Math.toRadians(360.0);
        float spanRad = Misc.normalizeAngle(endRad - startRad);
        float anglePerSegment = spanRad / (float)segments;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
        GL11.glBegin((int)6);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        float i = 0.0f;
        while (i < (float)(segments + 1)) {
            boolean last;
            boolean bl = last = i == (float)segments;
            if (last) {
                i = 0.0f;
            }
            float theta = anglePerSegment * i;
            float cos = (float)Math.cos(theta);
            float sin = (float)Math.sin(theta);
            float m1 = 0.75f + 0.65f * this.noise[(int)i];
            if (this.p.noiseMag <= 0.0f) {
                m1 = 1.0f;
            }
            float x1 = cos * radius * m1;
            float y1 = sin * radius * m1;
            GL11.glVertex2f((float)x1, (float)y1);
            if (last) break;
            i += 1.0f;
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private void renderAtmosphere(float x, float y, float radius, float thickness, float alphaMult, int segments, SpriteAPI tex, float[] noise, Color color, boolean additive) {
        float startRad = (float)Math.toRadians(0.0);
        float endRad = (float)Math.toRadians(360.0);
        float spanRad = Misc.normalizeAngle(endRad - startRad);
        float anglePerSegment = spanRad / (float)segments;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        tex.bindTexture();
        GL11.glEnable((int)3042);
        if (additive) {
            GL11.glBlendFunc((int)770, (int)1);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
        float texX = 0.0f;
        float incr = 1.0f / (float)segments;
        GL11.glBegin((int)8);
        float i = 0.0f;
        while (i < (float)(segments + 1)) {
            float m1;
            boolean last;
            boolean bl = last = i == (float)segments;
            if (last) {
                i = 0.0f;
            }
            float theta = anglePerSegment * i;
            float cos = (float)Math.cos(theta);
            float sin = (float)Math.sin(theta);
            float m2 = m1 = 0.75f + 0.65f * noise[(int)i];
            if (this.p.noiseMag <= 0.0f) {
                m1 = 1.0f;
                m2 = 1.0f;
            }
            float x1 = cos * radius * m1;
            float y1 = sin * radius * m1;
            float x2 = cos * (radius + thickness * m2);
            float y2 = sin * (radius + thickness * m2);
            GL11.glTexCoord2f((float)0.5f, (float)0.05f);
            GL11.glVertex2f((float)x1, (float)y1);
            GL11.glTexCoord2f((float)0.5f, (float)0.95f);
            GL11.glVertex2f((float)x2, (float)y2);
            texX += incr;
            if (last) break;
            i += 1.0f;
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static class NEParams
    implements Cloneable {
        public float fadeIn = 0.1f;
        public float fadeOut = 0.5f;
        public float spawnHitGlowAt = 0.0f;
        public float hitGlowSizeMult = 0.75f;
        public float radius = 20.0f;
        public float thickness = 25.0f;
        public float noiseMag = 1.0f;
        public float noisePeriod = 0.1f;
        public boolean withHitGlow = true;
        public Color color = new Color(100, 100, 255);
        public Color underglow = RiftCascadeEffect.EXPLOSION_UNDERCOLOR;
        public Color invertForDarkening = null;

        public NEParams() {
        }

        public NEParams(float radius, float thickness, Color color) {
            this.radius = radius;
            this.thickness = thickness;
            this.color = color;
        }

        protected NEParams clone() {
            try {
                return (NEParams)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

