/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class OrionDeviceStats
extends BaseShipSystemScript {
    protected OrionDeviceParams p = new OrionDeviceParams();
    protected PusherPlateState pusherState = new PusherPlateState();
    protected Color orig = null;
    protected boolean wasIdle = false;
    protected boolean deployedBomb = false;

    public OrionDeviceStats() {
        this.p = new OrionDeviceParams();
    }

    protected void recolor(ShipAPI ship) {
        if (ship == null) {
            return;
        }
        if (!this.p.recolorTowardsEngineColor) {
            return;
        }
        if (this.orig == null) {
            this.orig = this.p.shapedExplosionColor;
        }
        Color curr = ship.getEngineController().getFlameColorShifter().getCurr();
        this.p.shapedExplosionColor = Misc.interpolateColor(this.orig, curr, 0.75f);
        this.p.shapedExplosionColor = Misc.setAlpha(this.p.shapedExplosionColor, this.orig.getAlpha());
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        this.recolor(ship);
        if (effectLevel >= 1.0f && !this.deployedBomb) {
            for (WeaponSlotAPI slot : ship.getHullSpec().getAllWeaponSlotsCopy()) {
                if (!slot.isSystemSlot()) continue;
                this.spawnBomb(ship, slot);
            }
            this.deployedBomb = true;
        } else if (state == ShipSystemStatsScript.State.COOLDOWN) {
            this.deployedBomb = false;
        }
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        this.pusherState.advance(amount);
        for (WeaponAPI w : ship.getAllWeapons()) {
            Vector2f offset = new Vector2f(this.p.pusherPlateMaxOffset, 0.0f);
            offset.scale(this.pusherState.compression);
            if (!w.getSpec().hasTag("pusherplate")) continue;
            w.setRenderOffsetForDecorativeBeamWeaponsOnly(offset);
        }
        this.advanceImpl(amount, ship, state, effectLevel);
    }

    protected void advanceImpl(float amount, ShipAPI ship, ShipSystemStatsScript.State state, float effectLevel) {
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    public void spawnBomb(ShipAPI source, WeaponSlotAPI slot) {
        CombatEngineAPI engine = Global.getCombatEngine();
        Vector2f loc = slot.computePosition(source);
        float angle = slot.computeMidArcAngle(source);
        if (this.pusherState.compression > 0.0f) {
            Vector2f offset = new Vector2f(this.p.pusherPlateMaxOffset, 0.0f);
            offset.scale(this.pusherState.compression);
            offset = Misc.rotateAroundOrigin(offset, source.getFacing());
            Vector2f.add((Vector2f)loc, (Vector2f)offset, (Vector2f)loc);
        }
        MissileAPI bomb = (MissileAPI)engine.spawnProjectile(source, null, this.p.bombWeaponId, loc, angle, source.getVelocity());
        if (source != null) {
            Global.getCombatEngine().applyDamageModifiersToSpawnedProjectileWithNullWeapon(source, WeaponAPI.WeaponType.MISSILE, false, bomb.getDamage());
        }
        float fadeInTime = this.p.bombFadeInTime;
        Vector2f inheritedVel = new Vector2f((ReadableVector2f)source.getVelocity());
        inheritedVel.scale(this.p.bombInheritedVelocityFraction);
        float speed = this.p.bombSpeed;
        Vector2f vel = Misc.getUnitVectorAtDegreeAngle(angle);
        vel.scale(speed);
        Vector2f.add((Vector2f)vel, (Vector2f)inheritedVel, (Vector2f)vel);
        bomb.getVelocity().set((ReadableVector2f)vel);
        bomb.fadeOutThenIn(fadeInTime);
        bomb.setCollisionClass(CollisionClass.NONE);
        bomb.setEmpResistance(1000);
        bomb.setEccmChanceOverride(1.0f);
        float liveTime = this.p.bombLiveTime;
        bomb.setMaxFlightTime(liveTime);
        Global.getCombatEngine().addPlugin(this.createBombImpactPlugin(source, slot, bomb, loc, angle));
    }

    protected void notifySpawnedExplosionParticles(Vector2f bombLoc) {
    }

    protected EveryFrameCombatPlugin createBombImpactPlugin(final ShipAPI ship, final WeaponSlotAPI launchSlot, final MissileAPI bomb, final Vector2f launchLoc, float launchAngle) {
        return new BaseEveryFrameCombatPlugin(){
            float elapsed = 0.0f;
            float impactTime = 0.0f;
            float brakingTime = 0.0f;
            float forceAngle;
            float jitterTime = 0.0f;
            boolean triggered = false;
            boolean braking = false;
            boolean done = false;

            @Override
            public void advance(float amount, List<InputEventAPI> events) {
                if (Global.getCombatEngine().isPaused()) {
                    return;
                }
                this.elapsed += amount;
                String impactCounterId = "od_system_counter";
                if (bomb.isFizzling() && !this.triggered) {
                    OrionDeviceStats.this.pusherState.addImpulse(OrionDeviceStats.this.p.pusherPlateImpulseForce, OrionDeviceStats.this.p.pusherPlateImpulseDuration);
                    this.forceAngle = Misc.getAngleInDegrees(bomb.getLocation(), launchSlot.computePosition(ship));
                    float angleToShip = Misc.getAngleInDegrees(bomb.getLocation(), ship.getLocation());
                    if (Misc.getAngleDiff(angleToShip, this.forceAngle) > 90.0f) {
                        this.forceAngle += 180.0f;
                    }
                    float diff = Misc.getAngleDiff(angleToShip, this.forceAngle);
                    float turnDir = Misc.getClosestTurnDirection(angleToShip, this.forceAngle);
                    this.forceAngle = angleToShip + diff * turnDir * 0.2f;
                    this.triggered = true;
                    ship.getMutableStats().getDynamic().getMod(impactCounterId).modifyFlat("od_launch_" + launchLoc, 1.0f);
                    if (Global.getCombatEngine().getViewport().isNearViewport(ship.getLocation(), 800.0f)) {
                        float angle = this.forceAngle + 180.0f;
                        int numParticles = OrionDeviceStats.this.p.shapedExplosionNumParticles;
                        float minSize = OrionDeviceStats.this.p.shapedExplosionMinParticleSize;
                        float maxSize = OrionDeviceStats.this.p.shapedExplosionMaxParticleSize;
                        Color pc = OrionDeviceStats.this.p.shapedExplosionColor;
                        float minDur = OrionDeviceStats.this.p.shapedExplosionMinParticleDur;
                        float maxDur = OrionDeviceStats.this.p.shapedExplosionMaxParticleDur;
                        float arc = OrionDeviceStats.this.p.shapedExplosionArc;
                        float scatter = OrionDeviceStats.this.p.shapedExplosionScatter;
                        float minVel = OrionDeviceStats.this.p.shapedExplosionMinParticleVel;
                        float maxVel = OrionDeviceStats.this.p.shapedExplosionMaxParticleVel;
                        float launchOffset = OrionDeviceStats.this.p.shapedExplosionOffset;
                        float endSizeMin = OrionDeviceStats.this.p.shapedExplosionEndSizeMin;
                        float endSizeMax = OrionDeviceStats.this.p.shapedExplosionEndSizeMax;
                        Vector2f spawnPoint = Misc.getUnitVectorAtDegreeAngle(this.forceAngle);
                        spawnPoint.scale(launchOffset);
                        Vector2f.add((Vector2f)bomb.getLocation(), (Vector2f)spawnPoint, (Vector2f)spawnPoint);
                        int i = 0;
                        while (i < numParticles) {
                            float angleOffset = (float)Math.random();
                            if (angleOffset > 0.2f) {
                                angleOffset *= angleOffset;
                            }
                            float speedMult = 1.0f - angleOffset;
                            speedMult = 0.5f + speedMult * 0.5f;
                            angleOffset *= Math.signum((float)Math.random() - 0.5f);
                            float theta = (float)Math.toRadians(angle + (angleOffset *= arc / 2.0f));
                            float r = (float)(Math.random() * Math.random() * (double)scatter);
                            float x = (float)Math.cos(theta) * r;
                            float y = (float)Math.sin(theta) * r;
                            Vector2f pLoc = new Vector2f(spawnPoint.x + x, spawnPoint.y + y);
                            float speed = minVel + (maxVel - minVel) * (float)Math.random();
                            Vector2f pVel = Misc.getUnitVectorAtDegreeAngle((float)Math.toDegrees(theta));
                            pVel.scale(speed *= speedMult);
                            float pSize = minSize + (maxSize - minSize) * (float)Math.random();
                            float pDur = minDur + (maxDur - minDur) * (float)Math.random();
                            float endSize = endSizeMin + (endSizeMax - endSizeMin) * (float)Math.random();
                            Global.getCombatEngine().addNebulaParticle(pLoc, pVel, pSize, endSize, 0.1f, 0.5f, pDur, pc);
                            ++i;
                        }
                        OrionDeviceStats.this.notifySpawnedExplosionParticles(bomb.getLocation());
                    }
                }
                boolean multipleImpacts = ship.getMutableStats().getDynamic().getMod(impactCounterId).computeEffective(0.0f) > 1.0f;
                String id = "od_system_mod";
                ship.getMutableStats().getMaxSpeed().unmodifyFlat(id);
                float maxSpeedWithoutBonus = ship.getMutableStats().getMaxSpeed().getModifiedValue();
                if (this.triggered) {
                    float alt;
                    this.jitterTime += amount;
                    float intensity = bomb.getFlightTime() / bomb.getMaxFlightTime();
                    if (intensity > 1.0f) {
                        intensity = 1.0f;
                    }
                    if (this.triggered) {
                        intensity = 1.0f;
                    }
                    if (this.braking && (intensity = 1.0f - this.brakingTime * 2.0f) < 0.0f) {
                        intensity = 0.0f;
                    }
                    if ((alt = 1.0f - this.jitterTime / OrionDeviceStats.this.p.maxJitterDur) < intensity) {
                        intensity = Math.max(alt, 0.0f);
                    }
                    Color jc = OrionDeviceStats.this.p.jitterColor;
                    ship.setJitter(this, jc, intensity, 3, 0.0f, 0.0f);
                }
                if (this.triggered && !this.braking) {
                    this.impactTime += amount * OrionDeviceStats.this.p.impactRateMult;
                    float mag = (1.0f - this.impactTime) * (1.0f - this.impactTime);
                    if (mag > 0.0f) {
                        mag = (float)Math.sqrt(mag);
                    }
                    Vector2f forcePoint = launchSlot.computePosition(ship);
                    float dirToCenter = Misc.getAngleInDegrees(forcePoint, ship.getLocation());
                    float angleDiff = Misc.getAngleDiff(this.forceAngle, dirToCenter);
                    float totalAccel = OrionDeviceStats.this.p.impactAccel;
                    float portionAppliedToAngularVelocity = angleDiff * 1.0f / 90.0f;
                    if (portionAppliedToAngularVelocity > 1.0f) {
                        portionAppliedToAngularVelocity = 1.0f;
                    }
                    Vector2f acc = Misc.getUnitVectorAtDegreeAngle(this.forceAngle);
                    acc.scale(totalAccel * (1.0f - portionAppliedToAngularVelocity * 0.2f));
                    acc.scale(mag * amount);
                    Vector2f.add((Vector2f)ship.getVelocity(), (Vector2f)acc, (Vector2f)ship.getVelocity());
                    float angVelChange = portionAppliedToAngularVelocity * ship.getMaxTurnRate() * 0.25f;
                    angVelChange *= mag;
                    ship.setAngularVelocity(ship.getAngularVelocity() + (angVelChange *= Misc.getClosestTurnDirection(this.forceAngle, dirToCenter)) * amount);
                    float maxSpeedBoost = 1000.0f * Math.max(0.0f, (1.0f - portionAppliedToAngularVelocity) * 0.5f);
                    if (maxSpeedBoost > 0.0f) {
                        ship.getMutableStats().getMaxSpeed().modifyFlat(id, maxSpeedBoost);
                    } else {
                        ship.getMutableStats().getMaxSpeed().unmodifyFlat(id);
                    }
                    ship.getMutableStats().getDeceleration().modifyFlat(id, 1.0f * Math.max(maxSpeedWithoutBonus, ship.getVelocity().length() - maxSpeedWithoutBonus));
                    ship.blockCommandForOneFrame(ShipCommand.ACCELERATE);
                    ship.blockCommandForOneFrame(ShipCommand.ACCELERATE_BACKWARDS);
                    ship.giveCommand(ShipCommand.DECELERATE, null, 0);
                    if (this.impactTime >= 1.0f) {
                        this.braking = true;
                        ship.getMutableStats().getMaxSpeed().unmodify(id);
                    }
                }
                if (this.braking) {
                    if (!multipleImpacts) {
                        ship.getMutableStats().getDeceleration().modifyFlat(id, 2.0f * Math.max(maxSpeedWithoutBonus, ship.getVelocity().length() - maxSpeedWithoutBonus));
                        ship.blockCommandForOneFrame(ShipCommand.ACCELERATE);
                        ship.blockCommandForOneFrame(ShipCommand.ACCELERATE_BACKWARDS);
                        ship.giveCommand(ShipCommand.DECELERATE, null, 0);
                    }
                    this.brakingTime += amount;
                    float threshold = 3.0f;
                    if (multipleImpacts) {
                        threshold = 0.1f;
                    }
                    if (this.brakingTime >= threshold || ship.getVelocity().length() <= maxSpeedWithoutBonus) {
                        this.done = true;
                    }
                }
                if (!this.triggered && this.elapsed > 1.0f || this.done) {
                    Global.getCombatEngine().removePlugin(this);
                    ship.getMutableStats().getDeceleration().unmodify(id);
                    ship.getMutableStats().getMaxSpeed().unmodify(id);
                    ship.getMutableStats().getDynamic().getMod(impactCounterId).unmodifyFlat("od_launch_" + launchLoc);
                }
            }
        };
    }

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        if (ship.getEngineController().isFlamedOut() || ship.getEngineController().isFlamingOut()) {
            return false;
        }
        return super.isUsable(system, ship);
    }

    public static class OrionDeviceParams {
        public float bombFadeInTime = 0.15f;
        public float bombLiveTime = 0.25f;
        public float bombSpeed = 50.0f;
        public float bombInheritedVelocityFraction = 0.5f;
        public float shapedExplosionOffset = 50.0f;
        public float shapedExplosionEndSizeMin = 1.0f;
        public float shapedExplosionEndSizeMax = 2.0f;
        public Color shapedExplosionColor = new Color(255, 125, 25, 155);
        public int shapedExplosionNumParticles = 200;
        public float shapedExplosionMinParticleSize = 80.0f;
        public float shapedExplosionMaxParticleSize = 100.0f;
        public float shapedExplosionScatter = 100.0f;
        public float shapedExplosionMinParticleVel = 100.0f;
        public float shapedExplosionMaxParticleVel = 350.0f;
        public float shapedExplosionMinParticleDur = 1.0f;
        public float shapedExplosionMaxParticleDur = 2.0f;
        public float shapedExplosionArc = 90.0f;
        public Color jitterColor = new Color(255, 125, 25, 55);
        public float maxJitterDur = 2.0f;
        public float pusherPlateMaxOffset = 14.0f;
        public float pusherPlateImpulseForce = 10.0f;
        public float pusherPlateImpulseDuration = 0.2f;
        public float impactAccel = 5000.0f;
        public float impactRateMult = 4.0f;
        public boolean recolorTowardsEngineColor = false;
        public String bombWeaponId = "od_bomblauncher";
    }

    public static class PusherPlateImpulse {
        public float force;
        public float dur;
        public float elapsed;
    }

    public static class PusherPlateState {
        public float compression;
        public float vel;
        public List<PusherPlateImpulse> impulses = new ArrayList<PusherPlateImpulse>();

        public void addImpulse(float force, float dur) {
            PusherPlateImpulse ppi = new PusherPlateImpulse();
            ppi.force = force;
            ppi.dur = dur;
            this.impulses.add(ppi);
        }

        public void advance(float amount) {
            float min;
            ArrayList<PusherPlateImpulse> remove = new ArrayList<PusherPlateImpulse>();
            float totalForce = 0.0f;
            for (PusherPlateImpulse curr : this.impulses) {
                totalForce += curr.force;
                curr.elapsed += amount;
                if (!(curr.elapsed >= curr.dur)) continue;
                remove.add(curr);
            }
            this.impulses.removeAll(remove);
            float springForce = this.compression;
            float netForce = totalForce - springForce;
            this.vel += netForce * amount;
            this.compression += this.vel * amount;
            if (this.compression > 1.0f) {
                this.compression = 1.0f;
                this.vel = 0.0f;
            }
            if (this.compression < (min = 0.0f)) {
                this.compression = min;
                this.vel = 0.0f;
            }
        }
    }
}

