/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class PaladinEffect
implements BeamEffectPlugin {
    private boolean done = false;

    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        boolean first;
        if (this.done) {
            return;
        }
        CombatEntityAPI target = beam.getDamageTarget();
        boolean bl = first = beam.getWeapon().getBeams().indexOf(beam) == 0;
        if (target != null && beam.getBrightness() >= 1.0f && first) {
            Vector2f point = beam.getTo();
            float maxDist = 0.0f;
            for (BeamAPI curr : beam.getWeapon().getBeams()) {
                maxDist = Math.max(maxDist, Misc.getDistance(point, curr.getTo()));
            }
            if (maxDist < 15.0f) {
                DamagingProjectileAPI e = engine.spawnDamagingExplosion(this.createExplosionSpec(), beam.getSource(), point);
                e.addDamagedAlready(target);
                this.done = true;
            }
        }
    }

    public DamagingExplosionSpec createExplosionSpec() {
        float damage = 100.0f;
        DamagingExplosionSpec spec = new DamagingExplosionSpec(0.1f, 75.0f, 50.0f, damage, damage / 2.0f, CollisionClass.PROJECTILE_FF, CollisionClass.PROJECTILE_FIGHTER, 3.0f, 3.0f, 0.5f, 150, new Color(255, 255, 255, 255), new Color(255, 100, 100, 175));
        spec.setDamageType(DamageType.FRAGMENTATION);
        spec.setUseDetailedExplosion(false);
        spec.setSoundSetId("explosion_guardian");
        return spec;
    }
}

