/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.impl.combat.NegativeExplosionVisual;
import com.fs.starfarer.api.impl.combat.RiftCascadeEffect;
import com.fs.starfarer.api.impl.combat.RiftCascadeMineExplosion;
import com.fs.starfarer.api.impl.combat.RiftTrailEffect;
import com.fs.starfarer.api.loading.MissileSpecAPI;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RiftTorpedoEffect
implements OnFireEffectPlugin,
OnHitEffectPlugin {
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        Color color = RiftCascadeEffect.STANDARD_RIFT_COLOR;
        Object o = projectile.getWeapon().getSpec().getProjectileSpec();
        if (o instanceof MissileSpecAPI) {
            MissileSpecAPI spec = (MissileSpecAPI)o;
            color = spec.getExplosionColor();
        }
        NegativeExplosionVisual.NEParams p = RiftCascadeMineExplosion.createStandardRiftParams(color, 40.0f);
        p.fadeOut = 2.0f;
        p.hitGlowSizeMult = 1.0f;
        RiftCascadeMineExplosion.spawnStandardRift(projectile, p);
        Vector2f vel = new Vector2f();
        if (target != null) {
            vel.set((ReadableVector2f)target.getVelocity());
        }
        Global.getSoundPlayer().playSound("rifttorpedo_explosion", 1.0f, 1.0f, point, vel);
    }

    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        RiftTrailEffect trail = new RiftTrailEffect((MissileAPI)projectile, "rifttorpedo_loop");
        ((MissileAPI)projectile).setEmpResistance(1000);
        ((MissileAPI)projectile).setEccmChanceOverride(1.0f);
        Global.getCombatEngine().addPlugin(trail);
    }
}

